/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.security.TLSProtocolVersion;
import io.pravega.local.InProcPravegaCluster;
import io.pravega.local.SingleNodeConfig;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPravegaEmulator
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalPravegaEmulator.class);
    private int zkPort;
    private int controllerPort;
    private int segmentStorePort;
    private int restServerPort;
    private boolean enableRestServer;
    private boolean enableAuth;
    private boolean enableTls;
    private String[] tlsProtocolVersion;
    private String certFile;
    private String passwd;
    private String userName;
    private String passwdFile;
    private String keyFile;
    private boolean enableTlsReload;
    private String jksKeyFile;
    private String jksTrustFile;
    private String keyPasswordFile;
    private boolean enableMetrics;
    private boolean enableInfluxDB;
    private int metricsReportInterval;
    private boolean enabledAdminGateway;
    private int adminGatewayPort;
    private final InProcPravegaCluster inProcPravegaCluster;

    public static void main(String[] args) {
        try {
            ServiceBuilderConfig config = ServiceBuilderConfig.builder().include(System.getProperty("singlenode.configurationFile", "./config/standalone-config.properties")).include(System.getProperties()).build();
            SingleNodeConfig conf = (SingleNodeConfig)config.getConfig(SingleNodeConfig::builder);
            final LocalPravegaEmulator localPravega = LocalPravegaEmulator.builder().controllerPort(conf.getControllerPort()).segmentStorePort(conf.getSegmentStorePort()).zkPort(conf.getZkPort()).restServerPort(conf.getRestServerPort()).enableRestServer(conf.isEnableRestServer()).enableAuth(conf.isEnableAuth()).enableTls(conf.isEnableTls()).tlsProtocolVersion(conf.getTlsProtocolVersion()).enableMetrics(conf.isEnableMetrics()).enableInfluxDB(conf.isEnableInfluxDB()).metricsReportInterval(conf.getMetricsReportInterval()).certFile(conf.getCertFile()).keyFile(conf.getKeyFile()).enableTlsReload(conf.isEnableSegmentStoreTlsReload()).jksKeyFile(conf.getKeyStoreJKS()).jksTrustFile(conf.getTrustStoreJKS()).keyPasswordFile(conf.getKeyStoreJKSPasswordFile()).passwdFile(conf.getPasswdFile()).userName(conf.getUserName()).passwd(conf.getPasswd()).enabledAdminGateway(conf.isEnableAdminGateway()).adminGatewayPort(conf.getAdminGatewayPort()).build();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        localPravega.close();
                        log.info("ByeBye!");
                    }
                    catch (Exception e) {
                        log.warn("Exception running local Pravega emulator: " + e.getMessage());
                    }
                }
            });
            log.info("Starting Pravega Emulator with ports: ZK port {}, Controller port {}, SegmentStore port {}, Admin Gateway port {}", new Object[]{conf.getZkPort(), conf.getControllerPort(), conf.getSegmentStorePort(), conf.getAdminGatewayPort()});
            localPravega.start();
            log.info("");
            log.info("Pravega Sandbox is running locally now. You could access it at {}:{}.", (Object)"127.0.0.1", (Object)conf.getControllerPort());
            log.info("For more detailed logs, see: {}/{}", (Object)System.getProperty("user.dir"), (Object)"standalone/standalone.log");
            log.info("");
        }
        catch (Exception ex) {
            log.error("Exception occurred running emulator", (Throwable)ex);
            System.exit(1);
        }
    }

    @Override
    public void close() throws Exception {
        this.inProcPravegaCluster.close();
    }

    public void start() throws Exception {
        log.info("\n{}", (Object)this.inProcPravegaCluster.print());
        this.inProcPravegaCluster.start();
    }

    @ConstructorProperties(value={"zkPort", "controllerPort", "segmentStorePort", "restServerPort", "enableRestServer", "enableAuth", "enableTls", "tlsProtocolVersion", "certFile", "passwd", "userName", "passwdFile", "keyFile", "enableTlsReload", "jksKeyFile", "jksTrustFile", "keyPasswordFile", "enableMetrics", "enableInfluxDB", "metricsReportInterval", "enabledAdminGateway", "adminGatewayPort", "inProcPravegaCluster"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    LocalPravegaEmulator(int zkPort, int controllerPort, int segmentStorePort, int restServerPort, boolean enableRestServer, boolean enableAuth, boolean enableTls, String[] tlsProtocolVersion, String certFile, String passwd, String userName, String passwdFile, String keyFile, boolean enableTlsReload, String jksKeyFile, String jksTrustFile, String keyPasswordFile, boolean enableMetrics, boolean enableInfluxDB, int metricsReportInterval, boolean enabledAdminGateway, int adminGatewayPort, InProcPravegaCluster inProcPravegaCluster) {
        this.zkPort = zkPort;
        this.controllerPort = controllerPort;
        this.segmentStorePort = segmentStorePort;
        this.restServerPort = restServerPort;
        this.enableRestServer = enableRestServer;
        this.enableAuth = enableAuth;
        this.enableTls = enableTls;
        this.tlsProtocolVersion = tlsProtocolVersion;
        this.certFile = certFile;
        this.passwd = passwd;
        this.userName = userName;
        this.passwdFile = passwdFile;
        this.keyFile = keyFile;
        this.enableTlsReload = enableTlsReload;
        this.jksKeyFile = jksKeyFile;
        this.jksTrustFile = jksTrustFile;
        this.keyPasswordFile = keyPasswordFile;
        this.enableMetrics = enableMetrics;
        this.enableInfluxDB = enableInfluxDB;
        this.metricsReportInterval = metricsReportInterval;
        this.enabledAdminGateway = enabledAdminGateway;
        this.adminGatewayPort = adminGatewayPort;
        this.inProcPravegaCluster = inProcPravegaCluster;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LocalPravegaEmulatorBuilder builder() {
        return new LocalPravegaEmulatorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public InProcPravegaCluster getInProcPravegaCluster() {
        return this.inProcPravegaCluster;
    }

    public static final class LocalPravegaEmulatorBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int zkPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int controllerPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int segmentStorePort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int restServerPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableRestServer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableAuth;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTls;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String certFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String passwd;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String userName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String passwdFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableTlsReload;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String jksKeyFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String jksTrustFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableMetrics;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enableInfluxDB;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int metricsReportInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean enabledAdminGateway;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int adminGatewayPort;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private InProcPravegaCluster inProcPravegaCluster;
        private String[] tlsProtocolVersion = new TLSProtocolVersion((String)SingleNodeConfig.TLS_PROTOCOL_VERSION.getDefaultValue()).getProtocols();

        public LocalPravegaEmulator build() {
            this.inProcPravegaCluster = InProcPravegaCluster.builder().isInProcZK(true).secureZK(this.enableTls).zkUrl("localhost:" + this.zkPort).zkPort(this.zkPort).isInMemStorage(true).isInProcController(true).controllerCount(1).isInProcSegmentStore(true).segmentStoreCount(1).containerCount(1).restServerPort(this.restServerPort).enableRestServer(this.enableRestServer).enableAuth(this.enableAuth).enableTls(this.enableTls).tlsProtocolVersion(this.tlsProtocolVersion).certFile(this.certFile).keyFile(this.keyFile).enableTlsReload(this.enableTlsReload).jksKeyFile(this.jksKeyFile).jksTrustFile(this.jksTrustFile).keyPasswordFile(this.keyPasswordFile).passwdFile(this.passwdFile).userName(this.userName).passwd(this.passwd).enableMetrics(this.enableMetrics).enableInfluxDB(this.enableInfluxDB).metricsReportInterval(this.metricsReportInterval).enableAdminGateway(this.enabledAdminGateway).adminGatewayPort(this.adminGatewayPort).replyWithStackTraceOnError(true).build();
            this.inProcPravegaCluster.setControllerPorts(new int[]{this.controllerPort});
            this.inProcPravegaCluster.setSegmentStorePorts(new int[]{this.segmentStorePort});
            return new LocalPravegaEmulator(this.zkPort, this.controllerPort, this.segmentStorePort, this.restServerPort, this.enableRestServer, this.enableAuth, this.enableTls, this.tlsProtocolVersion, this.certFile, this.passwd, this.userName, this.passwdFile, this.keyFile, this.enableTlsReload, this.jksKeyFile, this.jksTrustFile, this.keyPasswordFile, this.enableMetrics, this.enableInfluxDB, this.metricsReportInterval, this.enabledAdminGateway, this.adminGatewayPort, this.inProcPravegaCluster);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LocalPravegaEmulatorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder controllerPort(int controllerPort) {
            this.controllerPort = controllerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder segmentStorePort(int segmentStorePort) {
            this.segmentStorePort = segmentStorePort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder restServerPort(int restServerPort) {
            this.restServerPort = restServerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableRestServer(boolean enableRestServer) {
            this.enableRestServer = enableRestServer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableAuth(boolean enableAuth) {
            this.enableAuth = enableAuth;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableTls(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder tlsProtocolVersion(String[] tlsProtocolVersion) {
            this.tlsProtocolVersion = tlsProtocolVersion;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder certFile(String certFile) {
            this.certFile = certFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder passwdFile(String passwdFile) {
            this.passwdFile = passwdFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableTlsReload(boolean enableTlsReload) {
            this.enableTlsReload = enableTlsReload;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder jksKeyFile(String jksKeyFile) {
            this.jksKeyFile = jksKeyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder jksTrustFile(String jksTrustFile) {
            this.jksTrustFile = jksTrustFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder keyPasswordFile(String keyPasswordFile) {
            this.keyPasswordFile = keyPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enableInfluxDB(boolean enableInfluxDB) {
            this.enableInfluxDB = enableInfluxDB;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder metricsReportInterval(int metricsReportInterval) {
            this.metricsReportInterval = metricsReportInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder enabledAdminGateway(boolean enabledAdminGateway) {
            this.enabledAdminGateway = enabledAdminGateway;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder adminGatewayPort(int adminGatewayPort) {
            this.adminGatewayPort = adminGatewayPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LocalPravegaEmulatorBuilder inProcPravegaCluster(InProcPravegaCluster inProcPravegaCluster) {
            this.inProcPravegaCluster = inProcPravegaCluster;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LocalPravegaEmulator.LocalPravegaEmulatorBuilder(zkPort=" + this.zkPort + ", controllerPort=" + this.controllerPort + ", segmentStorePort=" + this.segmentStorePort + ", restServerPort=" + this.restServerPort + ", enableRestServer=" + this.enableRestServer + ", enableAuth=" + this.enableAuth + ", enableTls=" + this.enableTls + ", tlsProtocolVersion=" + Arrays.deepToString(this.tlsProtocolVersion) + ", certFile=" + this.certFile + ", passwd=" + this.passwd + ", userName=" + this.userName + ", passwdFile=" + this.passwdFile + ", keyFile=" + this.keyFile + ", enableTlsReload=" + this.enableTlsReload + ", jksKeyFile=" + this.jksKeyFile + ", jksTrustFile=" + this.jksTrustFile + ", keyPasswordFile=" + this.keyPasswordFile + ", enableMetrics=" + this.enableMetrics + ", enableInfluxDB=" + this.enableInfluxDB + ", metricsReportInterval=" + this.metricsReportInterval + ", enabledAdminGateway=" + this.enabledAdminGateway + ", adminGatewayPort=" + this.adminGatewayPort + ", inProcPravegaCluster=" + this.inProcPravegaCluster + ")";
        }
    }
}

