/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.security.TLSProtocolVersion;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import lombok.Generated;

public class SingleNodeConfig {
    public static final String PROPERTY_FILE = "singlenode.configurationFile";
    public static final Property<Integer> ZK_PORT = Property.named((String)"zk.port", (Object)4000, (String)"zkPort");
    public static final Property<Integer> SEGMENTSTORE_PORT = Property.named((String)"segmentStore.port", (Object)6000, (String)"segmentstorePort");
    public static final Property<Boolean> ENABLE_TLS_RELOAD = Property.named((String)"segmentStore.tls.certificate.autoReload.enable", (Object)false, (String)"segmentstoreEnableTlsReload");
    public static final Property<Integer> CONTROLLER_PORT = Property.named((String)"controller.rpc.port", (Object)9090, (String)"controllerPort");
    public static final Property<Integer> REST_SERVER_PORT = Property.named((String)"controller.rest.port", (Object)9091, (String)"restServerPort");
    public static final Property<Boolean> ENABLE_REST_SERVER = Property.named((String)"controller.rest.enable", (Object)true, (String)"enableRestServer");
    public static final Property<Boolean> ENABLE_AUTH = Property.named((String)"security.auth.enable", (Object)false, (String)"enableAuth");
    public static final Property<String> USER_NAME = Property.named((String)"security.auth.credentials.username", (Object)"", (String)"userName");
    public static final Property<String> PASSWD = Property.named((String)"security.auth.credentials.pwd", (Object)"", (String)"passwd");
    public static final Property<String> PASSWD_FILE = Property.named((String)"security.auth.pwdAuthHandler.accountsDb.location", (Object)"", (String)"passwdFile");
    public static final Property<Boolean> ENABLE_TLS = Property.named((String)"security.tls.enable", (Object)false, (String)"enableTls");
    public static final Property<String> TLS_PROTOCOL_VERSION = Property.named((String)"security.tls.protocolVersion", (Object)"TLSv1.2,TLSv1.3");
    public static final Property<String> KEY_FILE = Property.named((String)"security.tls.privateKey.location", (Object)"", (String)"keyFile");
    public static final Property<String> CERT_FILE = Property.named((String)"security.tls.certificate.location", (Object)"", (String)"certFile");
    public static final Property<String> KEYSTORE_JKS = Property.named((String)"security.tls.keyStore.location", (Object)"", (String)"keyStoreJKS");
    public static final Property<String> KEYSTORE_JKS_PASSWORD_FILE = Property.named((String)"security.tls.keyStore.pwd.location", (Object)"", (String)"keyStoreJKSPasswordFile");
    public static final Property<String> TRUSTSTORE_JKS = Property.named((String)"security.tls.trustStore.location", (Object)"", (String)"trustStoreJKS");
    public static final Property<Boolean> ENABLE_METRICS = Property.named((String)"metrics.enable", (Object)false);
    public static final Property<Boolean> ENABLE_INFLUX_REPORTER = Property.named((String)"metrics.influx.enable", (Object)false);
    public static final Property<Integer> METRICS_REPORT_INTERVAL = Property.named((String)"metrics.reporting.interval", (Object)60);
    public static final Property<Boolean> ENABLE_ADMIN_GATEWAY = Property.named((String)"admin.gateway.enable", (Object)true);
    public static final Property<Integer> ADMIN_GATEWAY_PORT = Property.named((String)"admin.gateway.port", (Object)9999);
    private static final String COMPONENT_CODE = "singlenode";
    private final int zkPort;
    private final int segmentStorePort;
    private final int controllerPort;
    private final int restServerPort;
    private String certFile;
    private String keyFile;
    private boolean enableSegmentStoreTlsReload;
    private String passwdFile;
    private String userName;
    private String passwd;
    private final String keyStoreJKS;
    private final String keyStoreJKSPasswordFile;
    private final String trustStoreJKS;
    private boolean enableRestServer;
    private boolean enableTls;
    private String[] tlsProtocolVersion;
    private boolean enableAuth;
    private boolean enableMetrics;
    private boolean enableInfluxDB;
    private int metricsReportInterval;
    private final boolean enableAdminGateway;
    private final int adminGatewayPort;

    private SingleNodeConfig(TypedProperties properties) {
        this.zkPort = properties.getInt(ZK_PORT);
        this.segmentStorePort = properties.getInt(SEGMENTSTORE_PORT);
        this.controllerPort = properties.getInt(CONTROLLER_PORT);
        this.restServerPort = properties.getInt(REST_SERVER_PORT);
        this.certFile = properties.get(CERT_FILE);
        this.keyFile = properties.get(KEY_FILE);
        this.passwdFile = properties.get(PASSWD_FILE);
        this.userName = properties.get(USER_NAME);
        this.passwd = properties.get(PASSWD);
        this.enableRestServer = properties.getBoolean(ENABLE_REST_SERVER);
        this.enableTls = properties.getBoolean(ENABLE_TLS);
        this.tlsProtocolVersion = new TLSProtocolVersion(properties.get(TLS_PROTOCOL_VERSION)).getProtocols();
        this.enableAuth = properties.getBoolean(ENABLE_AUTH);
        this.keyStoreJKS = properties.get(KEYSTORE_JKS);
        this.keyStoreJKSPasswordFile = properties.get(KEYSTORE_JKS_PASSWORD_FILE);
        this.trustStoreJKS = properties.get(TRUSTSTORE_JKS);
        this.enableSegmentStoreTlsReload = properties.getBoolean(ENABLE_TLS_RELOAD);
        this.enableMetrics = properties.getBoolean(ENABLE_METRICS);
        this.enableInfluxDB = properties.getBoolean(ENABLE_INFLUX_REPORTER);
        this.metricsReportInterval = properties.getInt(METRICS_REPORT_INTERVAL);
        this.enableAdminGateway = properties.getBoolean(ENABLE_ADMIN_GATEWAY);
        this.adminGatewayPort = properties.getInt(ADMIN_GATEWAY_PORT);
    }

    public static ConfigBuilder<SingleNodeConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, SingleNodeConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getZkPort() {
        return this.zkPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSegmentStorePort() {
        return this.segmentStorePort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getControllerPort() {
        return this.controllerPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRestServerPort() {
        return this.restServerPort;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCertFile() {
        return this.certFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyFile() {
        return this.keyFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableSegmentStoreTlsReload() {
        return this.enableSegmentStoreTlsReload;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPasswdFile() {
        return this.passwdFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUserName() {
        return this.userName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPasswd() {
        return this.passwd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreJKS() {
        return this.keyStoreJKS;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyStoreJKSPasswordFile() {
        return this.keyStoreJKSPasswordFile;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTrustStoreJKS() {
        return this.trustStoreJKS;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableRestServer() {
        return this.enableRestServer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableTls() {
        return this.enableTls;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getTlsProtocolVersion() {
        return this.tlsProtocolVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableAuth() {
        return this.enableAuth;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableInfluxDB() {
        return this.enableInfluxDB;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMetricsReportInterval() {
        return this.metricsReportInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableAdminGateway() {
        return this.enableAdminGateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getAdminGatewayPort() {
        return this.adminGatewayPort;
    }
}

