/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.DynamicAttributeValue;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
public class DynamicAttributeUpdate
extends AttributeUpdate {
    private boolean valueSet;
    private final DynamicAttributeValue valueReference;

    public DynamicAttributeUpdate(AttributeId attributeId, AttributeUpdateType updateType, DynamicAttributeValue valueReference) {
        this(attributeId, updateType, valueReference, Long.MIN_VALUE);
    }

    public DynamicAttributeUpdate(AttributeId attributeId, AttributeUpdateType updateType, DynamicAttributeValue valueReference, long comparisonValue) {
        super(attributeId, updateType, Long.MIN_VALUE, comparisonValue);
        this.valueReference = (DynamicAttributeValue)Preconditions.checkNotNull((Object)valueReference, (Object)"reference");
    }

    @Override
    public void setValue(long value) {
        super.setValue(value);
        this.valueSet = true;
    }

    @Override
    public long getValue() {
        Preconditions.checkState((boolean)this.valueSet, (Object)"value not set");
        return super.getValue();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String toString() {
        return String.format("[Dynamic]%s, ValRef = (%s)", super.toString(), this.valueReference);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicAttributeUpdate)) {
            return false;
        }
        DynamicAttributeUpdate other = (DynamicAttributeUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.valueSet != other.valueSet) {
            return false;
        }
        DynamicAttributeValue this$valueReference = this.getValueReference();
        DynamicAttributeValue other$valueReference = other.getValueReference();
        return !(this$valueReference == null ? other$valueReference != null : !this$valueReference.equals(other$valueReference));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicAttributeUpdate;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.valueSet ? 79 : 97);
        DynamicAttributeValue $valueReference = this.getValueReference();
        result = result * 59 + ($valueReference == null ? 43 : $valueReference.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DynamicAttributeValue getValueReference() {
        return this.valueReference;
    }
}

