/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.ReadResultEntry;
import io.pravega.segmentstore.contracts.ReadResultEntryType;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface ReadResult
extends Iterator<ReadResultEntry>,
AutoCloseable {
    public long getStreamSegmentStartOffset();

    public int getMaxResultLength();

    public int getConsumedLength();

    public boolean isCopyOnRead();

    public void setCopyOnRead(boolean var1);

    public int getMaxReadAtOnce();

    public void setMaxReadAtOnce(int var1);

    public boolean isClosed();

    @Override
    public void close();

    @VisibleForTesting
    default public int readRemaining(byte[] target, Duration fetchTimeout) {
        ReadResultEntry entry;
        int bytesRead;
        int copied;
        for (bytesRead = 0; this.hasNext() && bytesRead < target.length && (entry = (ReadResultEntry)this.next()).getType() != ReadResultEntryType.EndOfStreamSegment && entry.getType() != ReadResultEntryType.Future; bytesRead += copied) {
            if (!entry.getContent().isDone()) {
                entry.requestContent(fetchTimeout);
            }
            BufferView contents = entry.getContent().join();
            copied = contents.copyTo(ByteBuffer.wrap(target, bytesRead, Math.min(contents.getLength(), target.length - bytesRead)));
        }
        return bytesRead;
    }

    default public List<BufferView> readRemaining(int maxLength, Duration fetchTimeout) {
        ReadResultEntry entry;
        int bytesRead = 0;
        ArrayList<BufferView> result = new ArrayList<BufferView>();
        while (this.hasNext() && bytesRead < maxLength && (entry = (ReadResultEntry)this.next()).getType() != ReadResultEntryType.EndOfStreamSegment && entry.getType() != ReadResultEntryType.Future) {
            if (!entry.getContent().isDone()) {
                entry.requestContent(fetchTimeout);
            }
            result.add(entry.getContent().join());
        }
        return result;
    }
}

