/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.tables.TableAttributes;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;

public class SegmentType {
    public static final SegmentType STREAM_SEGMENT = SegmentType.builder().build();
    public static final SegmentType TABLE_SEGMENT_HASH = SegmentType.builder().tableSegment().build();
    @VisibleForTesting
    static final long FORMAT_BASIC = 0L;
    @VisibleForTesting
    static final long FORMAT_TABLE_SEGMENT = 1L;
    @VisibleForTesting
    static final long FORMAT_FIXED_KEY_LENGTH_TABLE_SEGMENT = 5L;
    @VisibleForTesting
    static final long ROLE_INTERNAL = 16L;
    @VisibleForTesting
    static final long ROLE_SYSTEM = 48L;
    @VisibleForTesting
    static final long ROLE_CRITICAL = 64L;
    private final long flags;

    public int hashCode() {
        return Long.hashCode(this.flags);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SegmentType) {
            return this.flags == ((SegmentType)obj).flags;
        }
        return false;
    }

    public long getValue() {
        return this.flags;
    }

    public boolean isTableSegment() {
        return (this.flags & 1L) == 1L;
    }

    public boolean isFixedKeyLengthTableSegment() {
        return (this.flags & 5L) == 5L;
    }

    public boolean isInternal() {
        return (this.flags & 0x10L) == 16L;
    }

    public boolean isSystem() {
        return (this.flags & 0x30L) == 48L;
    }

    public boolean isCritical() {
        return (this.flags & 0x40L) == 64L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("[%s]: Base", this.flags));
        if (this.isFixedKeyLengthTableSegment()) {
            result.append(", Table Segment (Fixed-Key-Length)");
        } else if (this.isTableSegment()) {
            result.append(", Table Segment");
        }
        if (this.isSystem()) {
            result.append(", System");
        }
        if (this.isCritical()) {
            result.append(", Critical");
        }
        if (this.isInternal()) {
            result.append(", Internal");
        }
        return result.toString();
    }

    public static SegmentType fromAttributes(Map<AttributeId, Long> segmentAttributes) {
        long type = segmentAttributes.getOrDefault(Attributes.ATTRIBUTE_SEGMENT_TYPE, 0L);
        Builder builder = new Builder(type);
        if (segmentAttributes.containsKey(TableAttributes.INDEX_OFFSET)) {
            builder.tableSegment();
        }
        return builder.build();
    }

    public boolean intoAttributes(Map<AttributeId, Long> segmentAttributes) {
        Long previous = segmentAttributes.put(Attributes.ATTRIBUTE_SEGMENT_TYPE, this.flags);
        return previous == null || previous != this.flags;
    }

    public static Builder builder() {
        return new Builder(0L);
    }

    public static Builder builder(SegmentType base) {
        return new Builder(base.flags);
    }

    @ConstructorProperties(value={"flags"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentType(long flags) {
        this.flags = flags;
    }

    public static class Builder {
        private long flags;

        public Builder tableSegment() {
            this.flags |= 1L;
            return this;
        }

        public Builder fixedKeyLengthTableSegment() {
            this.flags |= 5L;
            return this;
        }

        public Builder system() {
            this.flags |= 0x30L;
            return this;
        }

        public Builder critical() {
            this.flags |= 0x40L;
            return this;
        }

        public Builder internal() {
            this.flags |= 0x10L;
            return this;
        }

        public SegmentType build() {
            return new SegmentType(this.flags);
        }

        @ConstructorProperties(value={"flags"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Builder(long flags) {
            this.flags = flags;
        }
    }
}

