/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.SegmentProperties;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;

public class StreamSegmentInformation
implements SegmentProperties {
    private final String name;
    private final long startOffset;
    private final long length;
    private final boolean sealed;
    private final boolean deleted;
    private final boolean sealedInStorage;
    private final boolean deletedInStorage;
    private final long storageLength;
    private final ImmutableDate lastModified;
    private final Map<AttributeId, Long> attributes;

    private StreamSegmentInformation(String name, long startOffset, long length, long storageLength, boolean sealed, boolean deleted, boolean sealedInStorage, boolean deletedInStorage, Map<AttributeId, Long> attributes, ImmutableDate lastModified) {
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (Object)"startOffset must be a non-negative number.");
        Preconditions.checkArgument((length >= startOffset ? 1 : 0) != 0, (Object)"length must be a non-negative number and greater than startOffset.");
        Preconditions.checkArgument((length >= storageLength ? 1 : 0) != 0, (Object)"storageLength must be less than or equal to length.");
        if (deletedInStorage) {
            Preconditions.checkArgument((boolean)deleted, (Object)"deleted must be set if deletedInStorage is set.");
        }
        if (sealedInStorage) {
            Preconditions.checkArgument((boolean)sealed, (Object)"sealed must be set if sealedInStorage is set.");
        }
        this.name = Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        this.startOffset = startOffset;
        this.length = length;
        this.storageLength = storageLength;
        this.sealed = sealed;
        this.sealedInStorage = sealedInStorage;
        this.deleted = deleted;
        this.deletedInStorage = deletedInStorage;
        this.lastModified = lastModified == null ? new ImmutableDate() : lastModified;
        this.attributes = StreamSegmentInformation.createAttributes(attributes);
    }

    public static StreamSegmentInformationBuilder from(SegmentProperties base) {
        return StreamSegmentInformation.builder().name(base.getName()).startOffset(base.getStartOffset()).length(base.getLength()).sealed(base.isSealed()).deleted(base.isDeleted()).lastModified(base.getLastModified()).attributes(base.getAttributes());
    }

    public String toString() {
        return String.format("Name = %s, StartOffset = %d, Length = %d, Storage Length = %d, Sealed = %s, Deleted = %s, Sealed in Storage = %s, Deleted in Storage = %s", this.getName(), this.getStartOffset(), this.getLength(), this.getStorageLength(), this.isSealed(), this.isDeleted(), this.isSealedInStorage(), this.isDeletedInStorage());
    }

    private static Map<AttributeId, Long> createAttributes(Map<AttributeId, Long> input) {
        return input == null || input.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(input);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamSegmentInformationBuilder builder() {
        return new StreamSegmentInformationBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLength() {
        return this.length;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSealedInStorage() {
        return this.sealedInStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDeletedInStorage() {
        return this.deletedInStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStorageLength() {
        return this.storageLength;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableDate getLastModified() {
        return this.lastModified;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<AttributeId, Long> getAttributes() {
        return this.attributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class StreamSegmentInformationBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long length;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long storageLength;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean sealed;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean deleted;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean sealedInStorage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean deletedInStorage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<AttributeId, Long> attributes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableDate lastModified;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamSegmentInformationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder length(long length) {
            this.length = length;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder storageLength(long storageLength) {
            this.storageLength = storageLength;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder sealed(boolean sealed) {
            this.sealed = sealed;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder sealedInStorage(boolean sealedInStorage) {
            this.sealedInStorage = sealedInStorage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder deletedInStorage(boolean deletedInStorage) {
            this.deletedInStorage = deletedInStorage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder attributes(Map<AttributeId, Long> attributes) {
            this.attributes = attributes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformationBuilder lastModified(ImmutableDate lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInformation build() {
            return new StreamSegmentInformation(this.name, this.startOffset, this.length, this.storageLength, this.sealed, this.deleted, this.sealedInStorage, this.deletedInStorage, this.attributes, this.lastModified);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamSegmentInformation.StreamSegmentInformationBuilder(name=" + this.name + ", startOffset=" + this.startOffset + ", length=" + this.length + ", storageLength=" + this.storageLength + ", sealed=" + this.sealed + ", deleted=" + this.deleted + ", sealedInStorage=" + this.sealedInStorage + ", deletedInStorage=" + this.deletedInStorage + ", attributes=" + this.attributes + ", lastModified=" + this.lastModified + ")";
        }
    }
}

