/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import lombok.Generated;

public class StreamSegmentTruncatedException
extends StreamSegmentException {
    private static final long serialVersionUID = 1L;
    final long startOffset;

    public StreamSegmentTruncatedException(String segmentName, String message, Throwable ex) {
        super(segmentName, message, ex);
        this.startOffset = 0L;
    }

    public StreamSegmentTruncatedException(long startOffset) {
        super("", String.format("Segment truncated: Lowest accessible offset is %d.", startOffset));
        this.startOffset = startOffset;
    }

    public StreamSegmentTruncatedException(String segmentName, long startOffset, long requestedOffset) {
        super(segmentName, String.format("Segment truncated: Lowest accessible offset is %d. (%d was requested)", startOffset, requestedOffset));
        this.startOffset = startOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartOffset() {
        return this.startOffset;
    }
}

