/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import com.google.common.base.Preconditions;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.tables.IteratorArgs;
import io.pravega.segmentstore.contracts.tables.IteratorItem;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableSegmentConfig;
import io.pravega.segmentstore.contracts.tables.TableSegmentInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface TableStore {
    public static final int MAXIMUM_KEY_LENGTH = 8192;
    public static final int MAXIMUM_VALUE_LENGTH = 1040384;

    default public CompletableFuture<Void> createSegment(String segmentName, SegmentType segmentType, Duration timeout) {
        Preconditions.checkArgument((!segmentType.isFixedKeyLengthTableSegment() ? 1 : 0) != 0, (Object)"Cannot create Fixed-Key-Length Table Segments using this API.");
        return this.createSegment(segmentName, segmentType, TableSegmentConfig.NO_CONFIG, timeout);
    }

    public CompletableFuture<Void> createSegment(String var1, SegmentType var2, TableSegmentConfig var3, Duration var4);

    public CompletableFuture<Void> deleteSegment(String var1, boolean var2, Duration var3);

    public CompletableFuture<List<Long>> put(String var1, List<TableEntry> var2, Duration var3);

    public CompletableFuture<List<Long>> put(String var1, List<TableEntry> var2, long var3, Duration var5);

    public CompletableFuture<Void> remove(String var1, Collection<TableKey> var2, Duration var3);

    public CompletableFuture<Void> remove(String var1, Collection<TableKey> var2, long var3, Duration var5);

    public CompletableFuture<List<TableEntry>> get(String var1, List<BufferView> var2, Duration var3);

    public CompletableFuture<AsyncIterator<IteratorItem<TableKey>>> keyIterator(String var1, IteratorArgs var2);

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryIterator(String var1, IteratorArgs var2);

    public CompletableFuture<AsyncIterator<IteratorItem<TableEntry>>> entryDeltaIterator(String var1, long var2, Duration var4);

    public CompletableFuture<TableSegmentInfo> getInfo(String var1, Duration var2);
}

