/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.MultiKeySequentialProcessor;
import io.pravega.common.function.RunnableWithException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.SyncStorage;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AsyncStorageWrapper
implements Storage {
    private final SyncStorage syncStorage;
    private final Executor executor;
    private final MultiKeySequentialProcessor<String> taskProcessor;
    private final AtomicBoolean closed;

    public AsyncStorageWrapper(SyncStorage syncStorage, Executor executor) {
        this.syncStorage = (SyncStorage)Preconditions.checkNotNull((Object)syncStorage, (Object)"syncStorage");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.taskProcessor = new MultiKeySequentialProcessor(this.executor);
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.syncStorage.close();
        }
    }

    @Override
    public void initialize(long containerEpoch) {
        this.syncStorage.initialize(containerEpoch);
    }

    @Override
    public CompletableFuture<SegmentHandle> openWrite(String streamSegmentName) {
        return this.supplyAsync(() -> this.syncStorage.openWrite(streamSegmentName), streamSegmentName);
    }

    @Override
    public CompletableFuture<SegmentHandle> create(String streamSegmentName, SegmentRollingPolicy rollingPolicy, Duration timeout) {
        return this.supplyAsync(() -> this.syncStorage.create(streamSegmentName, rollingPolicy), streamSegmentName);
    }

    @Override
    public CompletableFuture<Void> write(SegmentHandle handle, long offset, InputStream data, int length, Duration timeout) {
        return this.runAsync(() -> this.syncStorage.write(handle, offset, data, length), handle.getSegmentName());
    }

    @Override
    public CompletableFuture<Void> seal(SegmentHandle handle, Duration timeout) {
        return this.runAsync(() -> this.syncStorage.seal(handle), handle.getSegmentName());
    }

    @Override
    public CompletableFuture<Void> concat(SegmentHandle targetHandle, long offset, String sourceSegment, Duration timeout) {
        return this.runAsync(() -> this.syncStorage.concat(targetHandle, offset, sourceSegment), targetHandle.getSegmentName(), sourceSegment);
    }

    @Override
    public CompletableFuture<Void> delete(SegmentHandle handle, Duration timeout) {
        return this.runAsync(() -> this.syncStorage.delete(handle), handle.getSegmentName());
    }

    @Override
    public CompletableFuture<Void> truncate(SegmentHandle handle, long offset, Duration timeout) {
        return this.runAsync(() -> this.syncStorage.truncate(handle, offset), handle.getSegmentName());
    }

    @Override
    public boolean supportsTruncation() {
        return this.syncStorage.supportsTruncation();
    }

    @Override
    public boolean supportsAtomicWrites() {
        return false;
    }

    @Override
    public CompletableFuture<SegmentHandle> openRead(String streamSegmentName) {
        return this.supplyAsync(() -> this.syncStorage.openRead(streamSegmentName), streamSegmentName);
    }

    @Override
    public CompletableFuture<Integer> read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length, Duration timeout) {
        return this.supplyAsync(() -> this.syncStorage.read(handle, offset, buffer, bufferOffset, length), handle.getSegmentName());
    }

    @Override
    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        return this.supplyAsync(() -> this.syncStorage.getStreamSegmentInfo(streamSegmentName), streamSegmentName);
    }

    @Override
    public CompletableFuture<Boolean> exists(String streamSegmentName, Duration timeout) {
        return this.supplyAsync(() -> this.syncStorage.exists(streamSegmentName), streamSegmentName);
    }

    @Override
    public Iterator<SegmentProperties> listSegments() throws IOException {
        return this.syncStorage.listSegments();
    }

    @VisibleForTesting
    int getSegmentWithOngoingOperationsCount() {
        return this.taskProcessor.getCurrentTaskCount();
    }

    private <R> CompletableFuture<R> supplyAsync(Callable<R> operation, String ... segmentNames) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.taskProcessor.add(Arrays.asList(segmentNames), () -> this.execute(operation));
    }

    private CompletableFuture<Void> runAsync(RunnableWithException operation, String ... segmentNames) {
        return this.supplyAsync(() -> {
            operation.run();
            return null;
        }, segmentNames);
    }

    private <R> CompletableFuture<R> execute(Callable<R> operation) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return operation.call();
            }
            catch (Exception ex) {
                throw new CompletionException(ex);
            }
        }, this.executor);
    }
}

