/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import io.pravega.common.util.CloseableIterator;
import io.pravega.common.util.CompositeArrayView;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import io.pravega.segmentstore.storage.WriteSettings;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public interface DurableDataLog
extends AutoCloseable {
    public void initialize(Duration var1) throws DurableDataLogException;

    public void enable() throws DurableDataLogException;

    public void disable() throws DurableDataLogException;

    public CompletableFuture<LogAddress> append(CompositeArrayView var1, Duration var2);

    public CompletableFuture<Void> truncate(LogAddress var1, Duration var2);

    public CloseableIterator<ReadItem, DurableDataLogException> getReader() throws DurableDataLogException;

    public WriteSettings getWriteSettings();

    public long getEpoch();

    public QueueStats getQueueStatistics();

    public void registerQueueStateChangeListener(ThrottleSourceListener var1);

    @Override
    public void close();

    public static interface ReadItem {
        public InputStream getPayload();

        public int getLength();

        public LogAddress getAddress();
    }
}

