/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class QueueStats {
    public static final QueueStats DEFAULT = new QueueStats(0, 0L, 0x100000, 0);
    private final int size;
    private final long totalLength;
    private final int maxWriteLength;
    private final int expectedProcessingTimeMillis;

    public double getAverageItemFillRatio() {
        if (this.size > 0) {
            return Math.min(1.0, (double)this.totalLength / (double)this.size / (double)this.maxWriteLength);
        }
        return 0.0;
    }

    public String toString() {
        return String.format("Size = %d, Fill = %.2f, ProcTime = %dms", this.getSize(), this.getAverageItemFillRatio(), this.getExpectedProcessingTimeMillis());
    }

    @ConstructorProperties(value={"size", "totalLength", "maxWriteLength", "expectedProcessingTimeMillis"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public QueueStats(int size, long totalLength, int maxWriteLength, int expectedProcessingTimeMillis) {
        this.size = size;
        this.totalLength = totalLength;
        this.maxWriteLength = maxWriteLength;
        this.expectedProcessingTimeMillis = expectedProcessingTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSize() {
        return this.size;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTotalLength() {
        return this.totalLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxWriteLength() {
        return this.maxWriteLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getExpectedProcessingTimeMillis() {
        return this.expectedProcessingTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueStats)) {
            return false;
        }
        QueueStats other = (QueueStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotalLength() != other.getTotalLength()) {
            return false;
        }
        if (this.getMaxWriteLength() != other.getMaxWriteLength()) {
            return false;
        }
        return this.getExpectedProcessingTimeMillis() == other.getExpectedProcessingTimeMillis();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueueStats;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        long $totalLength = this.getTotalLength();
        result = result * 59 + (int)($totalLength >>> 32 ^ $totalLength);
        result = result * 59 + this.getMaxWriteLength();
        result = result * 59 + this.getExpectedProcessingTimeMillis();
        return result;
    }
}

