/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.storage.ReadOnlyStorage;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

public interface Storage
extends ReadOnlyStorage,
AutoCloseable {
    public CompletableFuture<SegmentHandle> openWrite(String var1);

    default public CompletableFuture<SegmentHandle> create(String streamSegmentName, Duration timeout) {
        return this.create(streamSegmentName, SegmentRollingPolicy.NO_ROLLING, timeout);
    }

    public CompletableFuture<SegmentHandle> create(String var1, SegmentRollingPolicy var2, Duration var3);

    public CompletableFuture<Void> write(SegmentHandle var1, long var2, InputStream var4, int var5, Duration var6);

    public CompletableFuture<Void> seal(SegmentHandle var1, Duration var2);

    public CompletableFuture<Void> concat(SegmentHandle var1, long var2, String var4, Duration var5);

    public CompletableFuture<Void> delete(SegmentHandle var1, Duration var2);

    public CompletableFuture<Void> truncate(SegmentHandle var1, long var2, Duration var4);

    public boolean supportsTruncation();

    public boolean supportsAtomicWrites();

    public Iterator<SegmentProperties> listSegments() throws IOException;

    @Override
    public void close();
}

