/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlerSourceListenerCollection {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThrottlerSourceListenerCollection.class);
    @GuardedBy(value="listeners")
    private final HashSet<ThrottleSourceListener> listeners = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getListenerCount() {
        HashSet<ThrottleSourceListener> hashSet = this.listeners;
        synchronized (hashSet) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(@NonNull ThrottleSourceListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (listener.isClosed()) {
            log.warn("Attempted to register a closed ThrottleSourceListener ({}).", (Object)listener);
            return;
        }
        HashSet<ThrottleSourceListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySourceChanged() {
        ArrayList<ThrottleSourceListener> toNotify = new ArrayList<ThrottleSourceListener>();
        ArrayList<ThrottleSourceListener> toRemove = new ArrayList<ThrottleSourceListener>();
        HashSet<ThrottleSourceListener> hashSet = this.listeners;
        synchronized (hashSet) {
            for (ThrottleSourceListener l : this.listeners) {
                if (l.isClosed()) {
                    toRemove.add(l);
                    continue;
                }
                toNotify.add(l);
            }
            this.listeners.removeAll(toRemove);
        }
        for (ThrottleSourceListener l : toNotify) {
            try {
                l.notifyThrottleSourceChanged();
            }
            catch (Throwable ex) {
                if (Exceptions.mustRethrow((Throwable)ex)) {
                    throw ex;
                }
                log.error("Error while notifying listener {}.", (Object)l, (Object)ex);
            }
        }
    }
}

