/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import lombok.Generated;

public class WriteSettings {
    private final int maxWriteLength;
    private final Duration maxWriteTimeout;
    private final int maxOutstandingBytes;

    public WriteSettings(int maxWriteLength, Duration maxWriteTimeout, int maxOutstandingBytes) {
        Preconditions.checkArgument((maxWriteLength > 0 ? 1 : 0) != 0, (Object)"maxWriteLength must be a positive integer");
        Preconditions.checkArgument((!maxWriteTimeout.isNegative() ? 1 : 0) != 0, (Object)"maxWriteTimeout must be a non-negative duration.");
        Preconditions.checkArgument((maxOutstandingBytes > 0 ? 1 : 0) != 0, (Object)"maxOutstandingBytes must be a positive integer");
        this.maxWriteLength = maxWriteLength;
        this.maxWriteTimeout = maxWriteTimeout;
        this.maxOutstandingBytes = maxOutstandingBytes;
    }

    public String toString() {
        return String.format("MaxWriteLength = %s, MaxOutstandingBytes = %s, MaxWriteTimeoutMillis = %s", this.maxWriteLength, this.maxOutstandingBytes, this.maxWriteTimeout.toMillis());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxWriteLength() {
        return this.maxWriteLength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getMaxWriteTimeout() {
        return this.maxWriteTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxOutstandingBytes() {
        return this.maxOutstandingBytes;
    }
}

