/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

abstract class CacheLayout {
    static final long MAX_TOTAL_SIZE = 0x4000000000L;
    static final int MAX_ENTRY_SIZE = 0x3FFFFFF;
    static final int NO_ADDRESS = 0;
    static final int NO_BLOCK_ID = 0;
    private final int bufferSize;
    private final int blockSize;
    private final int blockMetadataSize;
    private final int maxBufferCount;
    private final int blocksPerBuffer;

    CacheLayout(int bufferSize, int blockSize, int blockMetadataSize) {
        Preconditions.checkArgument((0x4000000000L % (long)bufferSize == 0L ? 1 : 0) != 0, (String)"MAX_TOTAL_SIZE (%s) must be a multiple of bufferSize()(%s).", (long)0x4000000000L, (int)bufferSize);
        this.bufferSize = bufferSize;
        this.maxBufferCount = (int)(0x4000000000L / (long)this.bufferSize);
        Preconditions.checkArgument((bufferSize % blockSize == 0 ? 1 : 0) != 0, (String)"bufferSize() (%s) must be a multiple of blockSize()(%s).", (int)bufferSize, (int)blockSize);
        this.blockSize = blockSize;
        this.blocksPerBuffer = this.bufferSize / this.blockSize;
        Preconditions.checkArgument((this.blocksPerBuffer * blockMetadataSize == this.blockSize ? 1 : 0) != 0, (Object)"All block metadata must fit exactly into a single block.");
        this.blockMetadataSize = blockMetadataSize;
    }

    int maxBufferCount() {
        return this.maxBufferCount;
    }

    int blocksPerBuffer() {
        return this.blocksPerBuffer;
    }

    int bufferSize() {
        return this.bufferSize;
    }

    int blockSize() {
        return this.blockSize;
    }

    int blockMetadataSize() {
        return this.blockMetadataSize;
    }

    abstract int getBufferId(int var1);

    abstract int getBlockId(int var1);

    abstract int calculateAddress(int var1, int var2);

    abstract long setPredecessorAddress(long var1, int var3);

    abstract int getPredecessorAddress(long var1);

    abstract long setLength(long var1, int var3);

    abstract int getLength(long var1);

    abstract long setNextFreeBlockId(long var1, int var3);

    abstract int getNextFreeBlockId(long var1);

    abstract boolean isUsedBlock(long var1);

    abstract long newBlockMetadata(int var1, int var2, int var3);

    abstract long emptyBlockMetadata();

    String getAddressString(int address) {
        return address == 0 ? "" : String.format("Buffer = %d, Block = %d", this.getBufferId(address), this.getBlockId(address));
    }

    static class DefaultLayout
    extends CacheLayout {
        @VisibleForTesting
        static final int ADDRESS_BIT_COUNT = 32;
        @VisibleForTesting
        static final int BLOCK_LENGTH_BIT_COUNT = 14;
        @VisibleForTesting
        static final int BLOCK_ID_BIT_COUNT = 10;
        private static final int BUFFER_SIZE = 0x200000;
        private static final int BLOCK_SIZE = 4096;
        private static final long USED_FLAG = Long.MIN_VALUE;
        private static final long EMPTY_BLOCK_METADATA = 0L;
        private static final int BLOCK_LENGTH_MASK = 16383;
        private static final int NEXT_FREE_BLOCK_ID_SHIFT_BITS = 46;
        private static final long NEXT_FREE_BLOCK_ID_CLEAR_MASK = -71987225293750273L;
        private static final int BLOCK_ID_MASK = 1023;

        DefaultLayout() {
            super(0x200000, 4096, 8);
        }

        @Override
        int getBufferId(int address) {
            return address >> 10;
        }

        @Override
        int getBlockId(int address) {
            return address & 0x3FF;
        }

        @Override
        int calculateAddress(int bufferId, int blockId) {
            assert (bufferId >= 0 && bufferId < this.maxBufferCount());
            assert (blockId >= 0 && blockId < this.blocksPerBuffer());
            return (bufferId << 10) + blockId;
        }

        @Override
        long setPredecessorAddress(long blockMetadata, int predecessorAddress) {
            return blockMetadata & 0xFFFFFFFF00000000L | (long)predecessorAddress;
        }

        @Override
        int getPredecessorAddress(long blockMetadata) {
            return (int)(blockMetadata & 0xFFFFFFFFFFFFFFFFL);
        }

        @Override
        long setLength(long blockMetadata, int length) {
            blockMetadata &= 0xFFFFC000FFFFFFFFL;
            return blockMetadata |= (long)(length & 0x3FFF) << 32;
        }

        @Override
        int getLength(long blockMetadata) {
            return (int)(blockMetadata >> 32 & 0x3FFFL);
        }

        @Override
        long setNextFreeBlockId(long blockMetadata, int nextFreeBlockId) {
            return blockMetadata & 0xFF003FFFFFFFFFFFL | (long)nextFreeBlockId << 46;
        }

        @Override
        int getNextFreeBlockId(long blockMetadata) {
            return (int)(blockMetadata >> 46 & 0x3FFL);
        }

        @Override
        boolean isUsedBlock(long blockMetadata) {
            return (blockMetadata & Long.MIN_VALUE) == Long.MIN_VALUE;
        }

        @Override
        long newBlockMetadata(int nextFreeBlockId, int length, int predecessorAddress) {
            long result = Long.MIN_VALUE;
            result |= ((long)nextFreeBlockId & 0x3FFL) << 46;
            result |= ((long)length & 0x3FFFL) << 32;
            return result |= 0xFFFFFFFFL & (long)predecessorAddress;
        }

        @Override
        long emptyBlockMetadata() {
            return 0L;
        }
    }
}

