/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.cache;

import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.StatsLogger;

final class CacheMetrics
implements AutoCloseable {
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"cache");
    private final Counter writeBytes = STATS_LOGGER.createCounter("pravega.segmentstore.cache.write_bytes", new String[0]);
    private final Counter appendBytes = STATS_LOGGER.createCounter("pravega.segmentstore.cache.append_bytes", new String[0]);
    private final Counter readBytes = STATS_LOGGER.createCounter("pravega.segmentstore.cache.read_bytes", new String[0]);
    private final Counter deleteBytes = STATS_LOGGER.createCounter("pravega.segmentstore.cache.delete_bytes", new String[0]);

    CacheMetrics() {
    }

    void insert(int size) {
        this.writeBytes.add((long)size);
    }

    void append(int size) {
        this.appendBytes.add((long)size);
    }

    void get(int size) {
        this.readBytes.add((long)size);
    }

    void delete(int size) {
        this.deleteBytes.add((long)size);
    }

    @Override
    public void close() {
        this.writeBytes.close();
        this.appendBytes.close();
        this.readBytes.close();
        this.deleteBytes.close();
    }
}

