/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.cache;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.storage.cache.CacheState;
import io.pravega.segmentstore.storage.cache.CacheStorage;
import java.util.function.Supplier;

@VisibleForTesting
public class NoOpCache
implements CacheStorage {
    @Override
    public int getBlockAlignment() {
        return 4096;
    }

    @Override
    public int getMaxEntryLength() {
        return 0x3FFFFFF;
    }

    @Override
    public void close() {
    }

    @Override
    public int insert(BufferView data) {
        return 0;
    }

    @Override
    public int replace(int address, BufferView data) {
        return address;
    }

    @Override
    public int getAppendableLength(int currentLength) {
        return currentLength == 0 ? this.getBlockAlignment() : this.getBlockAlignment() - currentLength % this.getBlockAlignment();
    }

    @Override
    public int append(int address, int expectedLength, BufferView data) {
        return Math.min(data.getLength(), this.getAppendableLength(expectedLength));
    }

    @Override
    public void delete(int address) {
    }

    @Override
    public BufferView get(int address) {
        return null;
    }

    @Override
    public CacheState getState() {
        return new CacheState(0L, 0L, 0L, 0L, 0x4000000000L);
    }

    @Override
    public void setCacheFullCallback(Supplier<Boolean> cacheFullCallback, int millis) {
    }
}

