/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AsyncBaseChunkStorage
implements ChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncBaseChunkStorage.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Executor executor;

    public AsyncBaseChunkStorage(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public abstract boolean supportsTruncation();

    @Override
    public abstract boolean supportsAppend();

    @Override
    public abstract boolean supportsConcat();

    @Override
    public final CompletableFuture<Boolean> exists(String chunkName) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"exists", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Boolean> returnFuture = this.checkExistsAsync(chunkName, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(retValue -> LoggerHelpers.traceLeave((Logger)log, (String)"exists", (long)traceId, (Object[])new Object[]{chunkName}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public final CompletableFuture<ChunkHandle> create(String chunkName) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"create", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<ChunkHandle> returnFuture = this.doCreateAsync(chunkName, opContext);
        returnFuture.thenAcceptAsync(handle -> {
            Duration elapsed = opContext.getInclusiveLatency();
            ChunkStorageMetrics.CREATE_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.CREATE_COUNT.inc();
            log.debug("Create - chunk={}, latency={}.", (Object)chunkName, (Object)elapsed.toMillis());
            LoggerHelpers.traceLeave((Logger)log, (String)"create", (long)traceId, (Object[])new Object[]{chunkName});
        }, this.executor);
        return returnFuture;
    }

    @Override
    public final CompletableFuture<ChunkHandle> createWithContent(String chunkName, int length, InputStream data) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        Preconditions.checkArgument((null != data ? 1 : 0) != 0, (Object)"data must not be null");
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String)"length must be non-zero and non-negative. Chunk=%s length=%s", (Object)chunkName, (int)length);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"CreateWithContent", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<ChunkHandle> returnFuture = this.doCreateWithContentAsync(chunkName, length, data, opContext);
        returnFuture.thenAcceptAsync(handle -> {
            Duration elapsed = opContext.getInclusiveLatency();
            ChunkStorageMetrics.WRITE_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.WRITE_BYTES.add((long)length);
            ChunkStorageMetrics.CREATE_COUNT.inc();
            log.debug("CreateWithContent - chunk={}, bytesWritten={}, latency={}.", new Object[]{handle.getChunkName(), length, elapsed.toMillis()});
            LoggerHelpers.traceLeave((Logger)log, (String)"CreateWithContent", (long)traceId, (Object[])new Object[]{chunkName});
        }, this.executor);
        return returnFuture;
    }

    @Override
    public final CompletableFuture<Void> delete(ChunkHandle handle) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((null != handle ? 1 : 0) != 0, (Object)"handle must not be null");
        this.checkChunkName(handle.getChunkName());
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (String)"handle must not be readonly. Chunk=%s", (Object)handle.getChunkName());
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"delete", (Object[])new Object[]{handle.getChunkName()});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Void> returnFuture = this.doDeleteAsync(handle, opContext);
        returnFuture.thenRunAsync(() -> {
            Duration elapsed = opContext.getInclusiveLatency();
            ChunkStorageMetrics.DELETE_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.DELETE_COUNT.inc();
            log.debug("Delete - chunk={}, latency={}.", (Object)handle.getChunkName(), (Object)elapsed.toMillis());
            LoggerHelpers.traceLeave((Logger)log, (String)"delete", (long)traceId, (Object[])new Object[]{handle.getChunkName()});
        }, this.executor);
        return returnFuture;
    }

    @Override
    public final CompletableFuture<ChunkHandle> openRead(String chunkName) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openRead", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<ChunkHandle> returnFuture = this.doOpenReadAsync(chunkName, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(handle -> LoggerHelpers.traceLeave((Logger)log, (String)"openRead", (long)traceId, (Object[])new Object[]{chunkName}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public final CompletableFuture<ChunkHandle> openWrite(String chunkName) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openWrite", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<ChunkHandle> returnFuture = this.doOpenWriteAsync(chunkName, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(handle -> LoggerHelpers.traceLeave((Logger)log, (String)"openWrite", (long)traceId, (Object[])new Object[]{chunkName}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public final CompletableFuture<ChunkInfo> getInfo(String chunkName) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkChunkName(chunkName);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getInfo", (Object[])new Object[]{chunkName});
        OperationContext opContext = new OperationContext();
        CompletableFuture<ChunkInfo> returnFuture = this.doGetInfoAsync(chunkName, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(info -> LoggerHelpers.traceLeave((Logger)log, (String)"getInfo", (long)traceId, (Object[])new Object[]{chunkName}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public final CompletableFuture<Integer> read(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((null != handle ? 1 : 0) != 0, (Object)"handle must not be null");
        this.checkChunkName(handle.getChunkName());
        Preconditions.checkArgument((null != buffer ? 1 : 0) != 0, (Object)"buffer must not be null");
        Preconditions.checkArgument((fromOffset >= 0L ? 1 : 0) != 0, (String)"fromOffset must be non-negative. Chunk=%s fromOffset=%s", (Object)handle.getChunkName(), (long)fromOffset);
        Preconditions.checkArgument((length >= 0 && length <= buffer.length ? 1 : 0) != 0, (String)"length must be non-negative and must not exceed buffer. Chunk=%s length=%s buffer.length=%s", (Object)handle.getChunkName(), (Object)length, (Object)buffer.length);
        Preconditions.checkElementIndex((int)bufferOffset, (int)buffer.length, (String)"bufferOffset");
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"read", (Object[])new Object[]{handle.getChunkName(), fromOffset, bufferOffset, length});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Integer> returnFuture = this.doReadAsync(handle, fromOffset, length, buffer, bufferOffset, opContext);
        returnFuture.thenAcceptAsync(bytesRead -> {
            Duration elapsed = opContext.getInclusiveLatency();
            ChunkStorageMetrics.READ_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.READ_BYTES.add((long)bytesRead.intValue());
            log.debug("Read - chunk={}, offset={}, bytesRead={}, latency={}.", new Object[]{handle.getChunkName(), fromOffset, length, elapsed.toMillis()});
            LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{bytesRead});
        }, this.executor);
        return returnFuture;
    }

    @Override
    public final CompletableFuture<Integer> write(ChunkHandle handle, long offset, int length, InputStream data) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((null != handle ? 1 : 0) != 0, (Object)"handle must not be null");
        this.checkChunkName(handle.getChunkName());
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (String)"handle must not be readonly. Chunk = %s", (Object)handle.getChunkName());
        Preconditions.checkArgument((null != data ? 1 : 0) != 0, (Object)"data must not be null");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset must be non-negative. Chunk=%s offset=%s", (Object)handle.getChunkName(), (long)offset);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length must be non-negative. Chunk=%s length=%s", (Object)handle.getChunkName(), (int)length);
        if (!this.supportsAppend()) {
            Preconditions.checkArgument((offset == 0L ? 1 : 0) != 0, (Object)"offset must be 0 because storage does not support appends.");
        }
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"write", (Object[])new Object[]{handle.getChunkName(), offset, length});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Integer> returnFuture = this.doWriteAsync(handle, offset, length, data, opContext);
        returnFuture.thenAcceptAsync(bytesWritten -> {
            Duration elapsed = opContext.getInclusiveLatency();
            ChunkStorageMetrics.WRITE_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.WRITE_BYTES.add((long)bytesWritten.intValue());
            log.debug("Write - chunk={}, offset={}, bytesWritten={}, latency={}.", new Object[]{handle.getChunkName(), offset, length, elapsed.toMillis()});
            LoggerHelpers.traceLeave((Logger)log, (String)"write", (long)traceId, (Object[])new Object[]{bytesWritten});
        }, this.executor);
        return returnFuture;
    }

    @Override
    public final CompletableFuture<Integer> concat(ConcatArgument[] chunks) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.checkConcatArgs(chunks);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"concat", (Object[])new Object[]{chunks[0].getName()});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Integer> returnFuture = this.doConcatAsync(chunks, opContext);
        returnFuture.thenAcceptAsync(retValue -> {
            Duration elapsed = opContext.getInclusiveLatency();
            log.debug("concat - target={}, latency={}.", (Object)chunks[0].getName(), (Object)elapsed.toMillis());
            ChunkStorageMetrics.CONCAT_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.CONCAT_BYTES.add((long)retValue.intValue());
            ChunkStorageMetrics.CONCAT_COUNT.inc();
            ChunkStorageMetrics.LARGE_CONCAT_COUNT.inc();
            LoggerHelpers.traceLeave((Logger)log, (String)"concat", (long)traceId, (Object[])new Object[]{chunks[0].getName()});
        }, this.executor);
        return returnFuture;
    }

    private void checkConcatArgs(ConcatArgument[] chunks) {
        Preconditions.checkArgument((null != chunks ? 1 : 0) != 0, (Object)"chunks must not be null");
        Preconditions.checkArgument((chunks.length >= 2 ? 1 : 0) != 0, (Object)"There must be at least two chunks");
        Preconditions.checkArgument((null != chunks[0] ? 1 : 0) != 0, (Object)"target chunk must not be null");
        Preconditions.checkArgument((chunks[0].getLength() >= 0L ? 1 : 0) != 0, (Object)"target chunk length must be non negative.");
        this.checkChunkName(chunks[0].getName());
        for (int i = 1; i < chunks.length; ++i) {
            Preconditions.checkArgument((null != chunks[i] ? 1 : 0) != 0, (Object)"source chunk must not be null");
            this.checkChunkName(chunks[i].getName());
            Preconditions.checkArgument((chunks[i].getLength() >= 0L ? 1 : 0) != 0, (Object)"source chunk length must be non negative.");
            Preconditions.checkArgument((!chunks[i].getName().equals(chunks[0].getName()) ? 1 : 0) != 0, (Object)"source chunk is same as target");
            Preconditions.checkArgument((!chunks[i].getName().equals(chunks[i - 1].getName()) ? 1 : 0) != 0, (Object)"duplicate chunk found");
        }
    }

    @Override
    public final CompletableFuture<Boolean> truncate(ChunkHandle handle, long offset) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((null != handle ? 1 : 0) != 0, (Object)"handle must not be null");
        this.checkChunkName(handle.getChunkName());
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (String)"handle must not be readonly. Chunk=%s", (Object)handle.getChunkName());
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset must be non-negative. Chunk=%s offset=%s", (Object)handle.getChunkName(), (long)offset);
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"truncate", (Object[])new Object[]{handle.getChunkName()});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Boolean> returnFuture = this.doTruncateAsync(handle, offset, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(retValue -> LoggerHelpers.traceLeave((Logger)log, (String)"truncate", (long)traceId, (Object[])new Object[]{handle.getChunkName()}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public final CompletableFuture<Void> setReadOnly(ChunkHandle handle, boolean isReadonly) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkArgument((null != handle ? 1 : 0) != 0, (Object)"handle must not be null");
        this.checkChunkName(handle.getChunkName());
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"setReadOnly", (Object[])new Object[]{handle.getChunkName()});
        OperationContext opContext = new OperationContext();
        CompletableFuture<Void> returnFuture = this.doSetReadOnlyAsync(handle, isReadonly, opContext);
        if (log.isTraceEnabled()) {
            returnFuture.thenAcceptAsync(v -> LoggerHelpers.traceLeave((Logger)log, (String)"setReadOnly", (long)traceId, (Object[])new Object[]{handle.getChunkName()}), this.executor);
        }
        return returnFuture;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public void report() {
    }

    protected abstract CompletableFuture<ChunkInfo> doGetInfoAsync(String var1, OperationContext var2);

    protected abstract CompletableFuture<ChunkHandle> doCreateAsync(String var1, OperationContext var2);

    protected abstract CompletableFuture<ChunkHandle> doCreateWithContentAsync(String var1, int var2, InputStream var3, OperationContext var4);

    protected abstract CompletableFuture<Boolean> checkExistsAsync(String var1, OperationContext var2);

    protected abstract CompletableFuture<Void> doDeleteAsync(ChunkHandle var1, OperationContext var2);

    protected abstract CompletableFuture<ChunkHandle> doOpenReadAsync(String var1, OperationContext var2);

    protected abstract CompletableFuture<ChunkHandle> doOpenWriteAsync(String var1, OperationContext var2);

    protected abstract CompletableFuture<Integer> doReadAsync(ChunkHandle var1, long var2, int var4, byte[] var5, int var6, OperationContext var7);

    protected abstract CompletableFuture<Integer> doWriteAsync(ChunkHandle var1, long var2, int var4, InputStream var5, OperationContext var6);

    protected abstract CompletableFuture<Integer> doConcatAsync(ConcatArgument[] var1, OperationContext var2);

    protected abstract CompletableFuture<Void> doSetReadOnlyAsync(ChunkHandle var1, boolean var2, OperationContext var3);

    protected CompletableFuture<Boolean> doTruncateAsync(ChunkHandle handle, long offset, OperationContext opContext) {
        throw new UnsupportedOperationException();
    }

    protected void checkChunkName(String chunkName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)chunkName) ? 1 : 0) != 0, (Object)"chunk name must not be null or empty");
    }

    protected <R> CompletableFuture<R> execute(Callable<R> operation, OperationContext opContext) {
        return CompletableFuture.supplyAsync(() -> {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            try {
                Timer timer = new Timer();
                Object ret = operation.call();
                opContext.setInclusiveLatency(timer.getElapsed());
                return ret;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    protected static class OperationContext {
        private volatile Duration inclusiveLatency = Duration.ZERO;

        protected OperationContext() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Duration getInclusiveLatency() {
            return this.inclusiveLatency;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setInclusiveLatency(Duration inclusiveLatency) {
            this.inclusiveLatency = inclusiveLatency;
        }
    }
}

