/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.AsyncBaseChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class BaseChunkStorage
extends AsyncBaseChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseChunkStorage.class);

    public BaseChunkStorage(Executor executor) {
        super(executor);
    }

    @Override
    protected CompletableFuture<ChunkInfo> doGetInfoAsync(String chunkName, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doGetInfo(chunkName), opContext);
    }

    @Override
    protected CompletableFuture<ChunkHandle> doCreateAsync(String chunkName, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doCreate(chunkName), opContext);
    }

    @Override
    protected CompletableFuture<ChunkHandle> doCreateWithContentAsync(String chunkName, int length, InputStream data, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doCreateWithContent(chunkName, length, data), opContext);
    }

    @Override
    protected CompletableFuture<Boolean> checkExistsAsync(String chunkName, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.checkExists(chunkName), opContext);
    }

    @Override
    protected CompletableFuture<Void> doDeleteAsync(ChunkHandle handle, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> {
            this.doDelete(handle);
            return null;
        }, opContext);
    }

    @Override
    protected CompletableFuture<ChunkHandle> doOpenReadAsync(String chunkName, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doOpenRead(chunkName), opContext);
    }

    @Override
    protected CompletableFuture<ChunkHandle> doOpenWriteAsync(String chunkName, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doOpenWrite(chunkName), opContext);
    }

    @Override
    protected CompletableFuture<Integer> doReadAsync(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doRead(handle, fromOffset, length, buffer, bufferOffset), opContext);
    }

    @Override
    protected CompletableFuture<Integer> doWriteAsync(ChunkHandle handle, long offset, int length, InputStream data, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doWrite(handle, offset, length, data), opContext);
    }

    @Override
    protected CompletableFuture<Integer> doConcatAsync(ConcatArgument[] chunks, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doConcat(chunks), opContext);
    }

    @Override
    protected CompletableFuture<Void> doSetReadOnlyAsync(ChunkHandle handle, boolean isReadOnly, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> {
            this.doSetReadOnly(handle, isReadOnly);
            return null;
        }, opContext);
    }

    @Override
    protected CompletableFuture<Boolean> doTruncateAsync(ChunkHandle handle, long offset, AsyncBaseChunkStorage.OperationContext opContext) {
        return this.execute(() -> this.doTruncate(handle, offset), opContext);
    }

    protected abstract ChunkInfo doGetInfo(String var1) throws ChunkStorageException;

    protected abstract ChunkHandle doCreate(String var1) throws ChunkStorageException;

    protected ChunkHandle doCreateWithContent(String chunkName, int length, InputStream data) throws ChunkStorageException {
        ChunkHandle handle = this.doCreate(chunkName);
        int bytesWritten = this.doWrite(handle, 0L, length, data);
        if (bytesWritten < length) {
            this.doDelete(ChunkHandle.writeHandle(chunkName));
            throw new ChunkStorageException(chunkName, "doCreateWithContent - invalid length returned");
        }
        return handle;
    }

    protected abstract boolean checkExists(String var1) throws ChunkStorageException;

    protected abstract void doDelete(ChunkHandle var1) throws ChunkStorageException;

    protected abstract ChunkHandle doOpenRead(String var1) throws ChunkStorageException;

    protected abstract ChunkHandle doOpenWrite(String var1) throws ChunkStorageException;

    protected abstract int doRead(ChunkHandle var1, long var2, int var4, byte[] var5, int var6) throws ChunkStorageException;

    protected abstract int doWrite(ChunkHandle var1, long var2, int var4, InputStream var5) throws ChunkStorageException;

    protected abstract int doConcat(ConcatArgument[] var1) throws ChunkStorageException, UnsupportedOperationException;

    protected abstract void doSetReadOnly(ChunkHandle var1, boolean var2) throws ChunkStorageException, UnsupportedOperationException;

    protected boolean doTruncate(ChunkHandle handle, long offset) throws ChunkStorageException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

