/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

class ChunkIterator {
    private final Executor executor;
    private final MetadataTransaction txn;
    private volatile String currentChunkName;
    private volatile String lastChunkName;
    private volatile ChunkMetadata currentMetadata;

    ChunkIterator(Executor executor, MetadataTransaction txn, SegmentMetadata segmentMetadata) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.txn = (MetadataTransaction)Preconditions.checkNotNull((Object)txn, (Object)"txn");
        Preconditions.checkNotNull((Object)segmentMetadata, (Object)"segmentMetadata");
        this.currentChunkName = segmentMetadata.getFirstChunk();
    }

    ChunkIterator(Executor executor, MetadataTransaction txn, String startChunkName, String lastChunkName) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.txn = (MetadataTransaction)Preconditions.checkNotNull((Object)txn, (Object)"txn");
        this.currentChunkName = startChunkName;
        this.lastChunkName = lastChunkName;
    }

    public CompletableFuture<Void> forEach(BiConsumer<ChunkMetadata, String> consumer) {
        return Futures.loop(() -> null != this.currentChunkName && !this.currentChunkName.equals(this.lastChunkName), () -> this.txn.get(this.currentChunkName).thenAcceptAsync(storageMetadata -> {
            this.currentMetadata = (ChunkMetadata)storageMetadata;
            consumer.accept(this.currentMetadata, this.currentChunkName);
            this.currentChunkName = this.currentMetadata.getNextChunk();
        }, this.executor), (Executor)this.executor);
    }
}

