/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.MultiKeySequentialProcessor;
import io.pravega.common.util.ImmutableDate;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageNotPrimaryException;
import io.pravega.segmentstore.storage.chunklayer.AbstractTaskQueueManager;
import io.pravega.segmentstore.storage.chunklayer.ChunkNameOffsetPair;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.chunklayer.ConcatOperation;
import io.pravega.segmentstore.storage.chunklayer.DefragmentOperation;
import io.pravega.segmentstore.storage.chunklayer.GarbageCollector;
import io.pravega.segmentstore.storage.chunklayer.ReadIndexCache;
import io.pravega.segmentstore.storage.chunklayer.ReadOperation;
import io.pravega.segmentstore.storage.chunklayer.SegmentStorageHandle;
import io.pravega.segmentstore.storage.chunklayer.SnapshotInfoStore;
import io.pravega.segmentstore.storage.chunklayer.StatsReporter;
import io.pravega.segmentstore.storage.chunklayer.SystemJournal;
import io.pravega.segmentstore.storage.chunklayer.TruncateOperation;
import io.pravega.segmentstore.storage.chunklayer.WriteOperation;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.ReadIndexBlockMetadata;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import io.pravega.segmentstore.storage.metadata.StorageMetadataWritesFencedOutException;
import io.pravega.shared.NameUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ChunkedSegmentStorage
implements Storage,
StatsReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChunkedSegmentStorage.class);
    private final ChunkedSegmentStorageConfig config;
    private final ChunkMetadataStore metadataStore;
    private final ChunkStorage chunkStorage;
    private final Executor executor;
    private final AtomicBoolean closed;
    private volatile long epoch;
    private final int containerId;
    private final SystemJournal systemJournal;
    private final ReadIndexCache readIndexCache;
    private String logPrefix;
    private final MultiKeySequentialProcessor<String> taskProcessor;
    @GuardedBy(value="activeSegments")
    private final HashSet<String> activeRequests = new HashSet();
    private final GarbageCollector garbageCollector;
    private final ScheduledFuture<?> reporter;
    private AbstractTaskQueueManager<GarbageCollector.TaskInfo> taskQueue;

    public ChunkedSegmentStorage(int containerId, ChunkStorage chunkStorage, ChunkMetadataStore metadataStore, ScheduledExecutorService executor, ChunkedSegmentStorageConfig config) {
        this.containerId = containerId;
        this.config = (ChunkedSegmentStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.chunkStorage = (ChunkStorage)Preconditions.checkNotNull((Object)chunkStorage, (Object)"chunkStorage");
        this.metadataStore = (ChunkMetadataStore)Preconditions.checkNotNull((Object)metadataStore, (Object)"metadataStore");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.readIndexCache = new ReadIndexCache(config.getMaxIndexedSegments(), config.getMaxIndexedChunks());
        this.taskProcessor = new MultiKeySequentialProcessor(this.executor);
        this.garbageCollector = new GarbageCollector(containerId, chunkStorage, metadataStore, config, executor, System::currentTimeMillis, duration -> Futures.delayedFuture((Duration)duration, (ScheduledExecutorService)executor));
        this.systemJournal = new SystemJournal(containerId, chunkStorage, metadataStore, this.garbageCollector, config, executor);
        this.closed = new AtomicBoolean(false);
        this.reporter = executor.scheduleAtFixedRate(this::report, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Void> bootstrap(SnapshotInfoStore snapshotInfoStore, AbstractTaskQueueManager<GarbageCollector.TaskInfo> taskQueue) {
        this.logPrefix = String.format("ChunkedSegmentStorage[%d]", this.containerId);
        this.taskQueue = taskQueue;
        return this.systemJournal.bootstrap(this.epoch, snapshotInfoStore);
    }

    public CompletableFuture<Void> finishBootstrap() {
        return this.garbageCollector.initialize(this.taskQueue);
    }

    @Override
    public void initialize(long containerEpoch) {
        this.epoch = containerEpoch;
    }

    @Override
    public CompletableFuture<SegmentHandle> openWrite(String streamSegmentName) {
        this.checkInitialized();
        return this.executeSerialized(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openWrite", (Object[])new Object[]{streamSegmentName});
            Timer timer = new Timer();
            Preconditions.checkNotNull((Object)streamSegmentName, (Object)"streamSegmentName");
            log.debug("{} openWrite - started segment={}.", (Object)this.logPrefix, (Object)streamSegmentName);
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(false, streamSegmentName), txn -> txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                CompletableFuture<Object> f;
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkSegmentExists(streamSegmentName, segmentMetadata);
                segmentMetadata.checkInvariants();
                if (segmentMetadata.getOwnerEpoch() < this.epoch) {
                    log.debug("{} openWrite - Segment needs ownership change - segment={}.", (Object)this.logPrefix, (Object)segmentMetadata.getName());
                    f = this.claimOwnership((MetadataTransaction)txn, segmentMetadata);
                } else {
                    f = CompletableFuture.completedFuture(null);
                }
                return f.thenApplyAsync(v -> {
                    this.checkOwnership(streamSegmentName, segmentMetadata);
                    SegmentStorageHandle retValue = SegmentStorageHandle.writeHandle(streamSegmentName);
                    log.debug("{} openWrite - finished segment={} latency={}.", new Object[]{this.logPrefix, streamSegmentName, timer.getElapsedMillis()});
                    LoggerHelpers.traceLeave((Logger)log, (String)"openWrite", (long)traceId, (Object[])new Object[]{retValue});
                    return retValue;
                }, this.executor);
            }, this.executor), this.executor).handleAsync((v, ex) -> {
                if (null != ex) {
                    log.debug("{} openWrite - exception segment={} latency={}.", new Object[]{this.logPrefix, streamSegmentName, timer.getElapsedMillis(), ex});
                    this.handleException(streamSegmentName, (Throwable)ex);
                }
                return v;
            }, this.executor);
        }, streamSegmentName);
    }

    private CompletableFuture<Void> claimOwnership(MetadataTransaction txn, SegmentMetadata segmentMetadata) {
        String lastChunkName = segmentMetadata.getLastChunk();
        CompletionStage<Boolean> f = this.shouldAppend() && null != lastChunkName ? txn.get(lastChunkName).thenComposeAsync(storageMetadata -> {
            ChunkMetadata lastChunk = (ChunkMetadata)storageMetadata;
            Preconditions.checkState((null != lastChunk ? 1 : 0) != 0, (Object)"last chunk metadata must not be null.");
            Preconditions.checkState((null != lastChunk.getName() ? 1 : 0) != 0, (Object)"Name of last chunk must not be null.");
            log.debug("{} claimOwnership - current last chunk - segment={}, last chunk={}, Length={}.", new Object[]{this.logPrefix, segmentMetadata.getName(), lastChunk.getName(), lastChunk.getLength()});
            return ((CompletableFuture)this.chunkStorage.getInfo(lastChunkName).thenApplyAsync(chunkInfo -> {
                Preconditions.checkState((chunkInfo != null ? 1 : 0) != 0, (Object)"chunkInfo for last chunk must not be null.");
                Preconditions.checkState((lastChunk != null ? 1 : 0) != 0, (Object)"last chunk metadata must not be null.");
                if (chunkInfo.getLength() != lastChunk.getLength()) {
                    Preconditions.checkState((chunkInfo.getLength() > lastChunk.getLength() ? 1 : 0) != 0, (String)"Length of last chunk on LTS must be greater than what is in metadata. Chunk=%s length=%s", (Object)lastChunk, (long)chunkInfo.getLength());
                    long oldLength = segmentMetadata.getLength();
                    lastChunk.setLength(chunkInfo.getLength());
                    segmentMetadata.setLength(segmentMetadata.getLastChunkStartOffset() + lastChunk.getLength());
                    if (!segmentMetadata.isStorageSystemSegment()) {
                        this.addBlockIndexEntriesForChunk(txn, segmentMetadata.getName(), lastChunk.getName(), segmentMetadata.getLastChunkStartOffset(), oldLength, segmentMetadata.getLength());
                    }
                    txn.update(lastChunk);
                    log.debug("{} claimOwnership - Length of last chunk adjusted - segment={}, last chunk={}, Length={}.", new Object[]{this.logPrefix, segmentMetadata.getName(), lastChunk.getName(), chunkInfo.getLength()});
                }
                return true;
            }, this.executor)).exceptionally(e -> {
                Throwable ex = Exceptions.unwrap((Throwable)e);
                if (ex instanceof ChunkNotFoundException) {
                    log.debug("{} claimOwnership - Last chunk was missing, failing fast - segment={}, last chunk={}.", new Object[]{this.logPrefix, segmentMetadata.getName(), lastChunk.getName()});
                    txn.update(segmentMetadata);
                    return false;
                }
                throw new CompletionException(ex);
            });
        }, this.executor) : CompletableFuture.completedFuture(true);
        return f.thenComposeAsync(shouldChange -> {
            if (shouldChange.booleanValue()) {
                segmentMetadata.setOwnerEpoch(this.epoch);
                segmentMetadata.setOwnershipChanged(true);
            }
            txn.update(segmentMetadata);
            return txn.commit();
        }, this.executor);
    }

    @Override
    public CompletableFuture<SegmentHandle> create(String streamSegmentName, SegmentRollingPolicy rollingPolicy, Duration timeout) {
        this.checkInitialized();
        return this.executeSerialized(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"create", (Object[])new Object[]{streamSegmentName, rollingPolicy});
            Timer timer = new Timer();
            log.debug("{} create - started segment={}, rollingPolicy={}, latency={}.", new Object[]{this.logPrefix, streamSegmentName, rollingPolicy});
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(false, streamSegmentName), txn -> txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                SegmentMetadata oldSegmentMetadata = (SegmentMetadata)storageMetadata;
                if (null != oldSegmentMetadata) {
                    throw new CompletionException((Throwable)new StreamSegmentExistsException(streamSegmentName));
                }
                SegmentMetadata newSegmentMetadata = SegmentMetadata.builder().name(streamSegmentName).maxRollinglength(rollingPolicy.getMaxLength() == 0L ? SegmentRollingPolicy.NO_ROLLING.getMaxLength() : rollingPolicy.getMaxLength()).ownerEpoch(this.epoch).build();
                newSegmentMetadata.setActive(true);
                txn.create(newSegmentMetadata);
                return txn.commit().thenApplyAsync(v -> {
                    SegmentStorageHandle retValue = SegmentStorageHandle.writeHandle(streamSegmentName);
                    Duration elapsed = timer.getElapsed();
                    ChunkStorageMetrics.SLTS_CREATE_LATENCY.reportSuccessEvent(elapsed);
                    ChunkStorageMetrics.SLTS_CREATE_COUNT.inc();
                    log.debug("{} create - finished segment={}, rollingPolicy={}, latency={}.", new Object[]{this.logPrefix, streamSegmentName, rollingPolicy, elapsed.toMillis()});
                    LoggerHelpers.traceLeave((Logger)log, (String)"create", (long)traceId, (Object[])new Object[]{retValue});
                    return retValue;
                }, this.executor);
            }, this.executor), this.executor).handleAsync((v, e) -> {
                if (null != e) {
                    log.debug("{} create - exception segment={}, rollingPolicy={}, latency={}.", new Object[]{this.logPrefix, streamSegmentName, rollingPolicy, timer.getElapsedMillis(), e});
                    this.handleException(streamSegmentName, (Throwable)e);
                }
                return v;
            }, this.executor);
        }, streamSegmentName);
    }

    private void handleException(String streamSegmentName, Throwable e) {
        Throwable ex = Exceptions.unwrap((Throwable)e);
        if (ex instanceof StorageMetadataWritesFencedOutException) {
            throw new CompletionException((Throwable)((Object)new StorageNotPrimaryException(streamSegmentName, ex)));
        }
        throw new CompletionException(ex);
    }

    @Override
    public CompletableFuture<Void> write(SegmentHandle handle, long offset, InputStream data, int length, Duration timeout) {
        this.checkInitialized();
        if (null == handle) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("handle must not be null"));
        }
        return this.executeSerialized(new WriteOperation(this, handle, offset, data, length), handle.getSegmentName());
    }

    boolean isStorageSystemSegment(SegmentMetadata segmentMetadata) {
        return null != this.systemJournal && segmentMetadata.isStorageSystemSegment();
    }

    @Override
    public CompletableFuture<Void> seal(SegmentHandle handle, Duration timeout) {
        this.checkInitialized();
        return this.executeSerialized(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"seal", (Object[])new Object[]{handle});
            Timer timer = new Timer();
            log.debug("{} seal - started segment={} latency={}.", (Object)this.logPrefix, (Object)handle.getSegmentName());
            Preconditions.checkNotNull((Object)handle, (Object)"handle");
            String streamSegmentName = handle.getSegmentName();
            Preconditions.checkNotNull((Object)streamSegmentName, (Object)"streamSegmentName");
            Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (String)"handle must not be read only. Segment=%s", (Object)handle.getSegmentName());
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(false, handle.getSegmentName()), txn -> ((CompletableFuture)txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkSegmentExists(streamSegmentName, segmentMetadata);
                this.checkOwnership(streamSegmentName, segmentMetadata);
                if (!segmentMetadata.isSealed()) {
                    segmentMetadata.setSealed(true);
                    txn.update(segmentMetadata);
                    return txn.commit();
                }
                return CompletableFuture.completedFuture(null);
            }, this.executor)).thenRunAsync(() -> {
                log.debug("{} seal - finished segment={} latency={}.", new Object[]{this.logPrefix, handle.getSegmentName(), timer.getElapsedMillis()});
                LoggerHelpers.traceLeave((Logger)log, (String)"seal", (long)traceId, (Object[])new Object[]{handle});
            }, this.executor), this.executor).exceptionally(ex -> {
                log.warn("{} seal - exception segment={} latency={}.", new Object[]{this.logPrefix, handle.getSegmentName(), timer.getElapsedMillis(), ex});
                this.handleException(streamSegmentName, (Throwable)ex);
                return null;
            });
        }, handle.getSegmentName());
    }

    @Override
    public CompletableFuture<Void> concat(SegmentHandle targetHandle, long offset, String sourceSegment, Duration timeout) {
        this.checkInitialized();
        if (null == targetHandle) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("handle must not be null"));
        }
        if (null == sourceSegment) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("sourceSegment must not be null"));
        }
        return this.executeSerialized(new ConcatOperation(this, targetHandle, offset, sourceSegment), targetHandle.getSegmentName(), sourceSegment);
    }

    boolean shouldAppend() {
        return this.chunkStorage.supportsAppend() && this.config.isAppendEnabled();
    }

    public CompletableFuture<Void> defrag(MetadataTransaction txn, SegmentMetadata segmentMetadata, String startChunkName, String lastChunkName, List<String> chunksToDelete, List<ChunkNameOffsetPair> newReadIndexEntries, long defragOffset) {
        return new DefragmentOperation(this, txn, segmentMetadata, startChunkName, lastChunkName, chunksToDelete, newReadIndexEntries, defragOffset).call();
    }

    @Override
    public CompletableFuture<Void> delete(SegmentHandle handle, Duration timeout) {
        this.checkInitialized();
        if (null == handle) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("handle must not be null"));
        }
        return this.executeSerialized(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"delete", (Object[])new Object[]{handle});
            log.debug("{} delete - started segment={}, latency={}.", (Object)this.logPrefix, (Object)handle.getSegmentName());
            Timer timer = new Timer();
            String streamSegmentName = handle.getSegmentName();
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(false, streamSegmentName), txn -> txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkSegmentExists(streamSegmentName, segmentMetadata);
                this.checkOwnership(streamSegmentName, segmentMetadata);
                segmentMetadata.setActive(false);
                txn.update(segmentMetadata);
                return this.garbageCollector.addSegmentToGarbage(txn.getVersion(), streamSegmentName).thenComposeAsync(vv -> txn.commit().thenRunAsync(() -> {
                    this.readIndexCache.remove(streamSegmentName);
                    Duration elapsed = timer.getElapsed();
                    ChunkStorageMetrics.SLTS_DELETE_LATENCY.reportSuccessEvent(elapsed);
                    ChunkStorageMetrics.SLTS_DELETE_COUNT.inc();
                    log.debug("{} delete - finished segment={}, latency={}.", new Object[]{this.logPrefix, handle.getSegmentName(), elapsed.toMillis()});
                    LoggerHelpers.traceLeave((Logger)log, (String)"delete", (long)traceId, (Object[])new Object[]{handle});
                }, this.executor), this.executor);
            }, this.executor), this.executor).exceptionally(ex -> {
                log.warn("{} delete - exception segment={}, latency={}.", new Object[]{this.logPrefix, handle.getSegmentName(), timer.getElapsedMillis(), ex});
                this.handleException(streamSegmentName, (Throwable)ex);
                return null;
            });
        }, handle.getSegmentName());
    }

    @Override
    public CompletableFuture<Void> truncate(SegmentHandle handle, long offset, Duration timeout) {
        this.checkInitialized();
        if (null == handle) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("handle must not be null"));
        }
        return this.executeSerialized(new TruncateOperation(this, handle, offset), handle.getSegmentName());
    }

    @Override
    public boolean supportsTruncation() {
        return true;
    }

    @Override
    public boolean supportsAtomicWrites() {
        return true;
    }

    @Override
    public Iterator<SegmentProperties> listSegments() {
        throw new UnsupportedOperationException("listSegments is not yet supported");
    }

    @Override
    public CompletableFuture<SegmentHandle> openRead(String streamSegmentName) {
        this.checkInitialized();
        return this.executeParallel(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"openRead", (Object[])new Object[]{streamSegmentName});
            Timer timer = new Timer();
            Preconditions.checkNotNull((Object)streamSegmentName, (Object)"streamSegmentName");
            log.debug("{} openRead - started segment={}.", (Object)this.logPrefix, (Object)streamSegmentName);
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(false, streamSegmentName), txn -> txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                CompletableFuture<Object> f;
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkSegmentExists(streamSegmentName, segmentMetadata);
                segmentMetadata.checkInvariants();
                if (segmentMetadata.getOwnerEpoch() < this.epoch) {
                    log.debug("{} openRead - Segment needs ownership change. segment={}.", (Object)this.logPrefix, (Object)segmentMetadata.getName());
                    f = this.executeSerialized(() -> this.claimOwnership((MetadataTransaction)txn, segmentMetadata), streamSegmentName);
                } else {
                    f = CompletableFuture.completedFuture(null);
                }
                return f.thenApplyAsync(v -> {
                    SegmentStorageHandle retValue = SegmentStorageHandle.readHandle(streamSegmentName);
                    log.debug("{} openRead - finished segment={} latency={}.", new Object[]{this.logPrefix, streamSegmentName, timer.getElapsedMillis()});
                    LoggerHelpers.traceLeave((Logger)log, (String)"openRead", (long)traceId, (Object[])new Object[]{retValue});
                    return retValue;
                }, this.executor);
            }, this.executor), this.executor).handleAsync((v, ex) -> {
                if (null != ex) {
                    log.debug("{} openRead - exception segment={} latency={}.", new Object[]{this.logPrefix, streamSegmentName, timer.getElapsedMillis(), ex});
                    this.handleException(streamSegmentName, (Throwable)ex);
                }
                return v;
            }, this.executor);
        }, streamSegmentName);
    }

    @Override
    public CompletableFuture<Integer> read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length, Duration timeout) {
        this.checkInitialized();
        return this.executeParallel(new ReadOperation(this, handle, offset, buffer, bufferOffset, length), handle.getSegmentName());
    }

    @Override
    public CompletableFuture<SegmentProperties> getStreamSegmentInfo(String streamSegmentName, Duration timeout) {
        this.checkInitialized();
        return this.executeParallel(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"getStreamSegmentInfo", (Object[])new Object[]{streamSegmentName});
            Timer timer = new Timer();
            Preconditions.checkNotNull((Object)streamSegmentName, (Object)"streamSegmentName");
            log.debug("{} getStreamSegmentInfo - started segment={}.", (Object)this.logPrefix, (Object)streamSegmentName);
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(true, streamSegmentName), txn -> txn.get(streamSegmentName).thenApplyAsync(storageMetadata -> {
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkSegmentExists(streamSegmentName, segmentMetadata);
                segmentMetadata.checkInvariants();
                StreamSegmentInformation retValue = StreamSegmentInformation.builder().name(streamSegmentName).sealed(segmentMetadata.isSealed()).length(segmentMetadata.getLength()).startOffset(segmentMetadata.getStartOffset()).lastModified(new ImmutableDate(segmentMetadata.getLastModified())).build();
                log.debug("{} getStreamSegmentInfo - finished segment={} latency={}.", new Object[]{this.logPrefix, streamSegmentName, timer.getElapsedMillis()});
                LoggerHelpers.traceLeave((Logger)log, (String)"getStreamSegmentInfo", (long)traceId, (Object[])new Object[]{retValue});
                return retValue;
            }, this.executor), this.executor).handleAsync((v, ex) -> {
                if (null != ex) {
                    log.debug("{} getStreamSegmentInfo - exception segment={}.", new Object[]{this.logPrefix, streamSegmentName, ex});
                    this.handleException(streamSegmentName, (Throwable)ex);
                }
                return v;
            }, this.executor);
        }, streamSegmentName);
    }

    @Override
    public CompletableFuture<Boolean> exists(String streamSegmentName, Duration timeout) {
        this.checkInitialized();
        return this.executeParallel(() -> {
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"exists", (Object[])new Object[]{streamSegmentName});
            Preconditions.checkNotNull((Object)streamSegmentName, (Object)"streamSegmentName");
            return ChunkedSegmentStorage.tryWith(this.metadataStore.beginTransaction(true, streamSegmentName), txn -> txn.get(streamSegmentName).thenApplyAsync(storageMetadata -> {
                SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
                boolean retValue = segmentMetadata != null && segmentMetadata.isActive();
                LoggerHelpers.traceLeave((Logger)log, (String)"exists", (long)traceId, (Object[])new Object[]{retValue});
                return retValue;
            }, this.executor), this.executor);
        }, streamSegmentName);
    }

    @Override
    public void report() {
        this.garbageCollector.report();
        this.metadataStore.report();
        this.chunkStorage.report();
        this.readIndexCache.report();
    }

    @Override
    public void close() {
        this.close("metadataStore", this.metadataStore);
        this.close("garbageCollector", this.garbageCollector);
        this.close("taskQueue", this.taskQueue);
        this.reporter.cancel(true);
        this.closed.set(true);
    }

    private void close(String message, AutoCloseable toClose) {
        try {
            log.debug("{} Closing {}", (Object)this.logPrefix, (Object)message);
            if (null != toClose) {
                toClose.close();
            }
            log.info("{} Closed {}", (Object)this.logPrefix, (Object)message);
        }
        catch (Exception e) {
            log.error("{} Error while closing {}", new Object[]{this.logPrefix, message, e});
        }
    }

    void addBlockIndexEntriesForChunk(MetadataTransaction txn, String segmentName, String chunkName, long chunkStartOffset, long fromOffset, long toOffset) {
        Preconditions.checkState((chunkStartOffset <= fromOffset ? 1 : 0) != 0, (String)"chunkStartOffset must be less than or equal to fromOffset. Segment=%s Chunk=%s chunkStartOffset=%s fromOffset=%s", (Object)segmentName, (Object)chunkName, (Object)chunkStartOffset, (Object)fromOffset);
        Preconditions.checkState((fromOffset <= toOffset ? 1 : 0) != 0, (String)"fromOffset must be less than or equal to toOffset. Segment=%s Chunk=%s toOffset=%s fromOffset=%s", (Object)segmentName, (Object)chunkName, (Object)toOffset, (Object)fromOffset);
        long blockSize = this.config.getIndexBlockSize();
        long startBlock = fromOffset / blockSize;
        for (long blockStartOffset = startBlock * blockSize; blockStartOffset < toOffset; blockStartOffset += blockSize) {
            if (blockStartOffset < chunkStartOffset) continue;
            ReadIndexBlockMetadata blockEntry = ReadIndexBlockMetadata.builder().name(NameUtils.getSegmentReadIndexBlockName((String)segmentName, (long)blockStartOffset)).startOffset(chunkStartOffset).chunkName(chunkName).status(1).build();
            txn.create(blockEntry);
            log.debug("{} adding new block index entry segment={}, entry={}.", new Object[]{this.logPrefix, segmentName, blockEntry});
        }
    }

    void deleteBlockIndexEntriesForChunk(MetadataTransaction txn, String segmentName, long startOffset, long endOffset) {
        this.garbageCollector.deleteBlockIndexEntriesForChunk(txn, segmentName, startOffset, endOffset);
    }

    void reportMetricsForSystemSegment(SegmentMetadata segmentMetadata) {
        String name = segmentMetadata.getName().substring(segmentMetadata.getName().lastIndexOf(47) + 1).replace('$', '_');
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.size." + name, (Number)(segmentMetadata.getLength() - segmentMetadata.getStartOffset()), new String[0]);
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.num_chunks." + name, (Number)segmentMetadata.getChunkCount(), new String[0]);
    }

    private <R> CompletableFuture<R> executeSerialized(Callable<CompletableFuture<R>> operation, String ... segmentNames) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (segmentNames.length == 1 && this.systemJournal.isStorageSystemSegment(segmentNames[0])) {
            String[] segments = this.systemJournal.getSystemSegments();
            return this.taskProcessor.add(Arrays.asList(segments), () -> this.executeExclusive(operation, segments));
        }
        return this.taskProcessor.add(Arrays.asList(segmentNames), () -> this.executeExclusive(operation, segmentNames));
    }

    private <R> CompletableFuture<R> executeExclusive(Callable<CompletableFuture<R>> operation, String ... segmentNames) {
        AtomicBoolean shouldRelease = new AtomicBoolean(false);
        this.acquire(segmentNames);
        shouldRelease.set(true);
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(v -> {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            try {
                return (CompletionStage)operation.call();
            }
            catch (CompletionException e) {
                throw new CompletionException(Exceptions.unwrap((Throwable)e));
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor)).whenCompleteAsync((v, e) -> {
            if (shouldRelease.get()) {
                this.release(segmentNames);
            }
        }, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(String ... segmentNames) {
        HashSet<String> hashSet = this.activeRequests;
        synchronized (hashSet) {
            for (String segmentName : segmentNames) {
                if (!this.activeRequests.contains(segmentName)) continue;
                log.error("{} Concurrent modifications for Segment={}", (Object)this.logPrefix, (Object)segmentName);
                throw new ConcurrentModificationException(String.format("Concurrent modifications not allowed. Segment=%s", segmentName));
            }
            for (String segmentName : segmentNames) {
                this.activeRequests.add(segmentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(String ... segmentNames) {
        HashSet<String> hashSet = this.activeRequests;
        synchronized (hashSet) {
            for (String segmentName : segmentNames) {
                this.activeRequests.remove(segmentName);
            }
        }
    }

    private <R> CompletableFuture<R> executeParallel(Callable<CompletableFuture<R>> operation, String ... segmentNames) {
        return CompletableFuture.completedFuture(null).thenComposeAsync(v -> {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            try {
                return (CompletionStage)operation.call();
            }
            catch (CompletionException e) {
                throw new CompletionException(Exceptions.unwrap((Throwable)e));
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    static <T extends AutoCloseable, R> CompletableFuture<R> tryWith(T closeable, Function<T, CompletableFuture<R>> function, Executor executor) {
        return function.apply(closeable).whenCompleteAsync((v, ex) -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executor);
    }

    final void checkSegmentExists(String streamSegmentName, SegmentMetadata segmentMetadata) {
        if (null == segmentMetadata || !segmentMetadata.isActive()) {
            throw new CompletionException((Throwable)new StreamSegmentNotExistsException(streamSegmentName));
        }
    }

    final void checkOwnership(String streamSegmentName, SegmentMetadata segmentMetadata) {
        if (segmentMetadata.getOwnerEpoch() > this.epoch) {
            throw new CompletionException((Throwable)((Object)new StorageNotPrimaryException(streamSegmentName)));
        }
    }

    final void checkNotSealed(String streamSegmentName, SegmentMetadata segmentMetadata) {
        if (segmentMetadata.isSealed()) {
            throw new CompletionException((Throwable)new StreamSegmentSealedException(streamSegmentName));
        }
    }

    private void checkInitialized() {
        Preconditions.checkState((0L != this.epoch ? 1 : 0) != 0, (Object)"epoch must not be zero");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"ChunkedSegmentStorage instance must not be closed");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkMetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkStorage getChunkStorage() {
        return this.chunkStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getContainerId() {
        return this.containerId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SystemJournal getSystemJournal() {
        return this.systemJournal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReadIndexCache getReadIndexCache() {
        return this.readIndexCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLogPrefix() {
        return this.logPrefix;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }
}

