/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import java.beans.ConstructorProperties;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;

public class ChunkedSegmentStorageConfig {
    public static final Property<Long> MIN_SIZE_LIMIT_FOR_CONCAT = Property.named((String)"concat.size.bytes.min", (Object)0L);
    public static final Property<Long> MAX_SIZE_LIMIT_FOR_CONCAT = Property.named((String)"concat.size.bytes.max", (Object)Long.MAX_VALUE);
    public static final Property<Integer> MAX_BUFFER_SIZE_FOR_APPENDS = Property.named((String)"appends.buffer.size.bytes.max", (Object)0x100000);
    public static final Property<Integer> MAX_INDEXED_SEGMENTS = Property.named((String)"readindex.segments.max", (Object)1024);
    public static final Property<Integer> MAX_INDEXED_CHUNKS_PER_SEGMENTS = Property.named((String)"readindex.chunksPerSegment.max", (Object)1024);
    public static final Property<Integer> MAX_INDEXED_CHUNKS = Property.named((String)"readindex.chunks.max", (Object)16384);
    public static final Property<Long> READ_INDEX_BLOCK_SIZE = Property.named((String)"readindex.block.size", (Object)0x100000L);
    public static final Property<Boolean> APPENDS_ENABLED = Property.named((String)"appends.enable", (Object)true);
    public static final Property<Boolean> LAZY_COMMIT_ENABLED = Property.named((String)"commit.lazy.enable", (Object)true);
    public static final Property<Boolean> INLINE_DEFRAG_ENABLED = Property.named((String)"defrag.inline.enable", (Object)true);
    public static final Property<Long> DEFAULT_ROLLOVER_SIZE = Property.named((String)"metadata.rollover.size.bytes.max", (Object)0x8000000L);
    public static final Property<Integer> SELF_CHECK_LATE_WARNING_THRESHOLD = Property.named((String)"self.check.late", (Object)100);
    public static final Property<Integer> GARBAGE_COLLECTION_DELAY = Property.named((String)"garbage.collection.delay.seconds", (Object)60);
    public static final Property<Integer> GARBAGE_COLLECTION_MAX_CONCURRENCY = Property.named((String)"garbage.collection.concurrency.max", (Object)10);
    public static final Property<Integer> GARBAGE_COLLECTION_MAX_QUEUE_SIZE = Property.named((String)"garbage.collection.queue.size.max", (Object)16384);
    public static final Property<Integer> GARBAGE_COLLECTION_SLEEP = Property.named((String)"garbage.collection.sleep.millis", (Object)10);
    public static final Property<Integer> GARBAGE_COLLECTION_MAX_ATTEMPTS = Property.named((String)"garbage.collection.attempts.max", (Object)3);
    public static final Property<Integer> GARBAGE_COLLECTION_MAX_TXN_BATCH_SIZE = Property.named((String)"garbage.collection.txn.batch.size.max", (Object)5000);
    public static final Property<Integer> MAX_METADATA_ENTRIES_IN_BUFFER = Property.named((String)"metadata.buffer.size.max", (Object)1024);
    public static final Property<Integer> MAX_METADATA_ENTRIES_IN_CACHE = Property.named((String)"metadata.cache.size.max", (Object)5000);
    public static final Property<Integer> JOURNAL_SNAPSHOT_UPDATE_FREQUENCY = Property.named((String)"journal.snapshot.update.frequency.minutes", (Object)5);
    public static final Property<Integer> MAX_PER_SNAPSHOT_UPDATE_COUNT = Property.named((String)"journal.snapshot.update.count.max", (Object)100);
    public static final Property<Integer> MAX_JOURNAL_READ_ATTEMPTS = Property.named((String)"journal.snapshot.attempts.read.max", (Object)100);
    public static final Property<Integer> MAX_JOURNAL_WRITE_ATTEMPTS = Property.named((String)"journal.snapshot.attempts.write.max", (Object)10);
    public static final Property<Boolean> SELF_CHECK_ENABLED = Property.named((String)"self.check.enable", (Object)false);
    public static final ChunkedSegmentStorageConfig DEFAULT_CONFIG = ChunkedSegmentStorageConfig.instanceBuilder().minSizeLimitForConcat(0L).maxSizeLimitForConcat(Long.MAX_VALUE).storageMetadataRollingPolicy(new SegmentRollingPolicy(0x8000000L)).maxBufferSizeForChunkDataTransfer(0x100000).maxIndexedSegments(1024).maxIndexedChunksPerSegment(1024).maxIndexedChunks(16384).appendEnabled(true).lazyCommitEnabled(true).inlineDefragEnabled(true).lateWarningThresholdInMillis(100).garbageCollectionDelay(Duration.ofSeconds(60L)).garbageCollectionMaxConcurrency(10).garbageCollectionMaxQueueSize(16384).garbageCollectionSleep(Duration.ofMillis(10L)).garbageCollectionMaxAttempts(3).garbageCollectionTransactionBatchSize(5000).indexBlockSize(0x100000L).maxEntriesInCache(5000).maxEntriesInTxnBuffer(1024).journalSnapshotInfoUpdateFrequency(Duration.ofMinutes(5L)).maxJournalUpdatesPerSnapshot(100).maxJournalReadAttempts(100).maxJournalWriteAttempts(10).selfCheckEnabled(false).build();
    static final String COMPONENT_CODE = "storage";
    private final long minSizeLimitForConcat;
    private final long maxSizeLimitForConcat;
    @NonNull
    private final SegmentRollingPolicy storageMetadataRollingPolicy;
    private final int maxBufferSizeForChunkDataTransfer;
    private final int maxIndexedSegments;
    private final int maxIndexedChunksPerSegment;
    private final int maxIndexedChunks;
    private final long indexBlockSize;
    private final boolean appendEnabled;
    private final boolean lazyCommitEnabled;
    private final boolean inlineDefragEnabled;
    private final int lateWarningThresholdInMillis;
    private final Duration garbageCollectionDelay;
    private final int garbageCollectionMaxConcurrency;
    private final int garbageCollectionMaxQueueSize;
    private final Duration garbageCollectionSleep;
    private final int garbageCollectionMaxAttempts;
    private final int garbageCollectionTransactionBatchSize;
    private final int maxEntriesInTxnBuffer;
    private final int maxEntriesInCache;
    private final Duration journalSnapshotInfoUpdateFrequency;
    private final int maxJournalUpdatesPerSnapshot;
    private final int maxJournalReadAttempts;
    private final int maxJournalWriteAttempts;
    private final boolean selfCheckEnabled;

    ChunkedSegmentStorageConfig(TypedProperties properties) throws ConfigurationException {
        this.appendEnabled = properties.getBoolean(APPENDS_ENABLED);
        this.lazyCommitEnabled = properties.getBoolean(LAZY_COMMIT_ENABLED);
        this.inlineDefragEnabled = properties.getBoolean(INLINE_DEFRAG_ENABLED);
        this.maxBufferSizeForChunkDataTransfer = properties.getInt(MAX_BUFFER_SIZE_FOR_APPENDS);
        this.minSizeLimitForConcat = this.appendEnabled ? properties.getLong(MIN_SIZE_LIMIT_FOR_CONCAT) : 0L;
        this.maxSizeLimitForConcat = properties.getLong(MAX_SIZE_LIMIT_FOR_CONCAT);
        this.maxIndexedSegments = properties.getInt(MAX_INDEXED_SEGMENTS);
        this.maxIndexedChunksPerSegment = properties.getInt(MAX_INDEXED_CHUNKS_PER_SEGMENTS);
        this.maxIndexedChunks = properties.getInt(MAX_INDEXED_CHUNKS);
        this.storageMetadataRollingPolicy = new SegmentRollingPolicy(properties.getLong(DEFAULT_ROLLOVER_SIZE));
        this.lateWarningThresholdInMillis = properties.getInt(SELF_CHECK_LATE_WARNING_THRESHOLD);
        this.garbageCollectionDelay = Duration.ofSeconds(properties.getInt(GARBAGE_COLLECTION_DELAY));
        this.garbageCollectionMaxConcurrency = properties.getInt(GARBAGE_COLLECTION_MAX_CONCURRENCY);
        this.garbageCollectionMaxQueueSize = properties.getInt(GARBAGE_COLLECTION_MAX_QUEUE_SIZE);
        this.garbageCollectionSleep = Duration.ofMillis(properties.getInt(GARBAGE_COLLECTION_SLEEP));
        this.garbageCollectionMaxAttempts = properties.getInt(GARBAGE_COLLECTION_MAX_ATTEMPTS);
        this.garbageCollectionTransactionBatchSize = properties.getPositiveInt(GARBAGE_COLLECTION_MAX_TXN_BATCH_SIZE);
        this.journalSnapshotInfoUpdateFrequency = Duration.ofMinutes(properties.getInt(JOURNAL_SNAPSHOT_UPDATE_FREQUENCY));
        this.maxJournalUpdatesPerSnapshot = properties.getInt(MAX_PER_SNAPSHOT_UPDATE_COUNT);
        this.maxJournalReadAttempts = properties.getInt(MAX_JOURNAL_READ_ATTEMPTS);
        this.maxJournalWriteAttempts = properties.getInt(MAX_JOURNAL_WRITE_ATTEMPTS);
        this.selfCheckEnabled = properties.getBoolean(SELF_CHECK_ENABLED);
        this.indexBlockSize = properties.getLong(READ_INDEX_BLOCK_SIZE);
        this.maxEntriesInTxnBuffer = properties.getInt(MAX_METADATA_ENTRIES_IN_BUFFER);
        this.maxEntriesInCache = properties.getInt(MAX_METADATA_ENTRIES_IN_CACHE);
    }

    public static ConfigBuilder<ChunkedSegmentStorageConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ChunkedSegmentStorageConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ChunkedSegmentStorageConfigBuilder instanceBuilder() {
        return new ChunkedSegmentStorageConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfigBuilder toBuilder() {
        return new ChunkedSegmentStorageConfigBuilder().minSizeLimitForConcat(this.minSizeLimitForConcat).maxSizeLimitForConcat(this.maxSizeLimitForConcat).storageMetadataRollingPolicy(this.storageMetadataRollingPolicy).maxBufferSizeForChunkDataTransfer(this.maxBufferSizeForChunkDataTransfer).maxIndexedSegments(this.maxIndexedSegments).maxIndexedChunksPerSegment(this.maxIndexedChunksPerSegment).maxIndexedChunks(this.maxIndexedChunks).indexBlockSize(this.indexBlockSize).appendEnabled(this.appendEnabled).lazyCommitEnabled(this.lazyCommitEnabled).inlineDefragEnabled(this.inlineDefragEnabled).lateWarningThresholdInMillis(this.lateWarningThresholdInMillis).garbageCollectionDelay(this.garbageCollectionDelay).garbageCollectionMaxConcurrency(this.garbageCollectionMaxConcurrency).garbageCollectionMaxQueueSize(this.garbageCollectionMaxQueueSize).garbageCollectionSleep(this.garbageCollectionSleep).garbageCollectionMaxAttempts(this.garbageCollectionMaxAttempts).garbageCollectionTransactionBatchSize(this.garbageCollectionTransactionBatchSize).maxEntriesInTxnBuffer(this.maxEntriesInTxnBuffer).maxEntriesInCache(this.maxEntriesInCache).journalSnapshotInfoUpdateFrequency(this.journalSnapshotInfoUpdateFrequency).maxJournalUpdatesPerSnapshot(this.maxJournalUpdatesPerSnapshot).maxJournalReadAttempts(this.maxJournalReadAttempts).maxJournalWriteAttempts(this.maxJournalWriteAttempts).selfCheckEnabled(this.selfCheckEnabled);
    }

    @ConstructorProperties(value={"minSizeLimitForConcat", "maxSizeLimitForConcat", "storageMetadataRollingPolicy", "maxBufferSizeForChunkDataTransfer", "maxIndexedSegments", "maxIndexedChunksPerSegment", "maxIndexedChunks", "indexBlockSize", "appendEnabled", "lazyCommitEnabled", "inlineDefragEnabled", "lateWarningThresholdInMillis", "garbageCollectionDelay", "garbageCollectionMaxConcurrency", "garbageCollectionMaxQueueSize", "garbageCollectionSleep", "garbageCollectionMaxAttempts", "garbageCollectionTransactionBatchSize", "maxEntriesInTxnBuffer", "maxEntriesInCache", "journalSnapshotInfoUpdateFrequency", "maxJournalUpdatesPerSnapshot", "maxJournalReadAttempts", "maxJournalWriteAttempts", "selfCheckEnabled"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig(long minSizeLimitForConcat, long maxSizeLimitForConcat, @NonNull SegmentRollingPolicy storageMetadataRollingPolicy, int maxBufferSizeForChunkDataTransfer, int maxIndexedSegments, int maxIndexedChunksPerSegment, int maxIndexedChunks, long indexBlockSize, boolean appendEnabled, boolean lazyCommitEnabled, boolean inlineDefragEnabled, int lateWarningThresholdInMillis, Duration garbageCollectionDelay, int garbageCollectionMaxConcurrency, int garbageCollectionMaxQueueSize, Duration garbageCollectionSleep, int garbageCollectionMaxAttempts, int garbageCollectionTransactionBatchSize, int maxEntriesInTxnBuffer, int maxEntriesInCache, Duration journalSnapshotInfoUpdateFrequency, int maxJournalUpdatesPerSnapshot, int maxJournalReadAttempts, int maxJournalWriteAttempts, boolean selfCheckEnabled) {
        if (storageMetadataRollingPolicy == null) {
            throw new NullPointerException("storageMetadataRollingPolicy is marked non-null but is null");
        }
        this.minSizeLimitForConcat = minSizeLimitForConcat;
        this.maxSizeLimitForConcat = maxSizeLimitForConcat;
        this.storageMetadataRollingPolicy = storageMetadataRollingPolicy;
        this.maxBufferSizeForChunkDataTransfer = maxBufferSizeForChunkDataTransfer;
        this.maxIndexedSegments = maxIndexedSegments;
        this.maxIndexedChunksPerSegment = maxIndexedChunksPerSegment;
        this.maxIndexedChunks = maxIndexedChunks;
        this.indexBlockSize = indexBlockSize;
        this.appendEnabled = appendEnabled;
        this.lazyCommitEnabled = lazyCommitEnabled;
        this.inlineDefragEnabled = inlineDefragEnabled;
        this.lateWarningThresholdInMillis = lateWarningThresholdInMillis;
        this.garbageCollectionDelay = garbageCollectionDelay;
        this.garbageCollectionMaxConcurrency = garbageCollectionMaxConcurrency;
        this.garbageCollectionMaxQueueSize = garbageCollectionMaxQueueSize;
        this.garbageCollectionSleep = garbageCollectionSleep;
        this.garbageCollectionMaxAttempts = garbageCollectionMaxAttempts;
        this.garbageCollectionTransactionBatchSize = garbageCollectionTransactionBatchSize;
        this.maxEntriesInTxnBuffer = maxEntriesInTxnBuffer;
        this.maxEntriesInCache = maxEntriesInCache;
        this.journalSnapshotInfoUpdateFrequency = journalSnapshotInfoUpdateFrequency;
        this.maxJournalUpdatesPerSnapshot = maxJournalUpdatesPerSnapshot;
        this.maxJournalReadAttempts = maxJournalReadAttempts;
        this.maxJournalWriteAttempts = maxJournalWriteAttempts;
        this.selfCheckEnabled = selfCheckEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMinSizeLimitForConcat() {
        return this.minSizeLimitForConcat;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxSizeLimitForConcat() {
        return this.maxSizeLimitForConcat;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentRollingPolicy getStorageMetadataRollingPolicy() {
        return this.storageMetadataRollingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBufferSizeForChunkDataTransfer() {
        return this.maxBufferSizeForChunkDataTransfer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxIndexedSegments() {
        return this.maxIndexedSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxIndexedChunksPerSegment() {
        return this.maxIndexedChunksPerSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxIndexedChunks() {
        return this.maxIndexedChunks;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getIndexBlockSize() {
        return this.indexBlockSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAppendEnabled() {
        return this.appendEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isLazyCommitEnabled() {
        return this.lazyCommitEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isInlineDefragEnabled() {
        return this.inlineDefragEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLateWarningThresholdInMillis() {
        return this.lateWarningThresholdInMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getGarbageCollectionDelay() {
        return this.garbageCollectionDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getGarbageCollectionMaxConcurrency() {
        return this.garbageCollectionMaxConcurrency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getGarbageCollectionMaxQueueSize() {
        return this.garbageCollectionMaxQueueSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getGarbageCollectionSleep() {
        return this.garbageCollectionSleep;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getGarbageCollectionMaxAttempts() {
        return this.garbageCollectionMaxAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getGarbageCollectionTransactionBatchSize() {
        return this.garbageCollectionTransactionBatchSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxEntriesInTxnBuffer() {
        return this.maxEntriesInTxnBuffer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxEntriesInCache() {
        return this.maxEntriesInCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getJournalSnapshotInfoUpdateFrequency() {
        return this.journalSnapshotInfoUpdateFrequency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxJournalUpdatesPerSnapshot() {
        return this.maxJournalUpdatesPerSnapshot;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxJournalReadAttempts() {
        return this.maxJournalReadAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxJournalWriteAttempts() {
        return this.maxJournalWriteAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isSelfCheckEnabled() {
        return this.selfCheckEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ChunkedSegmentStorageConfigBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long minSizeLimitForConcat;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long maxSizeLimitForConcat;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SegmentRollingPolicy storageMetadataRollingPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxBufferSizeForChunkDataTransfer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxIndexedSegments;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxIndexedChunksPerSegment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxIndexedChunks;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long indexBlockSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean appendEnabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean lazyCommitEnabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean inlineDefragEnabled;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int lateWarningThresholdInMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration garbageCollectionDelay;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int garbageCollectionMaxConcurrency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int garbageCollectionMaxQueueSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration garbageCollectionSleep;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int garbageCollectionMaxAttempts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int garbageCollectionTransactionBatchSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxEntriesInTxnBuffer;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxEntriesInCache;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Duration journalSnapshotInfoUpdateFrequency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxJournalUpdatesPerSnapshot;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxJournalReadAttempts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxJournalWriteAttempts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean selfCheckEnabled;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ChunkedSegmentStorageConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder minSizeLimitForConcat(long minSizeLimitForConcat) {
            this.minSizeLimitForConcat = minSizeLimitForConcat;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxSizeLimitForConcat(long maxSizeLimitForConcat) {
            this.maxSizeLimitForConcat = maxSizeLimitForConcat;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder storageMetadataRollingPolicy(@NonNull SegmentRollingPolicy storageMetadataRollingPolicy) {
            if (storageMetadataRollingPolicy == null) {
                throw new NullPointerException("storageMetadataRollingPolicy is marked non-null but is null");
            }
            this.storageMetadataRollingPolicy = storageMetadataRollingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxBufferSizeForChunkDataTransfer(int maxBufferSizeForChunkDataTransfer) {
            this.maxBufferSizeForChunkDataTransfer = maxBufferSizeForChunkDataTransfer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxIndexedSegments(int maxIndexedSegments) {
            this.maxIndexedSegments = maxIndexedSegments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxIndexedChunksPerSegment(int maxIndexedChunksPerSegment) {
            this.maxIndexedChunksPerSegment = maxIndexedChunksPerSegment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxIndexedChunks(int maxIndexedChunks) {
            this.maxIndexedChunks = maxIndexedChunks;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder indexBlockSize(long indexBlockSize) {
            this.indexBlockSize = indexBlockSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder appendEnabled(boolean appendEnabled) {
            this.appendEnabled = appendEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder lazyCommitEnabled(boolean lazyCommitEnabled) {
            this.lazyCommitEnabled = lazyCommitEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder inlineDefragEnabled(boolean inlineDefragEnabled) {
            this.inlineDefragEnabled = inlineDefragEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder lateWarningThresholdInMillis(int lateWarningThresholdInMillis) {
            this.lateWarningThresholdInMillis = lateWarningThresholdInMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionDelay(Duration garbageCollectionDelay) {
            this.garbageCollectionDelay = garbageCollectionDelay;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionMaxConcurrency(int garbageCollectionMaxConcurrency) {
            this.garbageCollectionMaxConcurrency = garbageCollectionMaxConcurrency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionMaxQueueSize(int garbageCollectionMaxQueueSize) {
            this.garbageCollectionMaxQueueSize = garbageCollectionMaxQueueSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionSleep(Duration garbageCollectionSleep) {
            this.garbageCollectionSleep = garbageCollectionSleep;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionMaxAttempts(int garbageCollectionMaxAttempts) {
            this.garbageCollectionMaxAttempts = garbageCollectionMaxAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder garbageCollectionTransactionBatchSize(int garbageCollectionTransactionBatchSize) {
            this.garbageCollectionTransactionBatchSize = garbageCollectionTransactionBatchSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxEntriesInTxnBuffer(int maxEntriesInTxnBuffer) {
            this.maxEntriesInTxnBuffer = maxEntriesInTxnBuffer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxEntriesInCache(int maxEntriesInCache) {
            this.maxEntriesInCache = maxEntriesInCache;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder journalSnapshotInfoUpdateFrequency(Duration journalSnapshotInfoUpdateFrequency) {
            this.journalSnapshotInfoUpdateFrequency = journalSnapshotInfoUpdateFrequency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxJournalUpdatesPerSnapshot(int maxJournalUpdatesPerSnapshot) {
            this.maxJournalUpdatesPerSnapshot = maxJournalUpdatesPerSnapshot;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxJournalReadAttempts(int maxJournalReadAttempts) {
            this.maxJournalReadAttempts = maxJournalReadAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder maxJournalWriteAttempts(int maxJournalWriteAttempts) {
            this.maxJournalWriteAttempts = maxJournalWriteAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfigBuilder selfCheckEnabled(boolean selfCheckEnabled) {
            this.selfCheckEnabled = selfCheckEnabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkedSegmentStorageConfig build() {
            return new ChunkedSegmentStorageConfig(this.minSizeLimitForConcat, this.maxSizeLimitForConcat, this.storageMetadataRollingPolicy, this.maxBufferSizeForChunkDataTransfer, this.maxIndexedSegments, this.maxIndexedChunksPerSegment, this.maxIndexedChunks, this.indexBlockSize, this.appendEnabled, this.lazyCommitEnabled, this.inlineDefragEnabled, this.lateWarningThresholdInMillis, this.garbageCollectionDelay, this.garbageCollectionMaxConcurrency, this.garbageCollectionMaxQueueSize, this.garbageCollectionSleep, this.garbageCollectionMaxAttempts, this.garbageCollectionTransactionBatchSize, this.maxEntriesInTxnBuffer, this.maxEntriesInCache, this.journalSnapshotInfoUpdateFrequency, this.maxJournalUpdatesPerSnapshot, this.maxJournalReadAttempts, this.maxJournalWriteAttempts, this.selfCheckEnabled);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ChunkedSegmentStorageConfig.ChunkedSegmentStorageConfigBuilder(minSizeLimitForConcat=" + this.minSizeLimitForConcat + ", maxSizeLimitForConcat=" + this.maxSizeLimitForConcat + ", storageMetadataRollingPolicy=" + this.storageMetadataRollingPolicy + ", maxBufferSizeForChunkDataTransfer=" + this.maxBufferSizeForChunkDataTransfer + ", maxIndexedSegments=" + this.maxIndexedSegments + ", maxIndexedChunksPerSegment=" + this.maxIndexedChunksPerSegment + ", maxIndexedChunks=" + this.maxIndexedChunks + ", indexBlockSize=" + this.indexBlockSize + ", appendEnabled=" + this.appendEnabled + ", lazyCommitEnabled=" + this.lazyCommitEnabled + ", inlineDefragEnabled=" + this.inlineDefragEnabled + ", lateWarningThresholdInMillis=" + this.lateWarningThresholdInMillis + ", garbageCollectionDelay=" + this.garbageCollectionDelay + ", garbageCollectionMaxConcurrency=" + this.garbageCollectionMaxConcurrency + ", garbageCollectionMaxQueueSize=" + this.garbageCollectionMaxQueueSize + ", garbageCollectionSleep=" + this.garbageCollectionSleep + ", garbageCollectionMaxAttempts=" + this.garbageCollectionMaxAttempts + ", garbageCollectionTransactionBatchSize=" + this.garbageCollectionTransactionBatchSize + ", maxEntriesInTxnBuffer=" + this.maxEntriesInTxnBuffer + ", maxEntriesInCache=" + this.maxEntriesInCache + ", journalSnapshotInfoUpdateFrequency=" + this.journalSnapshotInfoUpdateFrequency + ", maxJournalUpdatesPerSnapshot=" + this.maxJournalUpdatesPerSnapshot + ", maxJournalReadAttempts=" + this.maxJournalReadAttempts + ", maxJournalWriteAttempts=" + this.maxJournalWriteAttempts + ", selfCheckEnabled=" + this.selfCheckEnabled + ")";
        }
    }
}

