/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.StreamSegmentTruncatedException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.StorageNotPrimaryException;
import io.pravega.segmentstore.storage.chunklayer.ChunkNameOffsetPair;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import io.pravega.segmentstore.storage.metadata.StorageMetadataWritesFencedOutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcatOperation
implements Callable<CompletableFuture<Void>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcatOperation.class);
    private final long traceId;
    private final SegmentHandle targetHandle;
    private final long offset;
    private final String sourceSegment;
    private final ChunkedSegmentStorage chunkedSegmentStorage;
    private final List<String> chunksToDelete = Collections.synchronizedList(new ArrayList());
    private final List<ChunkNameOffsetPair> newReadIndexEntries = Collections.synchronizedList(new ArrayList());
    private final Timer timer;
    private volatile SegmentMetadata targetSegmentMetadata;
    private volatile SegmentMetadata sourceSegmentMetadata;
    private volatile ChunkMetadata targetLastChunk;
    private volatile ChunkMetadata sourceFirstChunk;

    ConcatOperation(ChunkedSegmentStorage chunkedSegmentStorage, SegmentHandle targetHandle, long offset, String sourceSegment) {
        this.targetHandle = targetHandle;
        this.offset = offset;
        this.sourceSegment = sourceSegment;
        this.chunkedSegmentStorage = chunkedSegmentStorage;
        this.timer = new Timer();
        this.traceId = LoggerHelpers.traceEnter((Logger)log, (String)"concat", (Object[])new Object[]{targetHandle, offset, sourceSegment});
    }

    @Override
    public CompletableFuture<Void> call() {
        this.checkPreconditions();
        log.debug("{} concat - started op={}, target={}, source={}, offset={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.targetHandle.getSegmentName(), this.sourceSegment, this.offset});
        return ChunkedSegmentStorage.tryWith(this.chunkedSegmentStorage.getMetadataStore().beginTransaction(false, this.targetHandle.getSegmentName(), this.sourceSegment), txn -> txn.get(this.targetHandle.getSegmentName()).thenComposeAsync(storageMetadata1 -> {
            this.targetSegmentMetadata = (SegmentMetadata)storageMetadata1;
            return txn.get(this.sourceSegment).thenComposeAsync(storageMetadata2 -> {
                this.sourceSegmentMetadata = (SegmentMetadata)storageMetadata2;
                return this.performConcat((MetadataTransaction)txn);
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor()), this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> performConcat(MetadataTransaction txn) {
        this.checkState();
        long currentIndexOffset = this.targetSegmentMetadata.getLastChunkStartOffset();
        return this.updateMetadata(txn).thenComposeAsync(v -> {
            CompletableFuture<Object> f = this.shouldDefrag() && null != this.targetLastChunk ? this.chunkedSegmentStorage.defrag(txn, this.targetSegmentMetadata, this.targetLastChunk.getName(), null, this.chunksToDelete, this.newReadIndexEntries, currentIndexOffset) : CompletableFuture.completedFuture(null);
            return f.thenComposeAsync(v2 -> {
                this.targetSegmentMetadata.checkInvariants();
                return this.chunkedSegmentStorage.getGarbageCollector().addChunksToGarbage(txn.getVersion(), this.chunksToDelete).thenComposeAsync(v4 -> ((CompletableFuture)txn.commit().exceptionally(this::handleException)).thenRunAsync(this::postCommit, this.chunkedSegmentStorage.getExecutor()), this.chunkedSegmentStorage.getExecutor());
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private Void handleException(Throwable e) {
        log.debug("{} concat - exception op={}, target={}, source={}, offset={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.targetHandle.getSegmentName(), this.sourceSegment, this.offset});
        Throwable ex = Exceptions.unwrap((Throwable)e);
        if (ex instanceof StorageMetadataWritesFencedOutException) {
            throw new CompletionException((Throwable)((Object)new StorageNotPrimaryException(this.targetHandle.getSegmentName(), ex)));
        }
        throw new CompletionException(ex);
    }

    private void postCommit() {
        this.chunkedSegmentStorage.getReadIndexCache().remove(this.sourceSegment);
        this.chunkedSegmentStorage.getReadIndexCache().addIndexEntries(this.targetHandle.getSegmentName(), this.newReadIndexEntries);
        this.logEnd();
    }

    private void logEnd() {
        Duration elapsed = this.timer.getElapsed();
        ChunkStorageMetrics.SLTS_CONCAT_LATENCY.reportSuccessEvent(elapsed);
        ChunkStorageMetrics.SLTS_CONCAT_COUNT.inc();
        if ((long)this.chunkedSegmentStorage.getConfig().getLateWarningThresholdInMillis() < elapsed.toMillis()) {
            log.warn("{} concat - late op={}, target={}, source={}, offset={}, latency={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.targetHandle.getSegmentName(), this.sourceSegment, this.offset, elapsed.toMillis()});
        } else {
            log.debug("{} concat - finished op={}, target={}, source={}, offset={}, latency={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.targetHandle.getSegmentName(), this.sourceSegment, this.offset, elapsed.toMillis()});
        }
        LoggerHelpers.traceLeave((Logger)log, (String)"concat", (long)this.traceId, (Object[])new Object[]{this.targetHandle, this.offset, this.sourceSegment});
    }

    private CompletableFuture<Void> updateMetadata(MetadataTransaction txn) {
        return txn.get(this.targetSegmentMetadata.getLastChunk()).thenComposeAsync(storageMetadata1 -> {
            this.targetLastChunk = (ChunkMetadata)storageMetadata1;
            return txn.get(this.sourceSegmentMetadata.getFirstChunk()).thenAcceptAsync(storageMetadata2 -> {
                this.sourceFirstChunk = (ChunkMetadata)storageMetadata2;
                if (this.targetLastChunk != null) {
                    this.targetLastChunk.setNextChunk(this.sourceFirstChunk.getName());
                    txn.update(this.targetLastChunk);
                } else if (this.sourceFirstChunk != null) {
                    this.targetSegmentMetadata.setFirstChunk(this.sourceFirstChunk.getName());
                    txn.update(this.sourceFirstChunk);
                }
                this.targetSegmentMetadata.setLastChunk(this.sourceSegmentMetadata.getLastChunk());
                this.targetSegmentMetadata.setLastChunkStartOffset(this.targetSegmentMetadata.getLength() + this.sourceSegmentMetadata.getLastChunkStartOffset());
                this.targetSegmentMetadata.setLength(this.targetSegmentMetadata.getLength() + this.sourceSegmentMetadata.getLength() - this.sourceSegmentMetadata.getStartOffset());
                this.targetSegmentMetadata.setChunkCount(this.targetSegmentMetadata.getChunkCount() + this.sourceSegmentMetadata.getChunkCount());
                if (!this.sourceSegmentMetadata.isStorageSystemSegment()) {
                    this.chunkedSegmentStorage.deleteBlockIndexEntriesForChunk(txn, this.sourceSegment, this.sourceSegmentMetadata.getStartOffset(), this.sourceSegmentMetadata.getLength());
                }
                txn.update(this.targetSegmentMetadata);
                txn.delete(this.sourceSegment);
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private void checkState() {
        this.chunkedSegmentStorage.checkSegmentExists(this.targetHandle.getSegmentName(), this.targetSegmentMetadata);
        this.targetSegmentMetadata.checkInvariants();
        this.chunkedSegmentStorage.checkNotSealed(this.targetHandle.getSegmentName(), this.targetSegmentMetadata);
        this.chunkedSegmentStorage.checkSegmentExists(this.sourceSegment, this.sourceSegmentMetadata);
        this.sourceSegmentMetadata.checkInvariants();
        Preconditions.checkState((!this.targetSegmentMetadata.isStorageSystemSegment() ? 1 : 0) != 0, (String)"Storage system segments cannot be concatenated. Segment=%s", (Object)this.targetSegmentMetadata.getName());
        Preconditions.checkState((!this.sourceSegmentMetadata.isStorageSystemSegment() ? 1 : 0) != 0, (String)"Storage system segments cannot be concatenated. Segment=%s", (Object)this.sourceSegmentMetadata.getName());
        this.checkSealed(this.sourceSegmentMetadata);
        this.chunkedSegmentStorage.checkOwnership(this.targetSegmentMetadata.getName(), this.targetSegmentMetadata);
        if (this.sourceSegmentMetadata.getStartOffset() != 0L) {
            throw new CompletionException((Throwable)new StreamSegmentTruncatedException(this.sourceSegment, this.sourceSegmentMetadata.getLength(), 0L));
        }
        if (this.offset != this.targetSegmentMetadata.getLength()) {
            throw new CompletionException((Throwable)new BadOffsetException(this.targetHandle.getSegmentName(), this.targetSegmentMetadata.getLength(), this.offset));
        }
    }

    private void checkPreconditions() {
        Preconditions.checkArgument((!this.targetHandle.isReadOnly() ? 1 : 0) != 0, (String)"targetHandle must not be read only. Segment=%s", (Object)this.targetHandle.getSegmentName());
        Preconditions.checkArgument((this.offset >= 0L ? 1 : 0) != 0, (String)"offset must be non negative. Segment=%s offset=%s", (Object)this.targetHandle.getSegmentName(), (long)this.offset);
    }

    private void checkSealed(SegmentMetadata sourceSegmentMetadata) {
        if (!sourceSegmentMetadata.isSealed()) {
            throw new IllegalStateException("Source segment must be sealed.");
        }
    }

    private boolean shouldDefrag() {
        return (this.chunkedSegmentStorage.shouldAppend() || this.chunkedSegmentStorage.getChunkStorage().supportsConcat()) && this.chunkedSegmentStorage.getConfig().isInlineDefragEnabled();
    }
}

