/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkIterator;
import io.pravega.segmentstore.storage.chunklayer.ChunkNameOffsetPair;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefragmentOperation
implements Callable<CompletableFuture<Void>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefragmentOperation.class);
    private final MetadataTransaction txn;
    private final SegmentMetadata segmentMetadata;
    private final String startChunkName;
    private final String lastChunkName;
    private final List<String> chunksToDelete;
    private final ChunkedSegmentStorage chunkedSegmentStorage;
    private volatile List<ChunkInfo> chunksToConcat = Collections.synchronizedList(new ArrayList());
    private final List<ChunkNameOffsetPair> newReadIndexEntries;
    private volatile ChunkMetadata target;
    private volatile String targetChunkName;
    private final AtomicBoolean useAppend = new AtomicBoolean();
    private final AtomicBoolean skipFailed = new AtomicBoolean();
    private final AtomicLong targetSizeAfterConcat = new AtomicLong();
    private volatile String nextChunkName;
    private volatile ChunkMetadata next = null;
    private final AtomicLong writeAtOffset = new AtomicLong();
    private final AtomicLong readAtOffset = new AtomicLong();
    private final AtomicLong bytesToRead = new AtomicLong();
    private final AtomicInteger currentArgIndex = new AtomicInteger();
    private final AtomicLong currentIndexOffset = new AtomicLong();

    DefragmentOperation(ChunkedSegmentStorage chunkedSegmentStorage, MetadataTransaction txn, SegmentMetadata segmentMetadata, String startChunkName, String lastChunkName, List<String> chunksToDelete, List<ChunkNameOffsetPair> newReadIndexEntries, long currentIndexOffset) {
        this.txn = txn;
        this.segmentMetadata = segmentMetadata;
        this.startChunkName = startChunkName;
        this.lastChunkName = lastChunkName;
        this.chunksToDelete = chunksToDelete;
        this.newReadIndexEntries = newReadIndexEntries;
        this.chunkedSegmentStorage = chunkedSegmentStorage;
        this.currentIndexOffset.set(currentIndexOffset);
    }

    @Override
    public CompletableFuture<Void> call() {
        this.useAppend.set(true);
        this.targetChunkName = this.startChunkName;
        int oldChunkCount = this.segmentMetadata.getChunkCount();
        return Futures.loop(() -> null != this.targetChunkName && !this.targetChunkName.equals(this.lastChunkName), () -> this.gatherChunks().thenComposeAsync(v -> {
            CompletionStage<Object> f = this.chunksToConcat.size() > 1 ? this.concatChunks().handleAsync((vv, ex) -> {
                if (null != ex) {
                    InvalidOffsetException invalidEx;
                    if ((ex = Exceptions.unwrap((Throwable)ex)) instanceof InvalidOffsetException && (invalidEx = (InvalidOffsetException)ex).getExpectedOffset() > invalidEx.getGivenOffset()) {
                        this.targetChunkName = this.chunksToConcat.get(1).getName();
                        this.chunksToConcat.clear();
                        this.skipFailed.set(true);
                        log.debug("{} defrag - skipping partially written chunk op={}, {}", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), invalidEx.getMessage()});
                        return null;
                    }
                    throw new CompletionException((Throwable)ex);
                }
                return vv;
            }, this.chunkedSegmentStorage.getExecutor()) : CompletableFuture.completedFuture(null);
            return f.thenRunAsync(() -> {
                if (this.skipFailed.compareAndSet(true, false)) {
                    return;
                }
                if (!this.useAppend.get()) {
                    this.targetChunkName = this.nextChunkName;
                }
                this.useAppend.set(!this.useAppend.get());
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor()), (Executor)this.chunkedSegmentStorage.getExecutor()).thenComposeAsync(vvv -> {
            Preconditions.checkState((oldChunkCount - this.chunksToDelete.size() == this.segmentMetadata.getChunkCount() ? 1 : 0) != 0, (String)"Number of chunks do not match. old value (%s) - number of chunks deleted (%s) must match current chunk count(%s)", (Object)oldChunkCount, (Object)this.chunksToDelete.size(), (Object)this.segmentMetadata.getChunkCount());
            this.segmentMetadata.checkInvariants();
            return this.updateReadIndex();
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> concatChunks() {
        ConcatArgument[] concatArgs = new ConcatArgument[this.chunksToConcat.size()];
        for (int i = 0; i < this.chunksToConcat.size(); ++i) {
            concatArgs[i] = ConcatArgument.fromChunkInfo(this.chunksToConcat.get(i));
        }
        CompletableFuture<Integer> f = !this.useAppend.get() && this.chunkedSegmentStorage.getChunkStorage().supportsConcat() || !this.chunkedSegmentStorage.shouldAppend() ? this.chunkedSegmentStorage.getChunkStorage().concat(concatArgs) : this.concatUsingAppend(concatArgs);
        return f.thenComposeAsync(v -> {
            for (int i = 1; i < this.chunksToConcat.size(); ++i) {
                this.chunksToDelete.add(this.chunksToConcat.get(i).getName());
            }
            this.target.setLength(this.targetSizeAfterConcat.get());
            this.target.setNextChunk(this.nextChunkName);
            if (null == this.nextChunkName) {
                this.segmentMetadata.setLastChunk(this.target.getName());
                this.segmentMetadata.setLastChunkStartOffset(this.segmentMetadata.getLength() - this.target.getLength());
            }
            List<CompletionStage> futures = Collections.synchronizedList(new ArrayList());
            int i = 1;
            while (i < concatArgs.length) {
                int n = i++;
                futures.add(this.txn.get(concatArgs[n].getName()).thenAcceptAsync(metadata -> {
                    ((ChunkMetadata)metadata).setActive(false);
                    this.txn.update((StorageMetadata)metadata);
                }, this.chunkedSegmentStorage.getExecutor()));
                this.segmentMetadata.setChunkCount(this.segmentMetadata.getChunkCount() - 1);
            }
            return Futures.allOf(futures).thenRunAsync(() -> {
                this.txn.update(this.target);
                this.txn.update(this.segmentMetadata);
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> gatherChunks() {
        return this.txn.get(this.targetChunkName).thenComposeAsync(storageMetadata -> {
            this.target = (ChunkMetadata)storageMetadata;
            this.chunksToConcat = Collections.synchronizedList(new ArrayList());
            this.targetSizeAfterConcat.set(this.target.getLength());
            this.chunksToConcat.add(new ChunkInfo(this.targetSizeAfterConcat.get(), this.targetChunkName));
            this.nextChunkName = this.target.getNextChunk();
            return this.txn.get(this.nextChunkName).thenComposeAsync(storageMetadata1 -> {
                this.next = (ChunkMetadata)storageMetadata1;
                return Futures.loop(() -> null != this.nextChunkName && (!this.useAppend.get() || this.chunkedSegmentStorage.getConfig().getMinSizeLimitForConcat() >= this.next.getLength()) && this.targetSizeAfterConcat.get() + this.next.getLength() <= this.segmentMetadata.getMaxRollinglength() && this.next.getLength() <= this.chunkedSegmentStorage.getConfig().getMaxSizeLimitForConcat(), () -> this.txn.get(this.nextChunkName).thenAcceptAsync(storageMetadata2 -> {
                    this.next = (ChunkMetadata)storageMetadata2;
                    this.chunksToConcat.add(new ChunkInfo(this.next.getLength(), this.nextChunkName));
                    this.targetSizeAfterConcat.addAndGet(this.next.getLength());
                    this.nextChunkName = this.next.getNextChunk();
                }, this.chunkedSegmentStorage.getExecutor()), (Executor)this.chunkedSegmentStorage.getExecutor());
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Integer> concatUsingAppend(ConcatArgument[] concatArgs) {
        this.writeAtOffset.set(concatArgs[0].getLength());
        ChunkHandle writeHandle = ChunkHandle.writeHandle(concatArgs[0].getName());
        this.currentArgIndex.set(1);
        return Futures.loop(() -> this.currentArgIndex.get() < concatArgs.length, () -> {
            this.readAtOffset.set(0L);
            ConcatArgument arg = concatArgs[this.currentArgIndex.get()];
            this.bytesToRead.set(arg.getLength());
            return this.copyBytes(writeHandle, arg).thenRunAsync(this.currentArgIndex::incrementAndGet, this.chunkedSegmentStorage.getExecutor());
        }, (Executor)this.chunkedSegmentStorage.getExecutor()).thenApplyAsync(v -> 0, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> copyBytes(ChunkHandle writeHandle, ConcatArgument arg) {
        return Futures.loop(() -> this.bytesToRead.get() > 0L, () -> {
            byte[] buffer = new byte[Math.toIntExact(Math.min((long)this.chunkedSegmentStorage.getConfig().getMaxBufferSizeForChunkDataTransfer(), this.bytesToRead.get()))];
            return this.chunkedSegmentStorage.getChunkStorage().read(ChunkHandle.readHandle(arg.getName()), this.readAtOffset.get(), buffer.length, buffer, 0).thenComposeAsync(size -> {
                this.bytesToRead.addAndGet(-size.intValue());
                this.readAtOffset.addAndGet(size.intValue());
                return this.chunkedSegmentStorage.getChunkStorage().write(writeHandle, this.writeAtOffset.get(), (int)size, new ByteArrayInputStream(buffer, 0, (int)size)).thenAcceptAsync(this.writeAtOffset::addAndGet, this.chunkedSegmentStorage.getExecutor());
            }, this.chunkedSegmentStorage.getExecutor());
        }, (Executor)this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> updateReadIndex() {
        return new ChunkIterator(this.chunkedSegmentStorage.getExecutor(), this.txn, this.startChunkName, this.lastChunkName).forEach((metadata, name) -> {
            this.newReadIndexEntries.add(ChunkNameOffsetPair.builder().chunkName((String)name).offset(this.currentIndexOffset.get()).build());
            if (!this.segmentMetadata.isStorageSystemSegment()) {
                this.chunkedSegmentStorage.addBlockIndexEntriesForChunk(this.txn, this.segmentMetadata.getName(), metadata.getName(), this.currentIndexOffset.get(), this.currentIndexOffset.get(), this.currentIndexOffset.get() + metadata.getLength());
            }
            this.currentIndexOffset.addAndGet(metadata.getLength());
        });
    }
}

