/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.MultiKeySequentialProcessor;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.storage.chunklayer.AbstractTaskQueueManager;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.chunklayer.StatsReporter;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollector
implements AutoCloseable,
StatsReporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    private final ChunkStorage chunkStorage;
    private final ChunkMetadataStore metadataStore;
    private final ChunkedSegmentStorageConfig config;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final AtomicLong iterationId = new AtomicLong();
    private final Supplier<Long> currentTimeSupplier;
    private final Function<Duration, CompletableFuture<Void>> delaySupplier;
    private final ScheduledExecutorService storageExecutor;
    private AbstractTaskQueueManager<TaskInfo> taskQueue;
    private final String traceObjectId;
    private final String taskQueueName;
    private final String failedQueueName;
    private final MultiKeySequentialProcessor<String> taskScheduler;

    public GarbageCollector(int containerId, ChunkStorage chunkStorage, ChunkMetadataStore metadataStore, ChunkedSegmentStorageConfig config, ScheduledExecutorService executorService) {
        this(containerId, chunkStorage, metadataStore, config, executorService, System::currentTimeMillis, duration -> Futures.delayedFuture((Duration)duration, (ScheduledExecutorService)executorService));
    }

    public GarbageCollector(int containerId, ChunkStorage chunkStorage, ChunkMetadataStore metadataStore, ChunkedSegmentStorageConfig config, ScheduledExecutorService storageExecutor, Supplier<Long> currentTimeSupplier, Function<Duration, CompletableFuture<Void>> delaySupplier) {
        this.chunkStorage = (ChunkStorage)Preconditions.checkNotNull((Object)chunkStorage, (Object)"chunkStorage");
        this.metadataStore = (ChunkMetadataStore)Preconditions.checkNotNull((Object)metadataStore, (Object)"metadataStore");
        this.config = (ChunkedSegmentStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.currentTimeSupplier = (Supplier)Preconditions.checkNotNull(currentTimeSupplier, (Object)"currentTimeSupplier");
        this.delaySupplier = (Function)Preconditions.checkNotNull(delaySupplier, (Object)"delaySupplier");
        this.storageExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)storageExecutor, (Object)"storageExecutor");
        this.traceObjectId = String.format("GarbageCollector[%d]", containerId);
        this.taskQueueName = String.format("GC.queue.%d", containerId);
        this.failedQueueName = String.format("GC.failed.queue.%d", containerId);
        this.taskScheduler = new MultiKeySequentialProcessor((Executor)storageExecutor);
    }

    public CompletableFuture<Void> initialize(AbstractTaskQueueManager<TaskInfo> taskQueue) {
        this.taskQueue = (AbstractTaskQueueManager)Preconditions.checkNotNull(taskQueue, (Object)"taskQueue");
        return taskQueue.addQueue(this.taskQueueName, false).thenComposeAsync(v -> taskQueue.addQueue(this.failedQueueName, true), (Executor)this.storageExecutor);
    }

    CompletableFuture<Void> addChunksToGarbage(long transactionId, Collection<String> chunksToDelete) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        ArrayList futures = new ArrayList();
        long startTime = this.currentTimeSupplier.get() + this.config.getGarbageCollectionDelay().toMillis();
        chunksToDelete.forEach(chunkToDelete -> futures.add(this.addChunkToGarbage(transactionId, (String)chunkToDelete, startTime, 0)));
        return Futures.allOf(futures);
    }

    CompletableFuture<Void> addChunkToGarbage(long transactionId, String chunkToDelete, long startTime, int attempts) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        return this.taskQueue.addTask(this.taskQueueName, new TaskInfo(chunkToDelete, startTime, attempts, 1, transactionId)).thenRunAsync(() -> {
            this.queueSize.incrementAndGet();
            ChunkStorageMetrics.SLTS_GC_CHUNK_QUEUED.inc();
        }, this.storageExecutor);
    }

    CompletableFuture<Void> addSegmentToGarbage(long transactionId, String segmentToDelete) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        long startTime = this.currentTimeSupplier.get() + this.config.getGarbageCollectionDelay().toMillis();
        return this.taskQueue.addTask(this.taskQueueName, new TaskInfo(segmentToDelete, startTime, 0, 2, transactionId)).thenRunAsync(() -> {
            this.queueSize.incrementAndGet();
            ChunkStorageMetrics.SLTS_GC_SEGMENT_QUEUED.inc();
        }, this.storageExecutor);
    }

    CompletableFuture<Void> addSegmentToGarbage(TaskInfo taskInfo) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        return this.taskQueue.addTask(this.taskQueueName, taskInfo).thenRunAsync(() -> {
            this.queueSize.incrementAndGet();
            ChunkStorageMetrics.SLTS_GC_SEGMENT_QUEUED.inc();
        }, this.storageExecutor);
    }

    CompletableFuture<Void> trackNewChunk(long transactionId, String chunktoTrack) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        long startTime = this.currentTimeSupplier.get() + this.config.getGarbageCollectionDelay().toMillis();
        return this.taskQueue.addTask(this.taskQueueName, new TaskInfo(chunktoTrack, startTime, 0, 1, transactionId)).thenRunAsync(() -> {
            this.queueSize.incrementAndGet();
            ChunkStorageMetrics.SLTS_GC_CHUNK_NEW.inc();
        }, this.storageExecutor);
    }

    private CompletableFuture<Void> failTask(TaskInfo infoToRetire) {
        Preconditions.checkState((null != this.taskQueue ? 1 : 0) != 0, (Object)"taskQueue must not be null.");
        return this.taskQueue.addTask(this.failedQueueName, infoToRetire);
    }

    private CompletableFuture<Void> deleteSegment(TaskInfo taskInfo) {
        String streamSegmentName = taskInfo.getName();
        MetadataTransaction txn = this.metadataStore.beginTransaction(true, streamSegmentName);
        return txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
            SegmentMetadata segmentMetadata = (SegmentMetadata)storageMetadata;
            if (null == segmentMetadata) {
                log.debug("{}: deleteGarbage - Segment metadata does not exist. segment={}.", (Object)this.traceObjectId, (Object)streamSegmentName);
                return CompletableFuture.completedFuture(null);
            }
            if (segmentMetadata.isActive()) {
                log.debug("{}: deleteGarbage - Segment is not marked as deleted. segment={}.", (Object)this.traceObjectId, (Object)streamSegmentName);
                return CompletableFuture.completedFuture(null);
            }
            Set chunksToDelete = Collections.synchronizedSet(new HashSet());
            Set currentBatch = Collections.synchronizedSet(new HashSet());
            AtomicReference<String> currentChunkName = new AtomicReference<String>(segmentMetadata.getFirstChunk());
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)Futures.loop(() -> null != currentChunkName.get(), () -> txn.get((String)currentChunkName.get()).thenComposeAsync(metadata -> {
                ChunkMetadata chunkMetadata = (ChunkMetadata)metadata;
                CompletableFuture<Object> retFuture = CompletableFuture.completedFuture(null);
                if (null == chunkMetadata) {
                    currentChunkName.set(null);
                    return retFuture;
                }
                chunksToDelete.add(chunkMetadata.getName());
                currentBatch.add(chunkMetadata);
                if (chunkMetadata.isActive() && currentBatch.size() > this.config.getGarbageCollectionTransactionBatchSize()) {
                    retFuture = this.addTransactionForUpdateBatch(currentBatch, streamSegmentName);
                    currentBatch.clear();
                }
                currentChunkName.set(chunkMetadata.getNextChunk());
                return retFuture;
            }, (Executor)this.storageExecutor), (Executor)this.storageExecutor).thenComposeAsync(v -> {
                if (currentBatch.size() > 0) {
                    return this.addTransactionForUpdateBatch(currentBatch, streamSegmentName);
                }
                return CompletableFuture.completedFuture(null);
            }, (Executor)this.storageExecutor)).thenComposeAsync(v -> this.addChunksToGarbage(txn.getVersion(), chunksToDelete), (Executor)this.storageExecutor)).thenComposeAsync(v -> this.deleteBlockIndexEntriesForSegment(streamSegmentName, segmentMetadata.getStartOffset(), segmentMetadata.getLength()))).thenComposeAsync(v -> {
                MetadataTransaction innerTxn = this.metadataStore.beginTransaction(false, segmentMetadata.getName());
                innerTxn.delete(segmentMetadata.getName());
                return innerTxn.commit().whenCompleteAsync((vv, ex) -> innerTxn.close(), (Executor)this.storageExecutor);
            }, (Executor)this.storageExecutor)).handleAsync((v, e) -> {
                txn.close();
                if (null != e) {
                    log.error(String.format("%s deleteGarbage - Could not delete metadata for garbage segment=%s.", this.traceObjectId, streamSegmentName), e);
                    return true;
                }
                return false;
            }, (Executor)this.storageExecutor)).thenComposeAsync(failed -> {
                if (failed.booleanValue()) {
                    if (taskInfo.getAttempts() < this.config.getGarbageCollectionMaxAttempts()) {
                        int attempts = taskInfo.attempts + 1;
                        ChunkStorageMetrics.SLTS_GC_SEGMENT_RETRY.inc();
                        return this.addSegmentToGarbage(taskInfo.toBuilder().attempts(attempts).build());
                    }
                    ChunkStorageMetrics.SLTS_GC_SEGMENT_FAILED.inc();
                    log.info("{}: deleteGarbage - could not delete after max attempts segment={}.", (Object)this.traceObjectId, (Object)taskInfo.getName());
                    return this.failTask(taskInfo);
                }
                ChunkStorageMetrics.SLTS_GC_SEGMENT_PROCESSED.inc();
                return CompletableFuture.completedFuture(null);
            }, (Executor)this.storageExecutor);
        }, (Executor)this.storageExecutor);
    }

    private CompletableFuture<Void> addTransactionForUpdateBatch(Set<ChunkMetadata> batch, String name) {
        MetadataTransaction innerTxn = this.metadataStore.beginTransaction(false, name);
        for (ChunkMetadata chunkMetadata : batch) {
            chunkMetadata.setActive(false);
            innerTxn.update(chunkMetadata);
        }
        return innerTxn.commit().whenCompleteAsync((vv, ex) -> innerTxn.close(), (Executor)this.storageExecutor);
    }

    void deleteBlockIndexEntriesForChunk(MetadataTransaction txn, String segmentName, long startOffset, long endOffset) {
        long firstBlock = startOffset / this.config.getIndexBlockSize();
        for (long offset = firstBlock * this.config.getIndexBlockSize(); offset < endOffset; offset += this.config.getIndexBlockSize()) {
            txn.delete(NameUtils.getSegmentReadIndexBlockName((String)segmentName, (long)offset));
        }
    }

    CompletableFuture<Void> deleteBlockIndexEntriesForSegment(String segmentName, long startOffset, long endOffset) {
        long firstBlock = startOffset / this.config.getIndexBlockSize();
        AtomicBoolean isDone = new AtomicBoolean(false);
        AtomicLong offset = new AtomicLong(firstBlock * this.config.getIndexBlockSize());
        return Futures.loop(() -> !isDone.get(), () -> {
            HashSet<String> currentBatch = new HashSet<String>();
            while (offset.get() < endOffset) {
                String name = NameUtils.getSegmentReadIndexBlockName((String)segmentName, (long)offset.get());
                if (currentBatch.size() >= this.config.getGarbageCollectionTransactionBatchSize()) {
                    return this.addTransactionForDeleteBatch(currentBatch, segmentName);
                }
                currentBatch.add(name);
                offset.addAndGet(this.config.getIndexBlockSize());
            }
            isDone.set(true);
            if (currentBatch.size() > 0) {
                return this.addTransactionForDeleteBatch(currentBatch, segmentName);
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.storageExecutor);
    }

    private CompletableFuture<Void> addTransactionForDeleteBatch(Set<String> batch, String segmentName) {
        MetadataTransaction innerTxn = this.metadataStore.beginTransaction(false, segmentName);
        for (String entryName : batch) {
            innerTxn.delete(entryName);
        }
        return innerTxn.commit().whenCompleteAsync((vv, ex) -> innerTxn.close(), (Executor)this.storageExecutor);
    }

    public CompletableFuture<Void> processBatch(List<TaskInfo> batch) {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (TaskInfo infoToDelete : batch) {
            if (this.metadataStore.isTransactionActive(infoToDelete.transactionId)) {
                log.debug("{}: deleteGarbage - transaction is still active - re-queuing {}.", (Object)this.traceObjectId, (Object)infoToDelete.transactionId);
                this.taskQueue.addTask(this.taskQueueName, infoToDelete);
                continue;
            }
            CompletableFuture f = this.executeSerialized(() -> this.processTask(infoToDelete), infoToDelete.name);
            Long now = this.currentTimeSupplier.get();
            if (infoToDelete.scheduledTime > this.currentTimeSupplier.get()) {
                futures.add(this.delaySupplier.apply(Duration.ofMillis(infoToDelete.scheduledTime - now)).thenComposeAsync(v -> f, (Executor)this.storageExecutor));
                continue;
            }
            futures.add(f);
        }
        return Futures.allOf(futures).thenRunAsync(() -> {
            this.queueSize.addAndGet(-batch.size());
            ChunkStorageMetrics.SLTS_GC_TASK_PROCESSED.add((long)batch.size());
        }, this.storageExecutor);
    }

    private <R> CompletableFuture<R> executeSerialized(Callable<CompletableFuture<R>> operation, String ... keyNames) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.taskScheduler.add(Arrays.asList(keyNames), () -> this.executeExclusive(operation, keyNames));
    }

    private <R> CompletableFuture<R> executeExclusive(Callable<CompletableFuture<R>> operation, String ... keyNames) {
        return CompletableFuture.completedFuture(null).thenComposeAsync(v -> {
            Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
            try {
                return (CompletionStage)operation.call();
            }
            catch (Exception e) {
                throw new CompletionException(Exceptions.unwrap((Throwable)e));
            }
        }, (Executor)this.storageExecutor);
    }

    private CompletableFuture<Void> processTask(TaskInfo infoToDelete) {
        if (infoToDelete.taskType == 1) {
            return this.deleteChunk(infoToDelete);
        }
        if (infoToDelete.taskType == 2) {
            return this.deleteSegment(infoToDelete);
        }
        if (infoToDelete.taskType == 3) {
            return this.deleteChunk(infoToDelete);
        }
        log.info("{}: processTask - Ignoring unknown type of task {}.", (Object)this.traceObjectId, (Object)infoToDelete);
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> deleteChunk(TaskInfo infoToDelete) {
        String chunkToDelete = infoToDelete.name;
        AtomicReference failed = new AtomicReference();
        MetadataTransaction txn = this.metadataStore.beginTransaction(false, chunkToDelete);
        return ((CompletableFuture)((CompletableFuture)txn.get(infoToDelete.name).thenComposeAsync(metadata -> {
            ChunkMetadata chunkMetadata = (ChunkMetadata)metadata;
            boolean shouldDeleteChunk = null == chunkMetadata || !chunkMetadata.isActive();
            AtomicBoolean shouldDeleteMetadata = new AtomicBoolean(null != metadata && !chunkMetadata.isActive());
            if (shouldDeleteChunk) {
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.chunkStorage.delete(ChunkHandle.writeHandle(chunkToDelete)).handleAsync((v, e) -> {
                    if (e != null) {
                        Throwable ex = Exceptions.unwrap((Throwable)e);
                        if (ex instanceof ChunkNotFoundException) {
                            log.debug("{}: deleteGarbage - Could not delete garbage chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                        } else {
                            log.warn("{}: deleteGarbage - Could not delete garbage chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                            shouldDeleteMetadata.set(false);
                            failed.set(e);
                        }
                    } else {
                        ChunkStorageMetrics.SLTS_GC_CHUNK_DELETED.inc();
                        log.debug("{}: deleteGarbage - deleted chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                    }
                    return v;
                }, (Executor)this.storageExecutor)).thenRunAsync(() -> {
                    if (shouldDeleteMetadata.get()) {
                        txn.delete(chunkToDelete);
                        log.debug("{}: deleteGarbage - deleted metadata for chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                    }
                }, this.storageExecutor)).thenComposeAsync(v -> txn.commit(), (Executor)this.storageExecutor)).handleAsync((v, e) -> {
                    if (e != null) {
                        log.error(String.format("%s deleteGarbage - Could not delete metadata for garbage chunk=%s.", this.traceObjectId, chunkToDelete), e);
                        failed.set(e);
                    }
                    return v;
                }, (Executor)this.storageExecutor);
            }
            log.debug("{}: deleteGarbage - Chunk is not marked as garbage chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.storageExecutor)).thenComposeAsync(v -> {
            if (failed.get() != null) {
                if (infoToDelete.getAttempts() < this.config.getGarbageCollectionMaxAttempts()) {
                    log.debug("{}: deleteGarbage - adding back chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                    ChunkStorageMetrics.SLTS_GC_CHUNK_RETRY.inc();
                    return this.addChunkToGarbage(txn.getVersion(), chunkToDelete, infoToDelete.getScheduledTime() + this.config.getGarbageCollectionDelay().toMillis(), infoToDelete.getAttempts() + 1);
                }
                ChunkStorageMetrics.SLTS_GC_CHUNK_FAILED.inc();
                log.info("{}: deleteGarbage - could not delete after max attempts chunk={}.", (Object)this.traceObjectId, (Object)chunkToDelete);
                return this.failTask(infoToDelete);
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)this.storageExecutor)).whenCompleteAsync((v, ex) -> {
            if (ex != null) {
                log.error(String.format("%s deleteGarbage - Could not find garbage chunk=%s.", this.traceObjectId, chunkToDelete), ex);
            }
            txn.close();
        }, (Executor)this.storageExecutor);
    }

    @Override
    public void close() throws Exception {
        if (!this.closed.get()) {
            if (null != this.taskQueue) {
                this.taskQueue.close();
            }
            this.closed.set(true);
        }
    }

    @Override
    public void report() {
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.slts.GC_queue_record_count", (Number)this.queueSize.get(), new String[0]);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicInteger getQueueSize() {
        return this.queueSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AtomicLong getIterationId() {
        return this.iterationId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractTaskQueueManager<TaskInfo> getTaskQueue() {
        return this.taskQueue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTaskQueueName() {
        return this.taskQueueName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFailedQueueName() {
        return this.failedQueueName;
    }

    public static class TaskInfo
    extends AbstractTaskInfo {
        @NonNull
        private final String name;
        private final long scheduledTime;
        private final int attempts;
        private final int taskType;
        private final long transactionId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static TaskInfoBuilder builder() {
            return new TaskInfoBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskInfoBuilder toBuilder() {
            return new TaskInfoBuilder().name(this.name).scheduledTime(this.scheduledTime).attempts(this.attempts).taskType(this.taskType).transactionId(this.transactionId);
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getScheduledTime() {
            return this.scheduledTime;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getAttempts() {
            return this.attempts;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getTaskType() {
            return this.taskType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTransactionId() {
            return this.transactionId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GarbageCollector.TaskInfo(name=" + this.getName() + ", scheduledTime=" + this.getScheduledTime() + ", attempts=" + this.getAttempts() + ", taskType=" + this.getTaskType() + ", transactionId=" + this.getTransactionId() + ")";
        }

        @ConstructorProperties(value={"name", "scheduledTime", "attempts", "taskType", "transactionId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaskInfo(@NonNull String name, long scheduledTime, int attempts, int taskType, long transactionId) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.scheduledTime = scheduledTime;
            this.attempts = attempts;
            this.taskType = taskType;
            this.transactionId = transactionId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskInfo)) {
                return false;
            }
            TaskInfo other = (TaskInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getScheduledTime() != other.getScheduledTime()) {
                return false;
            }
            if (this.getAttempts() != other.getAttempts()) {
                return false;
            }
            if (this.getTaskType() != other.getTaskType()) {
                return false;
            }
            return this.getTransactionId() == other.getTransactionId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskInfo;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $scheduledTime = this.getScheduledTime();
            result = result * 59 + (int)($scheduledTime >>> 32 ^ $scheduledTime);
            result = result * 59 + this.getAttempts();
            result = result * 59 + this.getTaskType();
            long $transactionId = this.getTransactionId();
            result = result * 59 + (int)($transactionId >>> 32 ^ $transactionId);
            return result;
        }

        public static class Serializer
        extends VersionedSerializer.WithBuilder<TaskInfo, TaskInfoBuilder> {
            protected TaskInfoBuilder newBuilder() {
                return TaskInfo.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void write00(TaskInfo object, RevisionDataOutput output) throws IOException {
                output.writeUTF(object.name);
                output.writeCompactLong(object.scheduledTime);
                output.writeCompactInt(object.attempts);
                output.writeCompactInt(object.taskType);
                output.writeLong(object.transactionId);
            }

            private void read00(RevisionDataInput input, TaskInfoBuilder b) throws IOException {
                b.name(input.readUTF());
                b.scheduledTime(input.readCompactLong());
                b.attempts(input.readCompactInt());
                b.taskType(input.readCompactInt());
                b.transactionId(input.readLong());
            }
        }

        public static class TaskInfoBuilder
        implements ObjectBuilder<TaskInfo> {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String name;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long scheduledTime;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private int attempts;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private int taskType;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long transactionId;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            TaskInfoBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfoBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfoBuilder scheduledTime(long scheduledTime) {
                this.scheduledTime = scheduledTime;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfoBuilder attempts(int attempts) {
                this.attempts = attempts;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfoBuilder taskType(int taskType) {
                this.taskType = taskType;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfoBuilder transactionId(long transactionId) {
                this.transactionId = transactionId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TaskInfo build() {
                return new TaskInfo(this.name, this.scheduledTime, this.attempts, this.taskType, this.transactionId);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "GarbageCollector.TaskInfo.TaskInfoBuilder(name=" + this.name + ", scheduledTime=" + this.scheduledTime + ", attempts=" + this.attempts + ", taskType=" + this.taskType + ", transactionId=" + this.transactionId + ")";
            }
        }
    }

    public static abstract class AbstractTaskInfo {
        public static final int DELETE_CHUNK = 1;
        public static final int DELETE_SEGMENT = 2;
        public static final int DELETE_JOURNAL = 3;

        public static class AbstractTaskInfoSerializer
        extends VersionedSerializer.MultiType<AbstractTaskInfo> {
            protected void declareSerializers(VersionedSerializer.MultiType.Builder builder) {
                builder.serializer(TaskInfo.class, 1, (VersionedSerializer.WithBuilder)new TaskInfo.Serializer());
            }
        }
    }
}

