/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import lombok.Generated;

public class InvalidOffsetException
extends ChunkStorageException {
    private final long expectedOffset;
    private final long givenOffset;

    public InvalidOffsetException(String chunkName, long expectedOffset, long givenOffset, String message) {
        super(chunkName, InvalidOffsetException.getMessage(chunkName, expectedOffset, givenOffset, message));
        this.expectedOffset = expectedOffset;
        this.givenOffset = givenOffset;
    }

    public InvalidOffsetException(String chunkName, long expectedOffset, long givenOffset, String message, Throwable cause) {
        super(chunkName, InvalidOffsetException.getMessage(chunkName, expectedOffset, givenOffset, message), cause);
        this.expectedOffset = expectedOffset;
        this.givenOffset = givenOffset;
    }

    private static String getMessage(String chunkName, long expectedOffset, long givenOffset, String message) {
        return String.format("Expected offset (%d) did not match given offset (%d) for chunk %s - %s.", expectedOffset, givenOffset, chunkName, message);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getExpectedOffset() {
        return this.expectedOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGivenOffset() {
        return this.givenOffset;
    }
}

