/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.ChunkNameOffsetPair;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.StatsReporter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import lombok.NonNull;

class ReadIndexCache
implements StatsReporter {
    private final Cache<String, SegmentReadIndex> segmentsReadIndexCache;
    private final Cache<IndexEntry, Boolean> indexEntryCache;

    public ReadIndexCache(int maxIndexedSegments, int maxIndexedChunks) {
        Preconditions.checkArgument((maxIndexedSegments >= 0 ? 1 : 0) != 0, (Object)"maxIndexedSegments must be non negative");
        Preconditions.checkArgument((maxIndexedChunks >= 0 ? 1 : 0) != 0, (Object)"maxIndexedChunks must be non negative");
        this.segmentsReadIndexCache = CacheBuilder.newBuilder().maximumSize((long)maxIndexedSegments).removalListener(this::removeSegment).build();
        this.indexEntryCache = CacheBuilder.newBuilder().maximumSize((long)maxIndexedChunks).removalListener(this::removeChunk).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentReadIndex getSegmentReadIndex(String streamSegmentName, boolean createIfNotPresent) {
        SegmentReadIndex readIndex = (SegmentReadIndex)this.segmentsReadIndexCache.getIfPresent((Object)streamSegmentName);
        if (null == readIndex && createIfNotPresent) {
            Cache<String, SegmentReadIndex> cache = this.segmentsReadIndexCache;
            synchronized (cache) {
                readIndex = (SegmentReadIndex)this.segmentsReadIndexCache.getIfPresent((Object)streamSegmentName);
                if (null == readIndex) {
                    readIndex = new SegmentReadIndex();
                    this.segmentsReadIndexCache.put((Object)streamSegmentName, (Object)readIndex);
                }
            }
        }
        return readIndex;
    }

    public void addIndexEntries(String streamSegmentName, List<ChunkNameOffsetPair> newReadIndexEntries) {
        Preconditions.checkArgument((null != streamSegmentName ? 1 : 0) != 0, (Object)"streamSegmentName must not be null");
        Preconditions.checkArgument((null != newReadIndexEntries ? 1 : 0) != 0, (Object)"newReadIndexEntries must not be null");
        SegmentReadIndex segmentReadIndex = this.getSegmentReadIndex(streamSegmentName, true);
        for (ChunkNameOffsetPair entry : newReadIndexEntries) {
            this.addIndexEntry(segmentReadIndex, streamSegmentName, entry.getChunkName(), entry.getOffset());
        }
    }

    public void addIndexEntry(String streamSegmentName, String chunkName, long startOffset) {
        Preconditions.checkArgument((null != streamSegmentName ? 1 : 0) != 0, (Object)"streamSegmentName must not be null");
        Preconditions.checkArgument((null != chunkName ? 1 : 0) != 0, (String)"chunkName must not be null. Segment=%s", (Object)streamSegmentName);
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset must be non-negative. Segment=%s startOffset=%s", (Object)streamSegmentName, (long)startOffset);
        SegmentReadIndex segmentReadIndex = this.getSegmentReadIndex(streamSegmentName, true);
        this.addIndexEntry(segmentReadIndex, streamSegmentName, chunkName, startOffset);
    }

    private void addIndexEntry(SegmentReadIndex segmentReadIndex, String streamSegmentName, String chunkName, long startOffset) {
        IndexEntry indexEntry = IndexEntry.builder().streamSegmentName(streamSegmentName).chunkName(chunkName).startOffset(startOffset).build();
        IndexEntry existing = segmentReadIndex.offsetToChunkNameIndex.putIfAbsent(startOffset, indexEntry);
        if (null == existing) {
            this.indexEntryCache.put((Object)indexEntry, (Object)true);
        } else {
            Preconditions.checkState((boolean)existing.equals(indexEntry), (Object)(indexEntry.toString() + " != " + existing));
        }
    }

    public void remove(String streamSegmentName) {
        Preconditions.checkArgument((null != streamSegmentName ? 1 : 0) != 0, (Object)"streamSegmentName must not be null");
        SegmentReadIndex readIndex = (SegmentReadIndex)this.segmentsReadIndexCache.getIfPresent((Object)streamSegmentName);
        if (null != readIndex) {
            this.indexEntryCache.invalidateAll(readIndex.offsetToChunkNameIndex.values());
            readIndex.offsetToChunkNameIndex.clear();
            this.segmentsReadIndexCache.invalidate((Object)streamSegmentName);
        }
    }

    void removeSegment(RemovalNotification<String, SegmentReadIndex> notification) {
        if (notification.getCause() != RemovalCause.REPLACED) {
            SegmentReadIndex readIndex = (SegmentReadIndex)notification.getValue();
            this.indexEntryCache.invalidateAll(readIndex.offsetToChunkNameIndex.values());
            readIndex.offsetToChunkNameIndex.clear();
        }
    }

    void removeChunk(RemovalNotification<IndexEntry, Boolean> notification) {
        IndexEntry indexEntry;
        SegmentReadIndex segmentReadIndex;
        if (notification.getCause() != RemovalCause.REPLACED && null != (segmentReadIndex = this.getSegmentReadIndex((indexEntry = (IndexEntry)notification.getKey()).getStreamSegmentName(), false))) {
            segmentReadIndex.getOffsetToChunkNameIndex().remove(indexEntry.getStartOffset());
        }
    }

    public ChunkNameOffsetPair findFloor(String streamSegmentName, long offset) {
        Map.Entry<Long, IndexEntry> floorEntry;
        Preconditions.checkArgument((null != streamSegmentName ? 1 : 0) != 0, (Object)"streamSegmentName");
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset must be non-negative. Segment=%s offset=%s", (Object)streamSegmentName, (long)offset);
        SegmentReadIndex segmentReadIndex = this.getSegmentReadIndex(streamSegmentName, false);
        if (null != segmentReadIndex && segmentReadIndex.offsetToChunkNameIndex.size() > 0 && null != (floorEntry = segmentReadIndex.offsetToChunkNameIndex.floorEntry(offset))) {
            IndexEntry indexEntry = floorEntry.getValue();
            this.indexEntryCache.put((Object)indexEntry, (Object)true);
            return ChunkNameOffsetPair.builder().chunkName(floorEntry.getValue().getChunkName()).offset(floorEntry.getValue().getStartOffset()).build();
        }
        return null;
    }

    public void truncateReadIndex(String streamSegmentName, long startOffset) {
        SortedMap headMap;
        Preconditions.checkArgument((null != streamSegmentName ? 1 : 0) != 0, (Object)"streamSegmentName");
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset must be non-negative. Segment=%s startOffset=%s", (Object)streamSegmentName, (long)startOffset);
        SegmentReadIndex segmentReadIndex = this.getSegmentReadIndex(streamSegmentName, false);
        if (null != segmentReadIndex && segmentReadIndex.offsetToChunkNameIndex.size() > 0 && null != (headMap = segmentReadIndex.offsetToChunkNameIndex.headMap((Object)startOffset))) {
            ArrayList keysToRemove = new ArrayList(headMap.keySet());
            for (Long keyToRemove : keysToRemove) {
                IndexEntry indexEntry = segmentReadIndex.offsetToChunkNameIndex.get(keyToRemove);
                this.indexEntryCache.invalidate((Object)indexEntry);
                segmentReadIndex.offsetToChunkNameIndex.remove(keyToRemove);
            }
        }
    }

    public void cleanUp() {
        this.segmentsReadIndexCache.cleanUp();
        this.indexEntryCache.cleanUp();
    }

    @Override
    public void report() {
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.slts.read_index.segment_index_size", (Number)this.segmentsReadIndexCache.size(), new String[0]);
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.slts.read_index.segment_miss_rate", (Number)this.segmentsReadIndexCache.stats().missRate(), new String[0]);
        ChunkStorageMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.slts.read_index.chunks_index_size", (Number)this.indexEntryCache.size(), new String[0]);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Cache<String, SegmentReadIndex> getSegmentsReadIndexCache() {
        return this.segmentsReadIndexCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Cache<IndexEntry, Boolean> getIndexEntryCache() {
        return this.indexEntryCache;
    }

    static class IndexEntry {
        @NonNull
        String streamSegmentName;
        @NonNull
        String chunkName;
        long startOffset;

        @ConstructorProperties(value={"streamSegmentName", "chunkName", "startOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        IndexEntry(@NonNull String streamSegmentName, @NonNull String chunkName, long startOffset) {
            if (streamSegmentName == null) {
                throw new NullPointerException("streamSegmentName is marked non-null but is null");
            }
            if (chunkName == null) {
                throw new NullPointerException("chunkName is marked non-null but is null");
            }
            this.streamSegmentName = streamSegmentName;
            this.chunkName = chunkName;
            this.startOffset = startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static IndexEntryBuilder builder() {
            return new IndexEntryBuilder();
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getStreamSegmentName() {
            return this.streamSegmentName;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getChunkName() {
            return this.chunkName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setStreamSegmentName(@NonNull String streamSegmentName) {
            if (streamSegmentName == null) {
                throw new NullPointerException("streamSegmentName is marked non-null but is null");
            }
            this.streamSegmentName = streamSegmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setChunkName(@NonNull String chunkName) {
            if (chunkName == null) {
                throw new NullPointerException("chunkName is marked non-null but is null");
            }
            this.chunkName = chunkName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setStartOffset(long startOffset) {
            this.startOffset = startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexEntry)) {
                return false;
            }
            IndexEntry other = (IndexEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$streamSegmentName = this.getStreamSegmentName();
            String other$streamSegmentName = other.getStreamSegmentName();
            if (this$streamSegmentName == null ? other$streamSegmentName != null : !this$streamSegmentName.equals(other$streamSegmentName)) {
                return false;
            }
            String this$chunkName = this.getChunkName();
            String other$chunkName = other.getChunkName();
            if (this$chunkName == null ? other$chunkName != null : !this$chunkName.equals(other$chunkName)) {
                return false;
            }
            return this.getStartOffset() == other.getStartOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IndexEntry;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $streamSegmentName = this.getStreamSegmentName();
            result = result * 59 + ($streamSegmentName == null ? 43 : $streamSegmentName.hashCode());
            String $chunkName = this.getChunkName();
            result = result * 59 + ($chunkName == null ? 43 : $chunkName.hashCode());
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ReadIndexCache.IndexEntry(streamSegmentName=" + this.getStreamSegmentName() + ", chunkName=" + this.getChunkName() + ", startOffset=" + this.getStartOffset() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class IndexEntryBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String streamSegmentName;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String chunkName;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long startOffset;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            IndexEntryBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IndexEntryBuilder streamSegmentName(@NonNull String streamSegmentName) {
                if (streamSegmentName == null) {
                    throw new NullPointerException("streamSegmentName is marked non-null but is null");
                }
                this.streamSegmentName = streamSegmentName;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IndexEntryBuilder chunkName(@NonNull String chunkName) {
                if (chunkName == null) {
                    throw new NullPointerException("chunkName is marked non-null but is null");
                }
                this.chunkName = chunkName;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IndexEntryBuilder startOffset(long startOffset) {
                this.startOffset = startOffset;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public IndexEntry build() {
                return new IndexEntry(this.streamSegmentName, this.chunkName, this.startOffset);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "ReadIndexCache.IndexEntry.IndexEntryBuilder(streamSegmentName=" + this.streamSegmentName + ", chunkName=" + this.chunkName + ", startOffset=" + this.startOffset + ")";
            }
        }
    }

    static class SegmentReadIndex {
        private final ConcurrentSkipListMap<Long, IndexEntry> offsetToChunkNameIndex = new ConcurrentSkipListMap();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static SegmentReadIndexBuilder builder() {
            return new SegmentReadIndexBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentReadIndex() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConcurrentSkipListMap<Long, IndexEntry> getOffsetToChunkNameIndex() {
            return this.offsetToChunkNameIndex;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class SegmentReadIndexBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            SegmentReadIndexBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public SegmentReadIndex build() {
                return new SegmentReadIndex();
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "ReadIndexCache.SegmentReadIndex.SegmentReadIndexBuilder()";
            }
        }
    }
}

