/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.chunklayer;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.BoundedInputStream;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.StorageNotPrimaryException;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkNameOffsetPair;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageMetrics;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.segmentstore.storage.chunklayer.SystemJournal;
import io.pravega.segmentstore.storage.metadata.ChunkMetadata;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.SegmentMetadata;
import io.pravega.segmentstore.storage.metadata.StorageMetadataWritesFencedOutException;
import io.pravega.shared.NameUtils;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteOperation
implements Callable<CompletableFuture<Void>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteOperation.class);
    private final SegmentHandle handle;
    private final long offset;
    private final InputStream data;
    private final int length;
    private final ChunkedSegmentStorage chunkedSegmentStorage;
    private final long traceId;
    private final Timer timer;
    private final List<SystemJournal.SystemJournalRecord> systemLogRecords = Collections.synchronizedList(new ArrayList());
    private final List<ChunkNameOffsetPair> newReadIndexEntries = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger chunksAddedCount = new AtomicInteger();
    private volatile boolean isCommitted = false;
    private volatile SegmentMetadata segmentMetadata;
    private volatile boolean isSystemSegment;
    private volatile boolean isFirstWriteAfterFailover;
    private volatile boolean skipOverFailedChunk;
    private final AtomicReference<ChunkMetadata> lastChunkMetadata = new AtomicReference<Object>(null);
    private volatile ChunkHandle chunkHandle = null;
    private final AtomicLong bytesRemaining = new AtomicLong();
    private final AtomicLong currentOffset = new AtomicLong();
    private volatile boolean didSegmentLayoutChange = false;

    WriteOperation(ChunkedSegmentStorage chunkedSegmentStorage, SegmentHandle handle, long offset, InputStream data, int length) {
        this.handle = handle;
        this.offset = offset;
        this.data = data;
        this.length = length;
        this.chunkedSegmentStorage = chunkedSegmentStorage;
        this.traceId = LoggerHelpers.traceEnter((Logger)log, (String)"write", (Object[])new Object[]{handle, offset, length});
        this.timer = new Timer();
    }

    @Override
    public CompletableFuture<Void> call() {
        this.checkPreconditions();
        log.debug("{} write - started op={}, segment={}, offset={} length={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), this.offset, this.length});
        String streamSegmentName = this.handle.getSegmentName();
        return ChunkedSegmentStorage.tryWith(this.chunkedSegmentStorage.getMetadataStore().beginTransaction(false, this.handle.getSegmentName()), txn -> {
            this.didSegmentLayoutChange = false;
            return txn.get(streamSegmentName).thenComposeAsync(storageMetadata -> {
                this.segmentMetadata = (SegmentMetadata)storageMetadata;
                this.checkState();
                this.isSystemSegment = this.chunkedSegmentStorage.isStorageSystemSegment(this.segmentMetadata);
                this.isFirstWriteAfterFailover = this.segmentMetadata.isOwnershipChanged();
                this.lastChunkMetadata.set(null);
                this.chunkHandle = null;
                this.bytesRemaining.set(this.length);
                this.currentOffset.set(this.offset);
                return this.getLastChunk((MetadataTransaction)txn).thenComposeAsync(v -> ((CompletableFuture)this.writeData((MetadataTransaction)txn).thenComposeAsync(vv -> ((CompletableFuture)this.commit((MetadataTransaction)txn).thenApplyAsync(vvvv -> this.postCommit(), this.chunkedSegmentStorage.getExecutor())).exceptionally(this::handleException), this.chunkedSegmentStorage.getExecutor())).thenRunAsync(this::logEnd, this.chunkedSegmentStorage.getExecutor()), this.chunkedSegmentStorage.getExecutor());
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private Object handleException(Throwable e) {
        log.debug("{} write - exception op={}, segment={}, offset={}, length={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), this.offset, this.length});
        Throwable ex = Exceptions.unwrap((Throwable)e);
        if (ex instanceof StorageMetadataWritesFencedOutException) {
            throw new CompletionException((Throwable)((Object)new StorageNotPrimaryException(this.handle.getSegmentName(), ex)));
        }
        throw new CompletionException(ex);
    }

    private Object postCommit() {
        this.chunkedSegmentStorage.getReadIndexCache().addIndexEntries(this.handle.getSegmentName(), this.newReadIndexEntries);
        return null;
    }

    private CompletableFuture<Void> getLastChunk(MetadataTransaction txn) {
        if (null != this.segmentMetadata.getLastChunk()) {
            return txn.get(this.segmentMetadata.getLastChunk()).thenAcceptAsync(storageMetadata1 -> this.lastChunkMetadata.set((ChunkMetadata)storageMetadata1), this.chunkedSegmentStorage.getExecutor());
        }
        return CompletableFuture.completedFuture(null);
    }

    private void logEnd() {
        Duration elapsed = this.timer.getElapsed();
        ChunkStorageMetrics.SLTS_WRITE_LATENCY.reportSuccessEvent(elapsed);
        ChunkStorageMetrics.SLTS_WRITE_BYTES.add((long)this.length);
        ChunkStorageMetrics.SLTS_NUM_CHUNKS_ADDED.reportSuccessValue((long)this.chunksAddedCount.get());
        if (this.segmentMetadata.isStorageSystemSegment()) {
            ChunkStorageMetrics.SLTS_SYSTEM_WRITE_LATENCY.reportSuccessEvent(elapsed);
            ChunkStorageMetrics.SLTS_SYSTEM_WRITE_BYTES.add((long)this.length);
            ChunkStorageMetrics.SLTS_SYSTEM_NUM_CHUNKS_ADDED.reportSuccessValue((long)this.chunksAddedCount.get());
            this.chunkedSegmentStorage.reportMetricsForSystemSegment(this.segmentMetadata);
        }
        if (elapsed.toMillis() > 0L) {
            long bytesPerSecond = 1000L * (long)this.length / elapsed.toMillis();
            ChunkStorageMetrics.SLTS_WRITE_INSTANT_TPUT.reportSuccessValue(bytesPerSecond);
        }
        if ((long)this.chunkedSegmentStorage.getConfig().getLateWarningThresholdInMillis() < elapsed.toMillis()) {
            log.warn("{} write - late op={}, segment={}, offset={}, length={}, latency={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), this.offset, this.length, elapsed.toMillis()});
        } else {
            log.debug("{} write - finished op={}, segment={}, offset={}, length={}, latency={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), this.offset, this.length, elapsed.toMillis()});
        }
        LoggerHelpers.traceLeave((Logger)log, (String)"write", (long)this.traceId, (Object[])new Object[]{this.handle, this.offset});
    }

    private CompletableFuture<Void> commit(MetadataTransaction txn) {
        if (this.isSystemSegment && this.chunksAddedCount.get() > 0) {
            Preconditions.checkState((this.chunksAddedCount.get() == this.systemLogRecords.size() ? 1 : 0) != 0, (String)"Number of chunks added (%s) must match number of system log records(%s)", (int)this.chunksAddedCount.get(), (int)this.systemLogRecords.size());
            txn.setExternalCommitStep(() -> this.chunkedSegmentStorage.getSystemJournal().commitRecords(this.systemLogRecords));
        }
        return txn.commit(!this.didSegmentLayoutChange && this.chunkedSegmentStorage.getConfig().isLazyCommitEnabled()).thenRunAsync(() -> {
            this.isCommitted = true;
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> writeData(MetadataTransaction txn) {
        int oldChunkCount = this.segmentMetadata.getChunkCount();
        long oldLength = this.segmentMetadata.getLength();
        return Futures.loop(() -> this.bytesRemaining.get() > 0L, () -> this.openChunkToWrite(txn).thenComposeAsync(v -> {
            long oldOffset = this.currentOffset.get();
            long offsetToWriteAt = this.currentOffset.get() - this.segmentMetadata.getLastChunkStartOffset();
            int writeSize = (int)Math.min(this.bytesRemaining.get(), this.segmentMetadata.getMaxRollinglength() - offsetToWriteAt);
            return this.writeToChunk(txn, this.segmentMetadata, this.data, this.chunkHandle, this.lastChunkMetadata.get(), offsetToWriteAt, writeSize).thenRunAsync(() -> {
                if (!this.segmentMetadata.isStorageSystemSegment()) {
                    this.chunkedSegmentStorage.addBlockIndexEntriesForChunk(txn, this.segmentMetadata.getName(), this.chunkHandle.getChunkName(), this.segmentMetadata.getLastChunkStartOffset(), oldOffset, this.segmentMetadata.getLength());
                }
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor()), (Executor)this.chunkedSegmentStorage.getExecutor()).thenRunAsync(() -> {
            this.segmentMetadata.checkInvariants();
            Preconditions.checkState((oldChunkCount + this.chunksAddedCount.get() == this.segmentMetadata.getChunkCount() ? 1 : 0) != 0, (String)"Number of chunks do not match. old value (%s) + number of chunks added (%s) must match current chunk count(%s)", (Object)oldChunkCount, (Object)this.chunksAddedCount.get(), (Object)this.segmentMetadata.getChunkCount());
            Preconditions.checkState((oldLength + (long)this.length == this.segmentMetadata.getLength() ? 1 : 0) != 0, (String)"New length must match. old value (%s) + length (%s) must match current chunk count(%s)", (Object)oldLength, (Object)this.length, (Object)this.segmentMetadata.getLength());
            if (null != this.lastChunkMetadata.get()) {
                Preconditions.checkState((this.segmentMetadata.getLastChunkStartOffset() + this.lastChunkMetadata.get().getLength() == this.segmentMetadata.getLength() ? 1 : 0) != 0, (String)"Last chunk start offset (%s) + Last chunk length (%s) must match segment length (%s)", (Object)this.segmentMetadata.getLastChunkStartOffset(), (Object)this.lastChunkMetadata.get().getLength(), (Object)this.segmentMetadata.getLength());
            }
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private CompletableFuture<Void> openChunkToWrite(MetadataTransaction txn) {
        if (null == this.lastChunkMetadata.get() || this.lastChunkMetadata.get().getLength() >= this.segmentMetadata.getMaxRollinglength() || this.isFirstWriteAfterFailover || this.skipOverFailedChunk || !this.chunkedSegmentStorage.shouldAppend()) {
            return this.addNewChunk(txn);
        }
        this.chunkHandle = ChunkHandle.writeHandle(this.lastChunkMetadata.get().getName());
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> addNewChunk(MetadataTransaction txn) {
        String newChunkName = this.getNewChunkName(this.handle.getSegmentName(), this.segmentMetadata.getLength());
        return this.chunkedSegmentStorage.getGarbageCollector().trackNewChunk(txn.getVersion(), newChunkName).thenComposeAsync(v -> {
            CompletableFuture<ChunkHandle> createdHandle = this.chunkedSegmentStorage.shouldAppend() ? this.chunkedSegmentStorage.getChunkStorage().create(newChunkName) : CompletableFuture.completedFuture(ChunkHandle.writeHandle(newChunkName));
            return createdHandle.thenAcceptAsync(h -> {
                this.chunkHandle = h;
                String previousLastChunkName = this.lastChunkMetadata.get() == null ? null : this.lastChunkMetadata.get().getName();
                this.lastChunkMetadata.set(this.updateMetadataForChunkAddition(txn, this.segmentMetadata, newChunkName, this.isFirstWriteAfterFailover, this.lastChunkMetadata.get()));
                if (this.isSystemSegment) {
                    this.addSystemLogRecord(this.systemLogRecords, this.handle.getSegmentName(), this.segmentMetadata.getLength(), previousLastChunkName, newChunkName);
                    txn.markPinned(this.lastChunkMetadata.get());
                }
                this.newReadIndexEntries.add(new ChunkNameOffsetPair(this.segmentMetadata.getLength(), newChunkName));
                this.isFirstWriteAfterFailover = false;
                this.skipOverFailedChunk = false;
                this.didSegmentLayoutChange = true;
                this.chunksAddedCount.incrementAndGet();
                log.debug("{} write - New chunk added - op={}, segment={}, chunk={}, offset={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), newChunkName, this.segmentMetadata.getLength()});
            }, this.chunkedSegmentStorage.getExecutor());
        }, this.chunkedSegmentStorage.getExecutor());
    }

    private void checkState() {
        String streamSegmentName = this.handle.getSegmentName();
        this.chunkedSegmentStorage.checkSegmentExists(streamSegmentName, this.segmentMetadata);
        this.segmentMetadata.checkInvariants();
        this.chunkedSegmentStorage.checkNotSealed(streamSegmentName, this.segmentMetadata);
        this.chunkedSegmentStorage.checkOwnership(streamSegmentName, this.segmentMetadata);
        if (this.segmentMetadata.getLength() != this.offset) {
            throw new CompletionException((Throwable)new BadOffsetException(this.handle.getSegmentName(), this.segmentMetadata.getLength(), this.offset));
        }
    }

    private void checkPreconditions() {
        Preconditions.checkArgument((null != this.data ? 1 : 0) != 0, (Object)"data must not be null");
        Preconditions.checkArgument((!this.handle.isReadOnly() ? 1 : 0) != 0, (String)"handle must not be read only. Segment = %s", (Object)this.handle.getSegmentName());
        Preconditions.checkArgument((this.offset >= 0L ? 1 : 0) != 0, (String)"offset must be non negative. Segment = %s", (Object)this.handle.getSegmentName());
        Preconditions.checkArgument((this.length >= 0 ? 1 : 0) != 0, (String)"length must be non negative. Segment = %s", (Object)this.handle.getSegmentName());
    }

    private String getNewChunkName(String segmentName, long offset) {
        return NameUtils.getSegmentChunkName((String)segmentName, (long)this.chunkedSegmentStorage.getEpoch(), (long)offset);
    }

    private ChunkMetadata updateMetadataForChunkAddition(MetadataTransaction txn, SegmentMetadata segmentMetadata, String newChunkName, boolean isFirstWriteAfterFailover, ChunkMetadata lastChunkMetadata) {
        ChunkMetadata newChunkMetadata = ChunkMetadata.builder().name(newChunkName).build();
        newChunkMetadata.setActive(true);
        segmentMetadata.setLastChunk(newChunkName);
        if (lastChunkMetadata == null) {
            segmentMetadata.setFirstChunk(newChunkName);
        } else {
            lastChunkMetadata.setNextChunk(newChunkName);
            txn.update(lastChunkMetadata);
        }
        segmentMetadata.setLastChunkStartOffset(segmentMetadata.getLength());
        if (isFirstWriteAfterFailover) {
            segmentMetadata.setOwnerEpoch(this.chunkedSegmentStorage.getEpoch());
            segmentMetadata.setOwnershipChanged(false);
            log.debug("{} write - First write after failover - op={}, segment={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), segmentMetadata.getName()});
        }
        segmentMetadata.setChunkCount(segmentMetadata.getChunkCount() + 1);
        txn.create(newChunkMetadata);
        txn.update(segmentMetadata);
        return newChunkMetadata;
    }

    private void addSystemLogRecord(List<SystemJournal.SystemJournalRecord> systemLogRecords, String streamSegmentName, long offset, String oldChunkName, String newChunkName) {
        systemLogRecords.add(SystemJournal.ChunkAddedRecord.builder().segmentName(streamSegmentName).offset(offset).oldChunkName(oldChunkName).newChunkName(newChunkName).build());
    }

    private CompletableFuture<Void> writeToChunk(MetadataTransaction txn, SegmentMetadata segmentMetadata, InputStream data, ChunkHandle chunkHandle, ChunkMetadata chunkWrittenMetadata, long offsetToWriteAt, int bytesCount) {
        Preconditions.checkState((0 != bytesCount ? 1 : 0) != 0, (String)"Attempt to write zero bytes. Segment=%s Chunk=%s offsetToWriteAt=%s", (Object)segmentMetadata, (Object)chunkWrittenMetadata, (Object)offsetToWriteAt);
        BoundedInputStream bis = new BoundedInputStream(data, bytesCount);
        CompletionStage<Integer> retValue = this.chunkedSegmentStorage.shouldAppend() ? this.chunkedSegmentStorage.getChunkStorage().write(chunkHandle, offsetToWriteAt, bytesCount, (InputStream)bis) : this.chunkedSegmentStorage.getChunkStorage().createWithContent(chunkHandle.getChunkName(), bytesCount, (InputStream)bis).thenApplyAsync(h -> bytesCount, this.chunkedSegmentStorage.getExecutor());
        return ((CompletableFuture)retValue.thenAcceptAsync(bytesWritten -> {
            Preconditions.checkState((bytesWritten >= 0 ? 1 : 0) != 0, (String)"bytesWritten (%s) must be non-negative. Segment=%s Chunk=%s offsetToWriteAt=%s", (Object)bytesWritten, (Object)segmentMetadata, (Object)chunkWrittenMetadata, (Object)offsetToWriteAt);
            segmentMetadata.setLength(segmentMetadata.getLength() + (long)bytesWritten.intValue());
            chunkWrittenMetadata.setLength(chunkWrittenMetadata.getLength() + (long)bytesWritten.intValue());
            txn.update(chunkWrittenMetadata);
            txn.update(segmentMetadata);
            this.bytesRemaining.addAndGet(-bytesWritten.intValue());
            this.currentOffset.addAndGet(bytesWritten.intValue());
        }, this.chunkedSegmentStorage.getExecutor())).handleAsync((v, e) -> {
            if (null != e) {
                Throwable ex = Exceptions.unwrap((Throwable)e);
                if (ex instanceof InvalidOffsetException) {
                    InvalidOffsetException invalidEx = (InvalidOffsetException)ex;
                    if (invalidEx.getExpectedOffset() > offsetToWriteAt) {
                        this.skipOverFailedChunk = true;
                        log.debug("{} write - skipping partially written chunk op={}, segment={}, chunk={} expected={} given={}.", new Object[]{this.chunkedSegmentStorage.getLogPrefix(), System.identityHashCode(this), this.handle.getSegmentName(), chunkHandle.getChunkName(), invalidEx.getExpectedOffset(), invalidEx.getGivenOffset()});
                        return null;
                    }
                    throw new CompletionException((Throwable)new BadOffsetException(segmentMetadata.getName(), this.currentOffset.get() + ((InvalidOffsetException)ex).getExpectedOffset(), this.currentOffset.get() + ((InvalidOffsetException)ex).getGivenOffset()));
                }
                throw new CompletionException(ex);
            }
            return v;
        }, this.chunkedSegmentStorage.getExecutor());
    }
}

