/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ConcurrentHashMultiset;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.metadata.MetadataTransaction;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import io.pravega.segmentstore.storage.metadata.StorageMetadataException;
import io.pravega.segmentstore.storage.metadata.StorageMetadataMetrics;
import io.pravega.segmentstore.storage.metadata.StorageMetadataVersionMismatchException;
import io.pravega.segmentstore.storage.metadata.StorageMetadataWritesFencedOutException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class BaseMetadataStore
implements ChunkMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseMetadataStore.class);
    private static final int CACHE_EVICTION_RATIO = 10;
    private final AtomicBoolean fenced;
    private final AtomicLong version;
    private final ConcurrentHashMap<String, TransactionData> bufferedTxnData;
    private final ConcurrentHashMap<Long, MetadataTransaction> activeTxns;
    private final ConcurrentHashMultiset<String> activeKeys;
    @GuardedBy(value="lockedKeys")
    private final HashSet<String> lockedKeys = new HashSet();
    private final Cache<String, TransactionData> cache;
    private final Executor executor;
    private int maxEntriesInTxnBuffer;
    private int maxEntriesInCache;
    private final AtomicInteger bufferCount = new AtomicInteger(0);
    private final AtomicBoolean isEvictionRunning = new AtomicBoolean();
    private final Object evictionLock = new Object();
    private final ChunkedSegmentStorageConfig config;

    public BaseMetadataStore(ChunkedSegmentStorageConfig config, Executor executor) {
        this.config = (ChunkedSegmentStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.version = new AtomicLong(System.currentTimeMillis());
        this.fenced = new AtomicBoolean(false);
        this.bufferedTxnData = new ConcurrentHashMap();
        this.activeTxns = new ConcurrentHashMap();
        this.activeKeys = ConcurrentHashMultiset.create();
        this.maxEntriesInTxnBuffer = config.getMaxEntriesInTxnBuffer();
        this.maxEntriesInCache = config.getMaxEntriesInCache();
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.maxEntriesInCache).build();
    }

    @Override
    public MetadataTransaction beginTransaction(boolean isReadonly, String ... keysToLock) {
        MetadataTransaction txn = new MetadataTransaction(this, isReadonly, this.version.incrementAndGet(), keysToLock);
        this.activeTxns.put(txn.getVersion(), txn);
        return txn;
    }

    @Override
    public void closeTransaction(MetadataTransaction txn) {
        this.activeTxns.remove(txn.getVersion());
    }

    @Override
    public boolean isTransactionActive(long txnId) {
        return this.activeTxns.containsKey(txnId);
    }

    @Override
    public CompletableFuture<Void> commit(MetadataTransaction txn, boolean lazyWrite) {
        return this.commit(txn, lazyWrite, false);
    }

    @Override
    public CompletableFuture<Void> commit(MetadataTransaction txn) {
        return this.commit(txn, false, false);
    }

    @Override
    public CompletableFuture<Void> commit(MetadataTransaction txn, boolean lazyWrite, boolean skipStoreCheck) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null");
        Preconditions.checkState((!txn.isReadonly() ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        ArrayList modifiedKeys = new ArrayList();
        ArrayList modifiedValues = new ArrayList();
        Timer t = new Timer();
        AtomicBoolean shouldReleaseKeys = new AtomicBoolean(false);
        CompletionStage retValue = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> {
            if (this.fenced.get()) {
                throw new CompletionException(new StorageMetadataWritesFencedOutException(String.format("Transaction writer is fenced off. transaction=%s", txn.getVersion())));
            }
        }, this.executor).thenComposeAsync(v -> {
            ((ConcurrentHashMap.KeySetView)txn.getData().keySet()).forEach(this::addToActiveKeySet);
            this.acquireKeys(txn);
            shouldReleaseKeys.set(true);
            return this.loadMissingKeys(txn, skipStoreCheck, txnData).thenComposeAsync(v1 -> this.performCommit(txn, lazyWrite, txnData, modifiedKeys, modifiedValues), this.executor);
        }, this.executor)).thenRunAsync(() -> txn.setCommitted(), this.executor)).whenCompleteAsync((v, ex) -> {
            if (shouldReleaseKeys.get()) {
                this.releaseKeys(txn);
            }
            ((ConcurrentHashMap.KeySetView)txn.getData().keySet()).forEach(this::removeFromActiveKeySet);
            if (txn.isCommitted()) {
                txnData.clear();
            }
            StorageMetadataMetrics.COMMIT_LATENCY.reportSuccessEvent(t.getElapsed());
        }, this.executor);
        ((CompletableFuture)retValue).thenAcceptAsync(v4 -> this.evictIfNeeded(), this.executor);
        return retValue;
    }

    private CompletableFuture<Void> loadMissingKeys(MetadataTransaction txn, boolean skipStoreCheck, Map<String, TransactionData> txnData) {
        ArrayList<CompletableFuture<TransactionData>> loadFutures = new ArrayList<CompletableFuture<TransactionData>>();
        for (Map.Entry<String, TransactionData> entry : txnData.entrySet()) {
            Preconditions.checkState((boolean)this.activeKeys.contains((Object)entry.getKey()), (String)"key must be marked active. key=%s", (Object)entry.getKey());
            String key = entry.getKey();
            if (skipStoreCheck || entry.getValue().isPinned()) {
                log.trace("Skipping loading key from the store key = {}", (Object)key);
                continue;
            }
            TransactionData dataFromBuffer = this.bufferedTxnData.get(key);
            if (null != dataFromBuffer) continue;
            loadFutures.add(this.loadFromStore(key));
        }
        return Futures.allOf(loadFutures).thenRunAsync(() -> {
            for (Map.Entry entry : txnData.entrySet()) {
                TransactionData dataFromBuffer = this.bufferedTxnData.get(entry.getKey());
                if (((TransactionData)entry.getValue()).isPinned()) continue;
                Preconditions.checkState((boolean)this.activeKeys.contains(entry.getKey()), (String)"key must be marked active. key=%s", entry.getKey());
                Preconditions.checkState((null != dataFromBuffer ? 1 : 0) != 0, (Object)"Data from buffer must not be null.");
                if (dataFromBuffer.isPinned()) continue;
                Preconditions.checkState((null != dataFromBuffer.getDbObject() ? 1 : 0) != 0, (Object)"Missing tracking object");
            }
        }, this.executor);
    }

    private CompletableFuture<Void> performCommit(MetadataTransaction txn, boolean lazyWrite, Map<String, TransactionData> txnData, ArrayList<String> modifiedKeys, ArrayList<TransactionData> modifiedValues) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.validateCommit(txn, txnData, modifiedKeys, modifiedValues), this.executor).thenComposeAsync(v -> this.writeToMetadataStore(lazyWrite, modifiedValues), this.executor)).thenComposeAsync(v -> this.executeExternalCommitAction(txn), this.executor)).thenRunAsync(() -> {
            long committedVersion = this.version.incrementAndGet();
            HashMap<String, TransactionData> toAdd = new HashMap<String, TransactionData>();
            int delta = 0;
            for (String key : modifiedKeys) {
                TransactionData data = this.getDeepCopy((TransactionData)txnData.get(key));
                data.setVersion(committedVersion);
                toAdd.put(key, data);
                if (data.isCreated()) {
                    ++delta;
                }
                if (!data.isDeleted()) continue;
                --delta;
            }
            this.bufferedTxnData.putAll(toAdd);
            this.bufferCount.addAndGet(delta);
        }, this.executor);
    }

    private CompletableFuture<Void> writeToMetadataStore(boolean lazyWrite, ArrayList<TransactionData> modifiedValues) {
        if (!lazyWrite || this.bufferCount.get() > this.maxEntriesInTxnBuffer) {
            log.trace("Persisting all modified keys (except pinned)");
            List<TransactionData> toWriteList = modifiedValues.stream().filter(entry -> !entry.isPinned()).collect(Collectors.toList());
            if (toWriteList.size() > 0) {
                return this.writeAll(toWriteList).thenRunAsync(() -> {
                    log.trace("Done persisting all modified keys");
                    for (TransactionData writtenData : toWriteList) {
                        writtenData.setPersisted(true);
                        this.cache.put((Object)writtenData.getKey(), (Object)writtenData);
                    }
                }, this.executor);
            }
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> executeExternalCommitAction(MetadataTransaction txn) {
        try {
            if (null != txn.getExternalCommitStep()) {
                return txn.getExternalCommitStep().call();
            }
        }
        catch (Exception e) {
            log.error("Exception during execution of external commit step", (Throwable)e);
            throw new CompletionException(new StorageMetadataException("Exception during execution of external commit step", e));
        }
        return CompletableFuture.completedFuture(null);
    }

    private void validateCommit(MetadataTransaction txn, Map<String, TransactionData> txnData, ArrayList<String> modifiedKeys, ArrayList<TransactionData> modifiedValues) {
        for (Map.Entry<String, TransactionData> entry : txnData.entrySet()) {
            TransactionData dataFromBuffer;
            String key = entry.getKey();
            TransactionData transactionData = entry.getValue();
            Preconditions.checkState((null != transactionData.getKey() ? 1 : 0) != 0, (Object)"Missing key.");
            if (transactionData.getVersion() == txn.getVersion()) {
                modifiedKeys.add(key);
                transactionData.setPersisted(false);
                modifiedValues.add(transactionData);
            }
            if (null != (dataFromBuffer = this.bufferedTxnData.get(key))) {
                if (!dataFromBuffer.isPinned()) {
                    Preconditions.checkState((null != dataFromBuffer.getDbObject() ? 1 : 0) != 0, (Object)"Missing tracking object");
                }
                if (dataFromBuffer.getVersion() > transactionData.getVersion()) {
                    throw new CompletionException(new StorageMetadataVersionMismatchException(String.format("Transaction uses stale data. Key version changed key=%s committed=%s transaction=%s", key, dataFromBuffer.getVersion(), txnData.get(key).getVersion())));
                }
                transactionData.setPinned(transactionData.isPinned() || dataFromBuffer.isPinned());
                transactionData.setDbObject(dataFromBuffer.getDbObject());
                continue;
            }
            Preconditions.checkState((boolean)entry.getValue().isPinned(), (String)"Transaction data evicted unexpectedly. Key=%s", (Object)entry.getKey());
        }
    }

    private void evictIfNeeded() {
        if (this.isEvictionRunning.compareAndSet(false, true)) {
            try {
                int limit = 1 + this.maxEntriesInTxnBuffer / 10;
                if (this.bufferCount.get() > this.maxEntriesInTxnBuffer) {
                    List<String> toEvict = this.bufferedTxnData.entrySet().parallelStream().filter(entry -> ((TransactionData)entry.getValue()).isPersisted() && !((TransactionData)entry.getValue()).isPinned() && !this.activeKeys.contains(entry.getKey())).map(Map.Entry::getKey).limit(limit).collect(Collectors.toList());
                    this.evictFromBuffer(toEvict);
                }
            }
            finally {
                this.isEvictionRunning.set(false);
            }
        }
    }

    public void evictFromCache() {
        this.cache.invalidateAll();
    }

    public void evictAllEligibleEntriesFromBuffer() {
        try {
            this.isEvictionRunning.set(true);
            List<String> toEvict = this.bufferedTxnData.entrySet().parallelStream().filter(entry -> ((TransactionData)entry.getValue()).isPersisted() && !((TransactionData)entry.getValue()).isPinned() && !this.activeKeys.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
            this.evictFromBuffer(toEvict);
        }
        finally {
            this.isEvictionRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictFromBuffer(List<String> keysToEvict) {
        int count = 0;
        for (String key : keysToEvict) {
            Object object = this.evictionLock;
            synchronized (object) {
                if (0 == this.activeKeys.count((Object)key)) {
                    this.cache.put((Object)key, (Object)this.bufferedTxnData.get(key));
                    this.bufferedTxnData.remove(key);
                    ++count;
                }
            }
        }
        this.bufferCount.addAndGet(-1 * count);
        StorageMetadataMetrics.METADATA_BUFFER_EVICTED_COUNT.add((long)count);
        log.debug("{} entries evicted from transaction buffer.", (Object)count);
    }

    @Override
    public CompletableFuture<Void> abort(MetadataTransaction txn) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<StorageMetadata> get(MetadataTransaction txn, String key) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null");
        if (null == key) {
            return CompletableFuture.completedFuture(null);
        }
        Timer t = new Timer();
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        TransactionData data = txnData.get(key);
        if (null != data) {
            StorageMetadataMetrics.GET_LATENCY.reportSuccessEvent(t.getElapsed());
            StorageMetadataMetrics.METADATA_FOUND_IN_TXN.inc();
            return CompletableFuture.completedFuture(data.getValue());
        }
        this.addToActiveKeySet(key);
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.bufferedTxnData.get(key), this.executor).thenApplyAsync(dataFromBuffer -> {
            if (dataFromBuffer != null) {
                StorageMetadataMetrics.METADATA_FOUND_IN_BUFFER.inc();
                return this.copyToTransaction(txn, key, (TransactionData)dataFromBuffer);
            }
            return null;
        }, this.executor)).thenComposeAsync(retValue -> {
            if (retValue != null) {
                return CompletableFuture.completedFuture(retValue);
            }
            return this.loadFromStore(key).thenApplyAsync(dataFromStore -> this.copyToTransaction(txn, key, (TransactionData)dataFromStore), this.executor);
        }, this.executor)).whenCompleteAsync((v, ex) -> {
            this.removeFromActiveKeySet(key);
            StorageMetadataMetrics.GET_LATENCY.reportSuccessEvent(t.getElapsed());
        }, this.executor);
    }

    private StorageMetadata copyToTransaction(MetadataTransaction txn, String key, TransactionData transactionData) {
        TransactionData txnLocalCopy = this.getDeepCopy(transactionData);
        txn.getData().put(key, txnLocalCopy);
        return txnLocalCopy.getValue();
    }

    private TransactionData getDeepCopy(TransactionData transactionData) {
        TransactionData copy = transactionData.toBuilder().build();
        if (null != transactionData.getValue()) {
            copy.setValue(transactionData.getValue().deepCopy());
        }
        return copy;
    }

    private void removeFromActiveKeySet(String key) {
        this.activeKeys.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToActiveKeySet(String key) {
        if (this.isEvictionRunning.get()) {
            Object object = this.evictionLock;
            synchronized (object) {
                this.activeKeys.add((Object)key);
            }
        } else {
            this.activeKeys.add((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireKeys(MetadataTransaction txn) {
        HashSet<String> hashSet = this.lockedKeys;
        synchronized (hashSet) {
            for (String key : txn.getKeysToLock()) {
                if (!this.lockedKeys.contains(key)) continue;
                throw new CompletionException(new StorageMetadataVersionMismatchException(String.format("Concurrent transaction commits not allowed. key=%s transaction=%s", key, txn.getVersion())));
            }
            for (String key : txn.getKeysToLock()) {
                this.lockedKeys.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseKeys(MetadataTransaction txn) {
        HashSet<String> hashSet = this.lockedKeys;
        synchronized (hashSet) {
            for (String key : txn.getKeysToLock()) {
                this.lockedKeys.remove(key);
            }
        }
    }

    private CompletableFuture<TransactionData> loadFromStore(String key) {
        log.trace("Loading key from the store key = {}", (Object)key);
        return this.readFromStore(key).thenApplyAsync(copyFromStore -> {
            Preconditions.checkState((null != copyFromStore ? 1 : 0) != 0, (String)"Data from table store must not be null. key=%s", (Object)key);
            Preconditions.checkState((null != copyFromStore.dbObject ? 1 : 0) != 0, (String)"Missing tracking object. key=%s", (Object)key);
            log.trace("Done Loading key from the store key = {}", (Object)copyFromStore.getKey());
            if (null != copyFromStore.getValue()) {
                Preconditions.checkState((0L != copyFromStore.getVersion() ? 1 : 0) != 0, (String)"Version is not initialized. key=%s", (Object)key);
            }
            return this.insertInBuffer(key, (TransactionData)copyFromStore);
        }, this.executor);
    }

    private CompletableFuture<TransactionData> readFromStore(String key) {
        TransactionData fromCache = (TransactionData)this.cache.getIfPresent((Object)key);
        if (null != fromCache) {
            StorageMetadataMetrics.METADATA_FOUND_IN_CACHE.inc();
            return CompletableFuture.completedFuture(fromCache);
        }
        return this.read(key);
    }

    private TransactionData insertInBuffer(String key, TransactionData copyForBuffer) {
        TransactionData retValue;
        TransactionData oldValue = this.bufferedTxnData.putIfAbsent(key, copyForBuffer);
        if (oldValue != null) {
            retValue = oldValue;
        } else {
            retValue = copyForBuffer;
            this.bufferCount.incrementAndGet();
        }
        Preconditions.checkState((boolean)this.activeKeys.contains((Object)key), (String)"key must be marked active. Key=%s", (Object)key);
        Preconditions.checkState((boolean)this.bufferedTxnData.containsKey(key), (String)"bufferedTxnData must contain the key. Key=%s", (Object)key);
        if (!retValue.isPinned()) {
            Preconditions.checkState((null != retValue.dbObject ? 1 : 0) != 0, (Object)"Missing tracking object");
        }
        return retValue;
    }

    @VisibleForTesting
    long getBufferCount() {
        return this.bufferCount.get();
    }

    protected abstract CompletableFuture<TransactionData> read(String var1);

    protected abstract CompletableFuture<Void> writeAll(Collection<TransactionData> var1);

    @Override
    public void update(MetadataTransaction txn, StorageMetadata metadata) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn should not be null.");
        Preconditions.checkArgument((null != metadata ? 1 : 0) != 0, (Object)"metadata should not be null.");
        Preconditions.checkArgument((null != metadata.getKey() ? 1 : 0) != 0, (Object)"metadata.key should not be null.");
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        String key = metadata.getKey();
        TransactionData data = TransactionData.builder().key(key).build();
        TransactionData oldData = txnData.putIfAbsent(key, data);
        if (null != oldData) {
            data = oldData;
        }
        data.setValue(metadata);
        data.setPersisted(false);
        Preconditions.checkState((txn.getVersion() >= data.getVersion() ? 1 : 0) != 0);
        data.setVersion(txn.getVersion());
    }

    @Override
    public void markPinned(MetadataTransaction txn, StorageMetadata metadata) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null.");
        Preconditions.checkArgument((null != metadata ? 1 : 0) != 0, (Object)"metadata must not be null.");
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        String key = metadata.getKey();
        TransactionData data = TransactionData.builder().key(key).build();
        TransactionData oldData = txnData.putIfAbsent(key, data);
        if (null != oldData) {
            data = oldData;
        }
        data.setValue(metadata);
        data.setPinned(true);
        data.setVersion(txn.getVersion());
    }

    @Override
    public void create(MetadataTransaction txn, StorageMetadata metadata) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null.");
        Preconditions.checkArgument((null != metadata ? 1 : 0) != 0, (Object)"metadata must not be null.");
        Preconditions.checkArgument((null != metadata.getKey() ? 1 : 0) != 0, (Object)"metadata.key must not be null.");
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        txnData.put(metadata.getKey(), TransactionData.builder().key(metadata.getKey()).value(metadata).version(txn.getVersion()).created(true).build());
    }

    @Override
    public void delete(MetadataTransaction txn, String key) {
        Preconditions.checkArgument((null != txn ? 1 : 0) != 0, (Object)"txn must not be null.");
        Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"key must not be null.");
        ConcurrentHashMap<String, TransactionData> txnData = txn.getData();
        TransactionData data = TransactionData.builder().key(key).build();
        TransactionData oldData = txnData.putIfAbsent(key, data);
        if (null != oldData) {
            data = oldData;
        }
        data.setValue(null);
        data.setPersisted(false);
        data.setDeleted(true);
        data.setVersion(txn.getVersion());
    }

    @Override
    public void report() {
        StorageMetadataMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.metadata_buffer_record_count", (Number)this.bufferCount, new String[0]);
        StorageMetadataMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.metadata_cache_record_count", (Number)this.cache.size(), new String[0]);
        StorageMetadataMetrics.DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.storage.metadata_cache_miss_rate", (Number)this.cache.stats().missRate(), new String[0]);
    }

    @Override
    public void close() {
        ArrayList<TransactionData> modifiedValues = new ArrayList<TransactionData>();
        this.bufferedTxnData.entrySet().stream().filter(entry -> !((TransactionData)entry.getValue()).isPersisted() && !((TransactionData)entry.getValue()).isPinned()).forEach(entry -> modifiedValues.add((TransactionData)entry.getValue()));
        if (modifiedValues.size() > 0) {
            this.writeAll(modifiedValues);
        }
    }

    @Override
    public void markFenced() {
        this.fenced.set(true);
    }

    protected long getVersion() {
        return this.version.get();
    }

    protected void setVersion(long version) {
        this.version.set(version);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected Executor getExecutor() {
        return this.executor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxEntriesInTxnBuffer() {
        return this.maxEntriesInTxnBuffer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxEntriesInTxnBuffer(int maxEntriesInTxnBuffer) {
        this.maxEntriesInTxnBuffer = maxEntriesInTxnBuffer;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxEntriesInCache() {
        return this.maxEntriesInCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxEntriesInCache(int maxEntriesInCache) {
        this.maxEntriesInCache = maxEntriesInCache;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig getConfig() {
        return this.config;
    }

    public static class TransactionData
    implements Serializable {
        private static final StorageMetadata.StorageMetadataSerializer SERIALIZER = new StorageMetadata.StorageMetadataSerializer();
        private volatile long version;
        private volatile Object dbObject;
        private volatile boolean persisted;
        private volatile boolean pinned;
        private volatile boolean created;
        private volatile boolean deleted;
        private volatile String key;
        private volatile StorageMetadata value;

        @ConstructorProperties(value={"version", "dbObject", "persisted", "pinned", "created", "deleted", "key", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        TransactionData(long version, Object dbObject, boolean persisted, boolean pinned, boolean created, boolean deleted, String key, StorageMetadata value) {
            this.version = version;
            this.dbObject = dbObject;
            this.persisted = persisted;
            this.pinned = pinned;
            this.created = created;
            this.deleted = deleted;
            this.key = key;
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static TransactionDataBuilder builder() {
            return new TransactionDataBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TransactionDataBuilder toBuilder() {
            return new TransactionDataBuilder().version(this.version).dbObject(this.dbObject).persisted(this.persisted).pinned(this.pinned).created(this.created).deleted(this.deleted).key(this.key).value(this.value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getDbObject() {
            return this.dbObject;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isPersisted() {
            return this.persisted;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isPinned() {
            return this.pinned;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isCreated() {
            return this.created;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isDeleted() {
            return this.deleted;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StorageMetadata getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setVersion(long version) {
            this.version = version;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setDbObject(Object dbObject) {
            this.dbObject = dbObject;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setPersisted(boolean persisted) {
            this.persisted = persisted;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setPinned(boolean pinned) {
            this.pinned = pinned;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setCreated(boolean created) {
            this.created = created;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setValue(StorageMetadata value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionData)) {
                return false;
            }
            TransactionData other = (TransactionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            Object this$dbObject = this.getDbObject();
            Object other$dbObject = other.getDbObject();
            if (this$dbObject == null ? other$dbObject != null : !this$dbObject.equals(other$dbObject)) {
                return false;
            }
            if (this.isPersisted() != other.isPersisted()) {
                return false;
            }
            if (this.isPinned() != other.isPinned()) {
                return false;
            }
            if (this.isCreated() != other.isCreated()) {
                return false;
            }
            if (this.isDeleted() != other.isDeleted()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            StorageMetadata this$value = this.getValue();
            StorageMetadata other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransactionData;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            Object $dbObject = this.getDbObject();
            result = result * 59 + ($dbObject == null ? 43 : $dbObject.hashCode());
            result = result * 59 + (this.isPersisted() ? 79 : 97);
            result = result * 59 + (this.isPinned() ? 79 : 97);
            result = result * 59 + (this.isCreated() ? 79 : 97);
            result = result * 59 + (this.isDeleted() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            StorageMetadata $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "BaseMetadataStore.TransactionData(version=" + this.getVersion() + ", dbObject=" + this.getDbObject() + ", persisted=" + this.isPersisted() + ", pinned=" + this.isPinned() + ", created=" + this.isCreated() + ", deleted=" + this.isDeleted() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }

        public static class TransactionDataSerializer
        extends VersionedSerializer.WithBuilder<TransactionData, TransactionDataBuilder> {
            protected TransactionDataBuilder newBuilder() {
                return TransactionData.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput input, TransactionDataBuilder b) throws IOException {
                b.version(input.readLong());
                b.key(input.readUTF());
                boolean hasValue = input.readBoolean();
                if (hasValue) {
                    b.value((StorageMetadata)SERIALIZER.deserialize(input.getBaseStream()));
                }
            }

            private void write00(TransactionData object, RevisionDataOutput output) throws IOException {
                output.writeLong(object.version);
                output.writeUTF(object.key);
                boolean hasValue = object.value != null;
                output.writeBoolean(hasValue);
                if (hasValue) {
                    SERIALIZER.serialize(output, object.value);
                }
            }
        }

        public static class TransactionDataBuilder
        implements ObjectBuilder<TransactionData> {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long version;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Object dbObject;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean persisted;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean pinned;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean created;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean deleted;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String key;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private StorageMetadata value;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            TransactionDataBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder version(long version) {
                this.version = version;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder dbObject(Object dbObject) {
                this.dbObject = dbObject;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder persisted(boolean persisted) {
                this.persisted = persisted;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder pinned(boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder created(boolean created) {
                this.created = created;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder deleted(boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder key(String key) {
                this.key = key;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionDataBuilder value(StorageMetadata value) {
                this.value = value;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TransactionData build() {
                return new TransactionData(this.version, this.dbObject, this.persisted, this.pinned, this.created, this.deleted, this.key, this.value);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "BaseMetadataStore.TransactionData.TransactionDataBuilder(version=" + this.version + ", dbObject=" + this.dbObject + ", persisted=" + this.persisted + ", pinned=" + this.pinned + ", created=" + this.created + ", deleted=" + this.deleted + ", key=" + this.key + ", value=" + this.value + ")";
            }
        }
    }
}

