/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public class ChunkMetadata
extends StorageMetadata {
    private final String name;
    private volatile long length;
    private volatile String nextChunk;
    private volatile int status;

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public StorageMetadata deepCopy() {
        return this.toBuilder().build();
    }

    private ChunkMetadata setFlag(int mask, boolean value) {
        this.status = value ? this.status | mask : this.status & ~mask;
        return this;
    }

    private boolean getFlag(int mask) {
        return (this.status & mask) != 0;
    }

    public ChunkMetadata setActive(boolean value) {
        return this.setFlag(1, value);
    }

    public boolean isActive() {
        return this.getFlag(1);
    }

    @ConstructorProperties(value={"name", "length", "nextChunk", "status"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ChunkMetadata(String name, long length, String nextChunk, int status) {
        this.name = name;
        this.length = length;
        this.nextChunk = nextChunk;
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ChunkMetadataBuilder builder() {
        return new ChunkMetadataBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkMetadataBuilder toBuilder() {
        return new ChunkMetadataBuilder().name(this.name).length(this.length).nextChunk(this.nextChunk).status(this.status);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLength() {
        return this.length;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNextChunk() {
        return this.nextChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLength(long length) {
        this.length = length;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setNextChunk(String nextChunk) {
        this.nextChunk = nextChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ChunkMetadata(name=" + this.getName() + ", length=" + this.getLength() + ", nextChunk=" + this.getNextChunk() + ", status=" + this.getStatus() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkMetadata)) {
            return false;
        }
        ChunkMetadata other = (ChunkMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$nextChunk = this.getNextChunk();
        String other$nextChunk = other.getNextChunk();
        if (this$nextChunk == null ? other$nextChunk != null : !this$nextChunk.equals(other$nextChunk)) {
            return false;
        }
        return this.getStatus() == other.getStatus();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChunkMetadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        String $nextChunk = this.getNextChunk();
        result = result * 59 + ($nextChunk == null ? 43 : $nextChunk.hashCode());
        result = result * 59 + this.getStatus();
        return result;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<ChunkMetadata, ChunkMetadataBuilder> {
        protected ChunkMetadataBuilder newBuilder() {
            return ChunkMetadata.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ChunkMetadata object, RevisionDataOutput output) throws IOException {
            output.writeUTF(object.name);
            output.writeCompactLong(object.length);
            output.writeUTF(Strings.nullToEmpty((String)object.nextChunk));
            output.writeCompactInt(object.status);
        }

        private void read00(RevisionDataInput input, ChunkMetadataBuilder b) throws IOException {
            b.name(input.readUTF());
            b.length(input.readCompactLong());
            b.nextChunk(Strings.emptyToNull((String)input.readUTF()));
            b.status(input.readCompactInt());
        }
    }

    public static class ChunkMetadataBuilder
    implements ObjectBuilder<ChunkMetadata> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long length;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String nextChunk;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int status;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ChunkMetadataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkMetadataBuilder length(long length) {
            this.length = length;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkMetadataBuilder nextChunk(String nextChunk) {
            this.nextChunk = nextChunk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkMetadataBuilder status(int status) {
            this.status = status;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ChunkMetadata build() {
            return new ChunkMetadata(this.name, this.length, this.nextChunk, this.status);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ChunkMetadata.ChunkMetadataBuilder(name=" + this.name + ", length=" + this.length + ", nextChunk=" + this.nextChunk + ", status=" + this.status + ")";
        }
    }
}

