/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.metadata.BaseMetadataStore;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
public class MetadataTransaction
implements AutoCloseable {
    private final ChunkMetadataStore store;
    private boolean isCommitted = false;
    private boolean isAborted = false;
    private final long version;
    private final boolean isReadonly;
    private final ConcurrentHashMap<String, BaseMetadataStore.TransactionData> data;
    private Callable<CompletableFuture<Void>> externalCommitStep;
    private final String[] keysToLock;

    public MetadataTransaction(ChunkMetadataStore store, boolean isReadonly, long version, String ... keysToLock) {
        this.store = (ChunkMetadataStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.version = version;
        this.keysToLock = (String[])Preconditions.checkNotNull((Object)keysToLock, (Object)"keys");
        this.isReadonly = isReadonly;
        Preconditions.checkArgument((keysToLock.length > 0 ? 1 : 0) != 0, (Object)"At least one key must be locked.");
        this.data = new ConcurrentHashMap();
    }

    public CompletableFuture<StorageMetadata> get(String key) {
        return this.store.get(this, key);
    }

    public void update(StorageMetadata metadata) {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        this.store.update(this, metadata);
    }

    public void create(StorageMetadata metadata) {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        this.store.create(this, metadata);
    }

    public void markPinned(StorageMetadata metadata) {
        this.store.markPinned(this, metadata);
    }

    public void delete(String key) {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        this.store.delete(this, key);
    }

    public CompletableFuture<Void> commit() {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        Preconditions.checkState((!this.isCommitted ? 1 : 0) != 0, (Object)"Transaction is already committed");
        Preconditions.checkState((!this.isAborted ? 1 : 0) != 0, (Object)"Transaction is already aborted");
        return this.store.commit(this);
    }

    public CompletableFuture<Void> commit(boolean lazyWrite) {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        Preconditions.checkState((!this.isCommitted ? 1 : 0) != 0, (Object)"Transaction is already committed");
        Preconditions.checkState((!this.isAborted ? 1 : 0) != 0, (Object)"Transaction is already aborted");
        return this.store.commit(this, lazyWrite);
    }

    public CompletableFuture<Void> commit(boolean lazyWrite, boolean skipStoreCheck) {
        Preconditions.checkState((!this.isReadonly ? 1 : 0) != 0, (Object)"Attempt to modify in readonly transaction");
        Preconditions.checkState((!this.isCommitted ? 1 : 0) != 0, (Object)"Transaction is already committed");
        Preconditions.checkState((!this.isAborted ? 1 : 0) != 0, (Object)"Transaction is already aborted");
        return this.store.commit(this, lazyWrite, skipStoreCheck);
    }

    public void setCommitted() {
        this.isCommitted = true;
    }

    public CompletableFuture<Void> abort() {
        Preconditions.checkState((!this.isCommitted ? 1 : 0) != 0, (Object)"Transaction is already committed");
        Preconditions.checkState((!this.isAborted ? 1 : 0) != 0, (Object)"Transaction is already aborted");
        this.isAborted = true;
        return this.store.abort(this);
    }

    @Override
    public void close() {
        if (!this.isCommitted || this.isAborted) {
            this.store.abort(this);
        }
        this.store.closeTransaction(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAborted() {
        return this.isAborted;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getVersion() {
        return this.version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isReadonly() {
        return this.isReadonly;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConcurrentHashMap<String, BaseMetadataStore.TransactionData> getData() {
        return this.data;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Callable<CompletableFuture<Void>> getExternalCommitStep() {
        return this.externalCommitStep;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExternalCommitStep(Callable<CompletableFuture<Void>> externalCommitStep) {
        this.externalCommitStep = externalCommitStep;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getKeysToLock() {
        return this.keysToLock;
    }
}

