/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;

public class ReadIndexBlockMetadata
extends StorageMetadata {
    private final String name;
    private final String chunkName;
    private final long startOffset;
    private volatile int status;

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public StorageMetadata deepCopy() {
        return this.toBuilder().build();
    }

    private ReadIndexBlockMetadata setFlag(int mask, boolean value) {
        this.status = value ? this.status | mask : this.status & ~mask;
        return this;
    }

    private boolean getFlag(int mask) {
        return (this.status & mask) != 0;
    }

    public ReadIndexBlockMetadata setActive(boolean value) {
        return this.setFlag(1, value);
    }

    public boolean isActive() {
        return this.getFlag(1);
    }

    @ConstructorProperties(value={"name", "chunkName", "startOffset", "status"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ReadIndexBlockMetadata(String name, String chunkName, long startOffset, int status) {
        this.name = name;
        this.chunkName = chunkName;
        this.startOffset = startOffset;
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ReadIndexBlockMetadataBuilder builder() {
        return new ReadIndexBlockMetadataBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReadIndexBlockMetadataBuilder toBuilder() {
        return new ReadIndexBlockMetadataBuilder().name(this.name).chunkName(this.chunkName).startOffset(this.startOffset).status(this.status);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getChunkName() {
        return this.chunkName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartOffset() {
        return this.startOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ReadIndexBlockMetadata(name=" + this.getName() + ", chunkName=" + this.getChunkName() + ", startOffset=" + this.getStartOffset() + ", status=" + this.getStatus() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadIndexBlockMetadata)) {
            return false;
        }
        ReadIndexBlockMetadata other = (ReadIndexBlockMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$chunkName = this.getChunkName();
        String other$chunkName = other.getChunkName();
        if (this$chunkName == null ? other$chunkName != null : !this$chunkName.equals(other$chunkName)) {
            return false;
        }
        if (this.getStartOffset() != other.getStartOffset()) {
            return false;
        }
        return this.getStatus() == other.getStatus();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReadIndexBlockMetadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $chunkName = this.getChunkName();
        result = result * 59 + ($chunkName == null ? 43 : $chunkName.hashCode());
        long $startOffset = this.getStartOffset();
        result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
        result = result * 59 + this.getStatus();
        return result;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<ReadIndexBlockMetadata, ReadIndexBlockMetadataBuilder> {
        protected ReadIndexBlockMetadataBuilder newBuilder() {
            return ReadIndexBlockMetadata.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ReadIndexBlockMetadata object, RevisionDataOutput output) throws IOException {
            output.writeUTF(object.name);
            output.writeUTF(object.chunkName);
            output.writeCompactLong(object.startOffset);
            output.writeCompactInt(object.status);
        }

        private void read00(RevisionDataInput input, ReadIndexBlockMetadataBuilder b) throws IOException {
            b.name(input.readUTF());
            b.chunkName(input.readUTF());
            b.startOffset(input.readCompactLong());
            b.status(input.readCompactInt());
        }
    }

    public static class ReadIndexBlockMetadataBuilder
    implements ObjectBuilder<ReadIndexBlockMetadata> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String chunkName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int status;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ReadIndexBlockMetadataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadIndexBlockMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadIndexBlockMetadataBuilder chunkName(String chunkName) {
            this.chunkName = chunkName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadIndexBlockMetadataBuilder startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadIndexBlockMetadataBuilder status(int status) {
            this.status = status;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadIndexBlockMetadata build() {
            return new ReadIndexBlockMetadata(this.name, this.chunkName, this.startOffset, this.status);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ReadIndexBlockMetadata.ReadIndexBlockMetadataBuilder(name=" + this.name + ", chunkName=" + this.chunkName + ", startOffset=" + this.startOffset + ", status=" + this.status + ")";
        }
    }
}

