/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.segmentstore.storage.metadata.StorageMetadata;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public class SegmentMetadata
extends StorageMetadata {
    private final String name;
    private volatile long length;
    private volatile int chunkCount;
    private volatile long startOffset;
    private volatile int status;
    private volatile long maxRollinglength;
    private volatile String firstChunk;
    private volatile String lastChunk;
    private volatile long lastModified;
    private volatile long firstChunkStartOffset;
    private volatile long lastChunkStartOffset;
    private volatile long ownerEpoch;

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public StorageMetadata deepCopy() {
        return this.toBuilder().build();
    }

    public SegmentMetadata setActive(boolean value) {
        return this.setFlag(1, value);
    }

    public SegmentMetadata setSealed(boolean value) {
        return this.setFlag(2, value);
    }

    public SegmentMetadata setStorageSystemSegment(boolean value) {
        return this.setFlag(16, value);
    }

    public SegmentMetadata setOwnershipChanged(boolean value) {
        return this.setFlag(8, value);
    }

    public boolean isActive() {
        return this.getFlag(1);
    }

    public boolean isSealed() {
        return this.getFlag(2);
    }

    public boolean isOwnershipChanged() {
        return this.getFlag(8);
    }

    public boolean isStorageSystemSegment() {
        return this.getFlag(16);
    }

    public void checkInvariants() {
        Preconditions.checkState((this.length >= 0L ? 1 : 0) != 0, (String)"length should be non-negative. %s", (Object)this);
        Preconditions.checkState((this.startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset should be non-negative. %s", (Object)this);
        Preconditions.checkState((this.firstChunkStartOffset >= 0L ? 1 : 0) != 0, (String)"firstChunkStartOffset should be non-negative. %s", (Object)this);
        Preconditions.checkState((this.lastChunkStartOffset >= 0L ? 1 : 0) != 0, (String)"lastChunkStartOffset should be non-negative. %s", (Object)this);
        Preconditions.checkState((this.firstChunkStartOffset <= this.startOffset ? 1 : 0) != 0, (String)"startOffset must not be smaller than firstChunkStartOffset. %s", (Object)this);
        Preconditions.checkState((this.length >= this.lastChunkStartOffset ? 1 : 0) != 0, (String)"lastChunkStartOffset must not be greater than length. %s", (Object)this);
        Preconditions.checkState((this.firstChunkStartOffset <= this.lastChunkStartOffset ? 1 : 0) != 0, (String)"firstChunkStartOffset must not be greater than lastChunkStartOffset. %s", (Object)this);
        Preconditions.checkState((this.chunkCount >= 0 ? 1 : 0) != 0, (String)"chunkCount should be non-negative. %s", (Object)this);
        Preconditions.checkState((this.length >= this.startOffset ? 1 : 0) != 0, (String)"length must be greater or equal to startOffset. %s", (Object)this);
        if (null == this.firstChunk) {
            Preconditions.checkState((null == this.lastChunk ? 1 : 0) != 0, (String)"lastChunk must be null when firstChunk is null. %s", (Object)this);
            Preconditions.checkState((this.firstChunkStartOffset == this.startOffset ? 1 : 0) != 0, (String)"firstChunkStartOffset must equal startOffset when firstChunk is null. %s", (Object)this);
            Preconditions.checkState((this.firstChunkStartOffset == this.lastChunkStartOffset ? 1 : 0) != 0, (String)"firstChunkStartOffset must equal lastChunkStartOffset when firstChunk is null. %s", (Object)this);
            Preconditions.checkState((this.length == this.startOffset ? 1 : 0) != 0, (String)"length must equal startOffset when firstChunk is null. %s", (Object)this);
            Preconditions.checkState((this.chunkCount == 0 ? 1 : 0) != 0, (String)"chunkCount should be 0. %s", (Object)this);
        } else if (this.firstChunk.equals(this.lastChunk)) {
            Preconditions.checkState((this.firstChunkStartOffset == this.lastChunkStartOffset ? 1 : 0) != 0, (String)"firstChunkStartOffset must equal lastChunkStartOffset when there is only one chunk. %s", (Object)this);
            Preconditions.checkState((this.chunkCount == 1 ? 1 : 0) != 0, (String)"chunkCount should be 1. %s", (Object)this);
        } else {
            Preconditions.checkState((this.chunkCount >= 2 ? 1 : 0) != 0, (String)"chunkCount should be 2 or more. %s", (Object)this);
        }
    }

    private SegmentMetadata setFlag(int mask, boolean value) {
        this.status = value ? this.status | mask : this.status & ~mask;
        return this;
    }

    private boolean getFlag(int mask) {
        return (this.status & mask) != 0;
    }

    @ConstructorProperties(value={"name", "length", "chunkCount", "startOffset", "status", "maxRollinglength", "firstChunk", "lastChunk", "lastModified", "firstChunkStartOffset", "lastChunkStartOffset", "ownerEpoch"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    SegmentMetadata(String name, long length, int chunkCount, long startOffset, int status, long maxRollinglength, String firstChunk, String lastChunk, long lastModified, long firstChunkStartOffset, long lastChunkStartOffset, long ownerEpoch) {
        this.name = name;
        this.length = length;
        this.chunkCount = chunkCount;
        this.startOffset = startOffset;
        this.status = status;
        this.maxRollinglength = maxRollinglength;
        this.firstChunk = firstChunk;
        this.lastChunk = lastChunk;
        this.lastModified = lastModified;
        this.firstChunkStartOffset = firstChunkStartOffset;
        this.lastChunkStartOffset = lastChunkStartOffset;
        this.ownerEpoch = ownerEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SegmentMetadataBuilder builder() {
        return new SegmentMetadataBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentMetadataBuilder toBuilder() {
        return new SegmentMetadataBuilder().name(this.name).length(this.length).chunkCount(this.chunkCount).startOffset(this.startOffset).status(this.status).maxRollinglength(this.maxRollinglength).firstChunk(this.firstChunk).lastChunk(this.lastChunk).lastModified(this.lastModified).firstChunkStartOffset(this.firstChunkStartOffset).lastChunkStartOffset(this.lastChunkStartOffset).ownerEpoch(this.ownerEpoch);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLength() {
        return this.length;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getChunkCount() {
        return this.chunkCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartOffset() {
        return this.startOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxRollinglength() {
        return this.maxRollinglength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFirstChunk() {
        return this.firstChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLastChunk() {
        return this.lastChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLastModified() {
        return this.lastModified;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getFirstChunkStartOffset() {
        return this.firstChunkStartOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLastChunkStartOffset() {
        return this.lastChunkStartOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getOwnerEpoch() {
        return this.ownerEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLength(long length) {
        this.length = length;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChunkCount(int chunkCount) {
        this.chunkCount = chunkCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxRollinglength(long maxRollinglength) {
        this.maxRollinglength = maxRollinglength;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFirstChunk(String firstChunk) {
        this.firstChunk = firstChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLastChunk(String lastChunk) {
        this.lastChunk = lastChunk;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFirstChunkStartOffset(long firstChunkStartOffset) {
        this.firstChunkStartOffset = firstChunkStartOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLastChunkStartOffset(long lastChunkStartOffset) {
        this.lastChunkStartOffset = lastChunkStartOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOwnerEpoch(long ownerEpoch) {
        this.ownerEpoch = ownerEpoch;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentMetadata(name=" + this.getName() + ", length=" + this.getLength() + ", chunkCount=" + this.getChunkCount() + ", startOffset=" + this.getStartOffset() + ", status=" + this.getStatus() + ", maxRollinglength=" + this.getMaxRollinglength() + ", firstChunk=" + this.getFirstChunk() + ", lastChunk=" + this.getLastChunk() + ", lastModified=" + this.getLastModified() + ", firstChunkStartOffset=" + this.getFirstChunkStartOffset() + ", lastChunkStartOffset=" + this.getLastChunkStartOffset() + ", ownerEpoch=" + this.getOwnerEpoch() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentMetadata)) {
            return false;
        }
        SegmentMetadata other = (SegmentMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getChunkCount() != other.getChunkCount()) {
            return false;
        }
        if (this.getStartOffset() != other.getStartOffset()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.getMaxRollinglength() != other.getMaxRollinglength()) {
            return false;
        }
        String this$firstChunk = this.getFirstChunk();
        String other$firstChunk = other.getFirstChunk();
        if (this$firstChunk == null ? other$firstChunk != null : !this$firstChunk.equals(other$firstChunk)) {
            return false;
        }
        String this$lastChunk = this.getLastChunk();
        String other$lastChunk = other.getLastChunk();
        if (this$lastChunk == null ? other$lastChunk != null : !this$lastChunk.equals(other$lastChunk)) {
            return false;
        }
        if (this.getLastModified() != other.getLastModified()) {
            return false;
        }
        if (this.getFirstChunkStartOffset() != other.getFirstChunkStartOffset()) {
            return false;
        }
        if (this.getLastChunkStartOffset() != other.getLastChunkStartOffset()) {
            return false;
        }
        return this.getOwnerEpoch() == other.getOwnerEpoch();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentMetadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        result = result * 59 + this.getChunkCount();
        long $startOffset = this.getStartOffset();
        result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
        result = result * 59 + this.getStatus();
        long $maxRollinglength = this.getMaxRollinglength();
        result = result * 59 + (int)($maxRollinglength >>> 32 ^ $maxRollinglength);
        String $firstChunk = this.getFirstChunk();
        result = result * 59 + ($firstChunk == null ? 43 : $firstChunk.hashCode());
        String $lastChunk = this.getLastChunk();
        result = result * 59 + ($lastChunk == null ? 43 : $lastChunk.hashCode());
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        long $firstChunkStartOffset = this.getFirstChunkStartOffset();
        result = result * 59 + (int)($firstChunkStartOffset >>> 32 ^ $firstChunkStartOffset);
        long $lastChunkStartOffset = this.getLastChunkStartOffset();
        result = result * 59 + (int)($lastChunkStartOffset >>> 32 ^ $lastChunkStartOffset);
        long $ownerEpoch = this.getOwnerEpoch();
        result = result * 59 + (int)($ownerEpoch >>> 32 ^ $ownerEpoch);
        return result;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<SegmentMetadata, SegmentMetadataBuilder> {
        protected SegmentMetadataBuilder newBuilder() {
            return SegmentMetadata.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(SegmentMetadata object, RevisionDataOutput output) throws IOException {
            output.writeUTF(object.name);
            output.writeCompactLong(object.length);
            output.writeCompactInt(object.chunkCount);
            output.writeCompactLong(object.startOffset);
            output.writeCompactInt(object.status);
            output.writeCompactLong(object.maxRollinglength);
            output.writeUTF(Strings.nullToEmpty((String)object.firstChunk));
            output.writeUTF(Strings.nullToEmpty((String)object.lastChunk));
            output.writeCompactLong(object.lastModified);
            output.writeCompactLong(object.firstChunkStartOffset);
            output.writeCompactLong(object.lastChunkStartOffset);
            output.writeCompactLong(object.ownerEpoch);
        }

        private void read00(RevisionDataInput input, SegmentMetadataBuilder b) throws IOException {
            b.name(input.readUTF());
            b.length(input.readCompactLong());
            b.chunkCount(input.readCompactInt());
            b.startOffset(input.readCompactLong());
            b.status(input.readCompactInt());
            b.maxRollinglength(input.readCompactLong());
            b.firstChunk(Strings.emptyToNull((String)input.readUTF()));
            b.lastChunk(Strings.emptyToNull((String)input.readUTF()));
            b.lastModified(input.readCompactLong());
            b.firstChunkStartOffset(input.readCompactLong());
            b.lastChunkStartOffset(input.readCompactLong());
            b.ownerEpoch(input.readCompactLong());
        }
    }

    public static class SegmentMetadataBuilder
    implements ObjectBuilder<SegmentMetadata> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long length;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int chunkCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int status;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long maxRollinglength;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String firstChunk;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String lastChunk;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long lastModified;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long firstChunkStartOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long lastChunkStartOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long ownerEpoch;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SegmentMetadataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder length(long length) {
            this.length = length;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder chunkCount(int chunkCount) {
            this.chunkCount = chunkCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder status(int status) {
            this.status = status;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder maxRollinglength(long maxRollinglength) {
            this.maxRollinglength = maxRollinglength;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder firstChunk(String firstChunk) {
            this.firstChunk = firstChunk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder lastChunk(String lastChunk) {
            this.lastChunk = lastChunk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder lastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder firstChunkStartOffset(long firstChunkStartOffset) {
            this.firstChunkStartOffset = firstChunkStartOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder lastChunkStartOffset(long lastChunkStartOffset) {
            this.lastChunkStartOffset = lastChunkStartOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadataBuilder ownerEpoch(long ownerEpoch) {
            this.ownerEpoch = ownerEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentMetadata build() {
            return new SegmentMetadata(this.name, this.length, this.chunkCount, this.startOffset, this.status, this.maxRollinglength, this.firstChunk, this.lastChunk, this.lastModified, this.firstChunkStartOffset, this.lastChunkStartOffset, this.ownerEpoch);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentMetadata.SegmentMetadataBuilder(name=" + this.name + ", length=" + this.length + ", chunkCount=" + this.chunkCount + ", startOffset=" + this.startOffset + ", status=" + this.status + ", maxRollinglength=" + this.maxRollinglength + ", firstChunk=" + this.firstChunk + ", lastChunk=" + this.lastChunk + ", lastModified=" + this.lastModified + ", firstChunkStartOffset=" + this.firstChunkStartOffset + ", lastChunkStartOffset=" + this.lastChunkStartOffset + ", ownerEpoch=" + this.ownerEpoch + ")";
        }
    }
}

