/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.contracts.SegmentType;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.tables.BadKeyVersionException;
import io.pravega.segmentstore.contracts.tables.TableEntry;
import io.pravega.segmentstore.contracts.tables.TableKey;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.storage.DataLogWriterNotPrimaryException;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.BaseMetadataStore;
import io.pravega.segmentstore.storage.metadata.StorageMetadataException;
import io.pravega.segmentstore.storage.metadata.StorageMetadataMetrics;
import io.pravega.segmentstore.storage.metadata.StorageMetadataVersionMismatchException;
import io.pravega.segmentstore.storage.metadata.StorageMetadataWritesFencedOutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableBasedMetadataStore
extends BaseMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableBasedMetadataStore.class);
    private static final BaseMetadataStore.TransactionData.TransactionDataSerializer SERIALIZER = new BaseMetadataStore.TransactionData.TransactionDataSerializer();
    private final TableStore tableStore;
    private final String tableName;
    private final Duration timeout = Duration.ofSeconds(30L);
    private final AtomicBoolean isTableInitialized = new AtomicBoolean(false);

    public TableBasedMetadataStore(String tableName, TableStore tableStore, ChunkedSegmentStorageConfig config, Executor executor) {
        super(config, executor);
        this.tableStore = (TableStore)Preconditions.checkNotNull((Object)tableStore, (Object)"tableStore");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName");
    }

    @Override
    protected CompletableFuture<BaseMetadataStore.TransactionData> read(String key) {
        ArrayList<ByteArraySegment> keys = new ArrayList<ByteArraySegment>();
        keys.add(new ByteArraySegment(key.getBytes(Charsets.UTF_8)));
        Timer t = new Timer();
        return this.ensureInitialized().thenComposeAsync(v -> ((CompletableFuture)this.tableStore.get(this.tableName, (List)keys, this.timeout).thenApplyAsync(entries -> {
            try {
                Preconditions.checkState((entries.size() == 1 ? 1 : 0) != 0, (Object)"Unexpected number of values returned.");
                TableEntry entry = (TableEntry)entries.get(0);
                if (null != entry) {
                    BufferView arr = entry.getValue();
                    BaseMetadataStore.TransactionData txnData = (BaseMetadataStore.TransactionData)SERIALIZER.deserialize(arr);
                    txnData.setDbObject(entry.getKey().getVersion());
                    txnData.setPersisted(true);
                    StorageMetadataMetrics.TABLE_GET_LATENCY.reportSuccessEvent(t.getElapsed());
                    StorageMetadataMetrics.METADATA_FOUND_IN_STORE.inc();
                    return txnData;
                }
            }
            catch (Exception e) {
                throw new CompletionException(new StorageMetadataException("Error while reading", e));
            }
            StorageMetadataMetrics.TABLE_GET_LATENCY.reportSuccessEvent(t.getElapsed());
            StorageMetadataMetrics.METADATA_NOT_FOUND.inc();
            return BaseMetadataStore.TransactionData.builder().key(key).persisted(true).dbObject(-1L).build();
        }, this.getExecutor())).exceptionally(e -> {
            Throwable ex = Exceptions.unwrap((Throwable)e);
            throw new CompletionException(this.handleException(ex));
        }), this.getExecutor());
    }

    @Override
    protected CompletableFuture<Void> writeAll(Collection<BaseMetadataStore.TransactionData> dataList) {
        ArrayList toUpdate = new ArrayList();
        HashMap entryToTxnDataMap = new HashMap();
        HashMap deletedKeyToTxnDataMap = new HashMap();
        ArrayList keysToDelete = new ArrayList();
        Timer t = new Timer();
        return ((CompletableFuture)((CompletableFuture)this.ensureInitialized().thenRunAsync(() -> {
            for (BaseMetadataStore.TransactionData txnData : dataList) {
                Preconditions.checkState((null != txnData.getDbObject() ? 1 : 0) != 0, (Object)"Missing tracking object");
                Long version = (Long)txnData.getDbObject();
                if (null == txnData.getValue()) {
                    TableKey toDelete = TableKey.unversioned((BufferView)new ByteArraySegment(txnData.getKey().getBytes(Charsets.UTF_8)));
                    keysToDelete.add(toDelete);
                    deletedKeyToTxnDataMap.put(toDelete, txnData);
                }
                try {
                    ByteArraySegment arraySegment = SERIALIZER.serialize(txnData);
                    TableEntry tableEntry = TableEntry.versioned((BufferView)new ByteArraySegment(txnData.getKey().getBytes(Charsets.UTF_8)), (BufferView)arraySegment, (long)version);
                    entryToTxnDataMap.put(tableEntry, txnData);
                    toUpdate.add(tableEntry);
                }
                catch (Exception e) {
                    throw new CompletionException(this.handleException(e));
                }
            }
        }, this.getExecutor())).thenComposeAsync(v -> this.tableStore.put(this.tableName, (List)toUpdate, this.timeout).thenComposeAsync(ret -> {
            int i = 0;
            for (TableEntry tableEntry : toUpdate) {
                ((BaseMetadataStore.TransactionData)entryToTxnDataMap.get(tableEntry)).setDbObject(ret.get(i));
                ++i;
            }
            return this.tableStore.remove(this.tableName, (Collection)keysToDelete, this.timeout).handleAsync((v1, ex) -> {
                if (ex == null) {
                    deletedKeyToTxnDataMap.values().stream().forEach(txnData -> txnData.setDbObject(-1L));
                } else {
                    log.warn("Error while deleting keys from table segment {}.", (Object)this.tableName, ex);
                }
                StorageMetadataMetrics.TABLE_WRITE_LATENCY.reportSuccessEvent(t.getElapsed());
                return v1;
            }, this.getExecutor());
        }, this.getExecutor()), this.getExecutor())).exceptionally(e -> {
            Throwable ex = Exceptions.unwrap((Throwable)e);
            throw new CompletionException(this.handleException(ex));
        });
    }

    private StorageMetadataException handleException(Throwable ex) {
        Throwable e = Exceptions.unwrap((Throwable)ex);
        if (e instanceof DataLogWriterNotPrimaryException) {
            return new StorageMetadataWritesFencedOutException("Transaction failed. Writer fenced off", e);
        }
        if (e instanceof BadKeyVersionException) {
            return new StorageMetadataVersionMismatchException("Transaction failed. Version Mismatch.", e);
        }
        return new StorageMetadataException("Transaction failed", e);
    }

    private CompletableFuture<Void> ensureInitialized() {
        if (!this.isTableInitialized.get()) {
            SegmentType segmentType = SegmentType.builder().tableSegment().system().critical().internal().build();
            return ((CompletableFuture)this.tableStore.createSegment(this.tableName, segmentType, this.timeout).thenRunAsync(() -> {
                log.debug("Created table segment {}", (Object)this.tableName);
                this.isTableInitialized.set(true);
            }, this.getExecutor())).exceptionally(e -> {
                Throwable ex = Exceptions.unwrap((Throwable)e);
                if (e.getCause() instanceof StreamSegmentExistsException) {
                    log.debug("Table segment {} already exists.", (Object)this.tableName);
                    this.isTableInitialized.set(true);
                    return null;
                }
                throw new CompletionException(ex);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @VisibleForTesting
    static void copyVersion(TableBasedMetadataStore from, TableBasedMetadataStore to) {
        to.setVersion(from.getVersion());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableStore getTableStore() {
        return this.tableStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTableName() {
        return this.tableName;
    }
}

