/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.CollectionHelpers;
import io.pravega.segmentstore.storage.chunklayer.ChunkAlreadyExistsException;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.segmentstore.storage.mocks.AbstractInMemoryChunkStorage;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryChunkStorage
extends AbstractInMemoryChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryChunkStorage.class);
    private final ConcurrentHashMap<String, InMemoryChunk> chunks = new ConcurrentHashMap();

    public InMemoryChunkStorage(Executor executor) {
        super(executor);
    }

    @Override
    protected ChunkInfo doGetInfo(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)chunkName);
        InMemoryChunk chunk = this.chunks.get(chunkName);
        if (null == chunk) {
            throw new ChunkNotFoundException(chunkName, "InMemoryChunkStorage::doGetInfo");
        }
        return ChunkInfo.builder().length(chunk.getLength()).name(chunkName).build();
    }

    @Override
    protected ChunkHandle doCreate(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)chunkName);
        if (null != this.chunks.putIfAbsent(chunkName, new InMemoryChunk(chunkName))) {
            throw new ChunkAlreadyExistsException(chunkName, "InMemoryChunkStorage::doCreate");
        }
        return new ChunkHandle(chunkName, false);
    }

    @Override
    protected boolean checkExists(String chunkName) {
        return this.chunks.containsKey(chunkName);
    }

    @Override
    protected void doDelete(ChunkHandle handle) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(handle);
        if (null == chunk) {
            throw new ChunkNotFoundException(handle.getChunkName(), "InMemoryChunkStorage::doDelete");
        }
        if (chunk.isReadOnly) {
            throw new ChunkStorageException(handle.getChunkName(), "chunk is readonly");
        }
        this.chunks.remove(handle.getChunkName());
    }

    @Override
    protected ChunkHandle doOpenRead(String chunkName) throws ChunkStorageException {
        if (this.chunks.containsKey(chunkName)) {
            return new ChunkHandle(chunkName, true);
        }
        throw new ChunkNotFoundException(chunkName, "InMemoryChunkStorage::doOpenRead");
    }

    @Override
    protected ChunkHandle doOpenWrite(String chunkName) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(chunkName);
        if (null != chunk) {
            return new ChunkHandle(chunkName, chunk.isReadOnly);
        }
        throw new ChunkNotFoundException(chunkName, "InMemoryChunkStorage::doOpenWrite");
    }

    @Override
    protected int doRead(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(handle);
        if (fromOffset >= chunk.getLength()) {
            throw new IllegalArgumentException(String.format("Reading at offset (%d) which is beyond the current size of chunk (%d).", fromOffset, chunk.getLength()));
        }
        if (length == 0) {
            throw new ChunkStorageException(handle.getChunkName(), "Attempt to read 0 bytes");
        }
        InMemoryChunkData matchingData = null;
        int floorIndex = CollectionHelpers.findGreatestLowerBound(chunk.inMemoryChunkDataList, chunkData -> Long.compare(fromOffset, chunkData.start));
        if (floorIndex != -1) {
            matchingData = chunk.inMemoryChunkDataList.get(floorIndex);
        }
        if (null != matchingData) {
            int i;
            int startIndex = (int)(fromOffset - matchingData.start);
            byte[] source = matchingData.getData();
            for (i = 0; i < length && bufferOffset + i < buffer.length && startIndex + i < source.length; ++i) {
                buffer[bufferOffset + i] = source[startIndex + i];
            }
            return i;
        }
        throw new ChunkStorageException(handle.getChunkName(), "No data was read");
    }

    @Override
    protected int doWrite(ChunkHandle handle, long offset, int length, InputStream data) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(handle);
        long oldLength = chunk.getLength();
        if (chunk.isReadOnly) {
            throw new ChunkStorageException(handle.getChunkName(), "chunk is readonly");
        }
        if (offset != chunk.getLength()) {
            throw new InvalidOffsetException(handle.getChunkName(), chunk.getLength(), offset, "doWrite");
        }
        if (length == 0) {
            return 0;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        byte[] bytes = new byte[length];
        int totalBytesRead = 0;
        int bytesRead = 0;
        try {
            while ((bytesRead = data.read(bytes)) != -1) {
                out.write(bytes, 0, bytesRead);
                totalBytesRead += bytesRead;
            }
        }
        catch (IOException e) {
            throw new ChunkStorageException(handle.getChunkName(), "Error while reading", e);
        }
        Preconditions.checkState((length == totalBytesRead ? 1 : 0) != 0);
        byte[] writtenBytes = out.toByteArray();
        Preconditions.checkState((writtenBytes.length == totalBytesRead ? 1 : 0) != 0);
        chunk.append(writtenBytes);
        Preconditions.checkState((oldLength + (long)totalBytesRead == chunk.getLength() ? 1 : 0) != 0);
        return totalBytesRead;
    }

    private InMemoryChunk getInMemoryChunk(ChunkHandle handle) throws ChunkStorageException {
        String chunkName = handle.getChunkName();
        return this.getInMemoryChunk(chunkName);
    }

    private InMemoryChunk getInMemoryChunk(String chunkName) throws ChunkNotFoundException {
        InMemoryChunk retValue = this.chunks.get(chunkName);
        if (null == retValue) {
            throw new ChunkNotFoundException(chunkName, "InMemoryChunkStorage::getInMemoryChunk");
        }
        return retValue;
    }

    @Override
    protected int doConcat(ConcatArgument[] chunks) throws ChunkStorageException, UnsupportedOperationException {
        return this.concatAtExactLengths(chunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int concatAtExactLengths(ConcatArgument[] chunks) throws ChunkStorageException {
        InMemoryChunk targetChunk;
        int total = Math.toIntExact(chunks[0].getLength());
        InMemoryChunk inMemoryChunk = targetChunk = this.getInMemoryChunk(chunks[0].getName());
        synchronized (inMemoryChunk) {
            targetChunk.truncate(chunks[0].getLength());
            for (int i = 1; i < chunks.length; ++i) {
                ConcatArgument source = chunks[i];
                InMemoryChunk chunk = this.getInMemoryChunk(source.getName());
                chunk.truncate(chunks[i].getLength());
                for (InMemoryChunkData inMemoryChunkData : chunk.getInMemoryChunkDataList()) {
                    targetChunk.append(inMemoryChunkData.getData());
                }
                total = (int)((long)total + chunks[i].getLength());
            }
            return total;
        }
    }

    @Override
    protected boolean doTruncate(ChunkHandle handle, long offset) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(handle);
        return chunk.truncate(offset);
    }

    @Override
    protected void doSetReadOnly(ChunkHandle handle, boolean isReadOnly) throws ChunkStorageException {
        InMemoryChunk chunk = this.getInMemoryChunk(handle);
        chunk.setReadOnly(isReadOnly);
    }

    @Override
    public void addChunk(String chunkName, long length) {
        InMemoryChunk inMemoryChunk = new InMemoryChunk(chunkName);
        inMemoryChunk.append(new byte[Math.toIntExact(length)]);
        this.chunks.put(chunkName, inMemoryChunk);
    }

    static class InMemoryChunkData {
        long start;
        long length;
        byte[] data;

        @ConstructorProperties(value={"start", "length", "data"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        InMemoryChunkData(long start, long length, byte[] data) {
            this.start = start;
            this.length = length;
            this.data = data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static InMemoryChunkDataBuilder builder() {
            return new InMemoryChunkDataBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStart() {
            return this.start;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setStart(long start) {
            this.start = start;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setLength(long length) {
            this.length = length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte[] getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setData(byte[] data) {
            this.data = data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class InMemoryChunkDataBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long start;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private long length;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private byte[] data;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            InMemoryChunkDataBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public InMemoryChunkDataBuilder start(long start) {
                this.start = start;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public InMemoryChunkDataBuilder length(long length) {
                this.length = length;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public InMemoryChunkDataBuilder data(byte[] data) {
                this.data = data;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public InMemoryChunkData build() {
                return new InMemoryChunkData(this.start, this.length, this.data);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "InMemoryChunkStorage.InMemoryChunkData.InMemoryChunkDataBuilder(start=" + this.start + ", length=" + this.length + ", data=" + Arrays.toString(this.data) + ")";
            }
        }
    }

    static class InMemoryChunk {
        private long length;
        private String name;
        private boolean isReadOnly;
        private final List<InMemoryChunkData> inMemoryChunkDataList = new ArrayList<InMemoryChunkData>();

        public InMemoryChunk(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(byte[] data) {
            List<InMemoryChunkData> list = this.inMemoryChunkDataList;
            synchronized (list) {
                this.inMemoryChunkDataList.add(InMemoryChunkData.builder().data(data).length(data.length).start(this.length).build());
                this.length += (long)data.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean truncate(long offset) {
            InMemoryChunkData last = null;
            List<InMemoryChunkData> list = this.inMemoryChunkDataList;
            synchronized (list) {
                for (int i = 0; i < this.inMemoryChunkDataList.size(); ++i) {
                    last = this.inMemoryChunkDataList.get(0);
                    if (last.start <= offset && last.start + last.length < offset) break;
                }
                if (null != last) {
                    int newLength = Math.toIntExact(offset - last.start);
                    if ((long)newLength < last.length) {
                        byte[] newArray = new byte[Math.toIntExact(offset - last.start)];
                        System.arraycopy(last.data, 0, newArray, 0, newLength);
                        last.data = newArray;
                        last.length = newLength;
                    }
                    this.length = offset;
                    return true;
                }
            }
            return false;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setLength(long length) {
            this.length = length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<InMemoryChunkData> getInMemoryChunkDataList() {
            return this.inMemoryChunkDataList;
        }
    }
}

