/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.BaseMetadataStore;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;

public class InMemoryMetadataStore
extends BaseMetadataStore {
    Function<BaseMetadataStore.TransactionData, CompletableFuture<BaseMetadataStore.TransactionData>> readCallback;
    Function<Collection<BaseMetadataStore.TransactionData>, CompletableFuture<BaseMetadataStore.TransactionData>> writeCallback;
    private final AtomicBoolean entryTracker = new AtomicBoolean(false);
    private final Map<String, BaseMetadataStore.TransactionData> backingStore = new ConcurrentHashMap<String, BaseMetadataStore.TransactionData>();

    public InMemoryMetadataStore(ChunkedSegmentStorageConfig config, Executor executor) {
        super(config, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<BaseMetadataStore.TransactionData> read(String key) {
        InMemoryMetadataStore inMemoryMetadataStore = this;
        synchronized (inMemoryMetadataStore) {
            BaseMetadataStore.TransactionData data = this.backingStore.get(key);
            if (null == data) {
                data = BaseMetadataStore.TransactionData.builder().key(key).persisted(true).dbObject(this).build();
            }
            BaseMetadataStore.TransactionData retValue = data;
            CompletionStage<BaseMetadataStore.TransactionData> future = CompletableFuture.completedFuture(retValue);
            if (this.readCallback != null) {
                future = future.thenComposeAsync(v -> this.readCallback.apply(retValue).thenApplyAsync(vv -> retValue, this.getExecutor()), this.getExecutor());
            }
            return future;
        }
    }

    @Override
    protected CompletableFuture<Void> writeAll(Collection<BaseMetadataStore.TransactionData> dataList) {
        CompletableFuture<Object> f = this.writeCallback != null ? this.writeCallback.apply(dataList) : CompletableFuture.completedFuture(null);
        return f.thenRunAsync(() -> {
            InMemoryMetadataStore inMemoryMetadataStore = this;
            synchronized (inMemoryMetadataStore) {
                Preconditions.checkState((!this.entryTracker.getAndSet(true) ? 1 : 0) != 0, (Object)"writeAll should never be called concurrently");
                try {
                    for (BaseMetadataStore.TransactionData data : dataList) {
                        Preconditions.checkState((null != data.getKey() ? 1 : 0) != 0);
                        String key = data.getKey();
                        BaseMetadataStore.TransactionData oldValue = this.backingStore.get(key);
                        if (oldValue != null) {
                            Preconditions.checkState((this == oldValue.getDbObject() ? 1 : 0) != 0, (Object)"Data is not owned.");
                            if (oldValue.getVersion() >= data.getVersion()) {
                                Preconditions.checkState((oldValue.getVersion() <= data.getVersion() ? 1 : 0) != 0, (Object)"Attempt to overwrite newer version");
                            }
                        }
                        data.setDbObject(this);
                        Preconditions.checkState((!data.isPinned() ? 1 : 0) != 0, (Object)"Pinned data should not be stored");
                        this.backingStore.put(key, data);
                    }
                }
                finally {
                    this.entryTracker.set(false);
                }
            }
        }, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InMemoryMetadataStore clone(InMemoryMetadataStore original) {
        InMemoryMetadataStore cloneStore = new InMemoryMetadataStore(original.getConfig(), original.getExecutor());
        InMemoryMetadataStore inMemoryMetadataStore = original;
        synchronized (inMemoryMetadataStore) {
            InMemoryMetadataStore inMemoryMetadataStore2 = cloneStore;
            synchronized (inMemoryMetadataStore2) {
                cloneStore.setVersion(original.getVersion());
                for (Map.Entry<String, BaseMetadataStore.TransactionData> entry : original.backingStore.entrySet()) {
                    String key = entry.getKey();
                    BaseMetadataStore.TransactionData transactionData = entry.getValue();
                    BaseMetadataStore.TransactionData cloneData = transactionData.toBuilder().key(key).value(transactionData.getValue() != null ? transactionData.getValue().deepCopy() : null).version(transactionData.getVersion()).build();
                    Preconditions.checkState((boolean)transactionData.equals(cloneData));
                    if (transactionData.getValue() != null) {
                        Preconditions.checkState((transactionData.getValue() != cloneData.getValue() ? 1 : 0) != 0);
                    }
                    cloneData.setDbObject(cloneStore);
                    cloneStore.backingStore.put(key, cloneData);
                }
            }
        }
        return cloneStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Function<BaseMetadataStore.TransactionData, CompletableFuture<BaseMetadataStore.TransactionData>> getReadCallback() {
        return this.readCallback;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReadCallback(Function<BaseMetadataStore.TransactionData, CompletableFuture<BaseMetadataStore.TransactionData>> readCallback) {
        this.readCallback = readCallback;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Function<Collection<BaseMetadataStore.TransactionData>, CompletableFuture<BaseMetadataStore.TransactionData>> getWriteCallback() {
        return this.writeCallback;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setWriteCallback(Function<Collection<BaseMetadataStore.TransactionData>, CompletableFuture<BaseMetadataStore.TransactionData>> writeCallback) {
        this.writeCallback = writeCallback;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, BaseMetadataStore.TransactionData> getBackingStore() {
        return this.backingStore;
    }
}

