/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.SimpleStorageFactory;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorage;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.metadata.ChunkMetadataStore;
import io.pravega.segmentstore.storage.mocks.InMemoryChunkStorage;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;

public class InMemorySimpleStorageFactory
implements SimpleStorageFactory {
    protected ChunkedSegmentStorageConfig chunkedSegmentStorageConfig;
    protected ScheduledExecutorService executor;
    private Storage singletonStorage;
    private boolean reuseStorage;

    public InMemorySimpleStorageFactory(ChunkedSegmentStorageConfig config, ScheduledExecutorService executor, boolean reuseStorage) {
        this.chunkedSegmentStorageConfig = (ChunkedSegmentStorageConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.reuseStorage = reuseStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Storage createStorageAdapter(int containerId, ChunkMetadataStore metadataStore) {
        InMemorySimpleStorageFactory inMemorySimpleStorageFactory = this;
        synchronized (inMemorySimpleStorageFactory) {
            if (null != this.singletonStorage) {
                return this.singletonStorage;
            }
            Storage storage = InMemorySimpleStorageFactory.newStorage(containerId, this.executor, new InMemoryChunkStorage(this.executor), metadataStore);
            if (this.reuseStorage) {
                this.singletonStorage = storage;
            }
            return storage;
        }
    }

    @Override
    public Storage createStorageAdapter() {
        throw new UnsupportedOperationException("SimpleStorageFactory requires ChunkMetadataStore");
    }

    static Storage newStorage(int containerId, ScheduledExecutorService executor, ChunkStorage chunkStorage, ChunkMetadataStore metadataStore) {
        ChunkedSegmentStorage chunkedSegmentStorage = new ChunkedSegmentStorage(containerId, chunkStorage, metadataStore, executor, ChunkedSegmentStorageConfig.DEFAULT_CONFIG);
        chunkedSegmentStorage.initialize(1L);
        return chunkedSegmentStorage;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChunkedSegmentStorageConfig getChunkedSegmentStorageConfig() {
        return this.chunkedSegmentStorageConfig;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

