/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.StorageNotPrimaryException;
import io.pravega.segmentstore.storage.SyncStorage;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;

public class InMemoryStorage
implements SyncStorage {
    @GuardedBy(value="lock")
    private final HashMap<String, StreamSegmentData> streamSegments = new HashMap();
    private final Object lock = new Object();
    private final AtomicLong currentOwnerId = new AtomicLong(0L);
    private final SyncContext syncContext = new SyncContext(this.currentOwnerId::get);
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();

    @Override
    public void close() {
        this.closed.set(true);
    }

    public static SegmentHandle newHandle(String segmentName, boolean readOnly) {
        return new InMemorySegmentHandle(segmentName, readOnly);
    }

    @Override
    public void initialize(long epoch) {
        Preconditions.checkArgument((epoch > 0L ? 1 : 0) != 0, (String)"epoch must be a positive number. Given %s.", (long)epoch);
        Preconditions.checkState((boolean)this.initialized.compareAndSet(false, true), (Object)"InMemoryStorage is already initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentHandle create(String streamSegmentName) throws StreamSegmentException {
        this.ensurePreconditions();
        Object object = this.lock;
        synchronized (object) {
            if (this.streamSegments.containsKey(streamSegmentName)) {
                throw new StreamSegmentExistsException(streamSegmentName);
            }
            StreamSegmentData data = new StreamSegmentData(streamSegmentName, this.syncContext);
            this.streamSegments.put(streamSegmentName, data);
            return data.openWrite();
        }
    }

    @Override
    public SegmentHandle openWrite(String streamSegmentName) throws StreamSegmentNotExistsException {
        this.ensurePreconditions();
        return this.getStreamSegmentData(streamSegmentName).openWrite();
    }

    @Override
    public SegmentHandle openRead(String streamSegmentName) throws StreamSegmentNotExistsException {
        this.ensurePreconditions();
        return this.getStreamSegmentData(streamSegmentName).openRead();
    }

    @Override
    public void write(SegmentHandle handle, long offset, InputStream data, int length) throws BadOffsetException, StreamSegmentNotExistsException, StreamSegmentSealedException {
        this.ensurePreconditions();
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (Object)"Cannot write using a read-only handle.");
        this.getStreamSegmentData(handle.getSegmentName()).write(offset, data, length);
    }

    @Override
    public int read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws StreamSegmentNotExistsException {
        this.ensurePreconditions();
        return this.getStreamSegmentData(handle.getSegmentName()).read(offset, buffer, bufferOffset, length);
    }

    @Override
    public void seal(SegmentHandle handle) throws StreamSegmentNotExistsException {
        this.ensurePreconditions();
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (Object)"Cannot seal using a read-only handle.");
        this.getStreamSegmentData(handle.getSegmentName()).markSealed();
    }

    @Override
    public void unseal(SegmentHandle handle) throws StreamSegmentException {
        this.ensurePreconditions();
        this.getStreamSegmentData(handle.getSegmentName()).markUnsealed();
    }

    @Override
    public SegmentProperties getStreamSegmentInfo(String streamSegmentName) throws StreamSegmentNotExistsException {
        this.ensurePreconditions();
        return this.getStreamSegmentData(streamSegmentName).getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String streamSegmentName) {
        this.ensurePreconditions();
        Object object = this.lock;
        synchronized (object) {
            return this.streamSegments.containsKey(streamSegmentName);
        }
    }

    @Override
    public void concat(SegmentHandle targetHandle, long offset, String sourceSegment) throws StreamSegmentException {
        this.ensurePreconditions();
        Preconditions.checkArgument((!targetHandle.isReadOnly() ? 1 : 0) != 0, (Object)"Cannot concat using a read-only handle.");
        AtomicLong newLength = new AtomicLong();
        StreamSegmentData sourceData = this.getStreamSegmentData(sourceSegment);
        StreamSegmentData targetData = this.getStreamSegmentData(targetHandle.getSegmentName());
        targetData.concat(sourceData, offset);
        this.deleteInternal(new InMemorySegmentHandle(sourceSegment, false));
        newLength.set(targetData.getInfo().getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(SegmentHandle handle) throws StreamSegmentNotExistsException {
        boolean canDelete;
        this.ensurePreconditions();
        boolean bl = canDelete = !handle.isReadOnly();
        if (!canDelete) {
            Object object = this.lock;
            synchronized (object) {
                if (this.streamSegments.containsKey(handle.getSegmentName())) {
                    canDelete = this.streamSegments.get(handle.getSegmentName()).isSealed();
                }
            }
        }
        Preconditions.checkArgument((boolean)canDelete, (Object)"Cannot delete using a read-only handle, unless the segment is sealed.");
        this.deleteInternal(handle);
    }

    @Override
    public void truncate(SegmentHandle handle, long offset) throws StreamSegmentNotExistsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTruncation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SegmentProperties> listSegments() {
        ArrayList<StreamSegmentData> copyValues;
        InMemoryStorage inMemoryStorage = this;
        synchronized (inMemoryStorage) {
            copyValues = new ArrayList<StreamSegmentData>(this.streamSegments.values());
        }
        return copyValues.stream().map(s -> s.getInfo()).iterator();
    }

    public void append(SegmentHandle handle, InputStream data, int length) {
        this.ensurePreconditions();
        Preconditions.checkArgument((!handle.isReadOnly() ? 1 : 0) != 0, (Object)"Cannot append using a read-only handle.");
        this.getStreamSegmentData(handle.getSegmentName()).append(data, length);
    }

    public void changeOwner() {
        this.currentOwnerId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSegmentData getStreamSegmentData(String streamSegmentName) throws StreamSegmentNotExistsException {
        Object object = this.lock;
        synchronized (object) {
            StreamSegmentData data = this.streamSegments.getOrDefault(streamSegmentName, null);
            if (data == null) {
                throw new StreamSegmentNotExistsException(streamSegmentName);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(SegmentHandle handle) throws StreamSegmentNotExistsException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.streamSegments.containsKey(handle.getSegmentName())) {
                throw new StreamSegmentNotExistsException(handle.getSegmentName());
            }
            this.streamSegments.remove(handle.getSegmentName());
        }
    }

    private void ensurePreconditions() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Preconditions.checkState((boolean)this.initialized.get(), (Object)"InMemoryStorage is not initialized.");
    }

    private static class InMemorySegmentHandle
    implements SegmentHandle {
        private final String segmentName;
        private final boolean readOnly;

        @ConstructorProperties(value={"segmentName", "readOnly"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InMemorySegmentHandle(String segmentName, boolean readOnly) {
            this.segmentName = segmentName;
            this.readOnly = readOnly;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InMemorySegmentHandle)) {
                return false;
            }
            InMemorySegmentHandle other = (InMemorySegmentHandle)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            return this.isReadOnly() == other.isReadOnly();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InMemorySegmentHandle;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "InMemoryStorage.InMemorySegmentHandle(segmentName=" + this.getSegmentName() + ", readOnly=" + this.isReadOnly() + ")";
        }
    }

    private static class SyncContext {
        final Supplier<Long> getCurrentOwnerId;
        final Object syncRoot = new Object();

        @ConstructorProperties(value={"getCurrentOwnerId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SyncContext(Supplier<Long> getCurrentOwnerId) {
            this.getCurrentOwnerId = getCurrentOwnerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Supplier<Long> getGetCurrentOwnerId() {
            return this.getCurrentOwnerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getSyncRoot() {
            return this.syncRoot;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncContext)) {
                return false;
            }
            SyncContext other = (SyncContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Supplier<Long> this$getCurrentOwnerId = this.getGetCurrentOwnerId();
            Supplier<Long> other$getCurrentOwnerId = other.getGetCurrentOwnerId();
            if (this$getCurrentOwnerId == null ? other$getCurrentOwnerId != null : !this$getCurrentOwnerId.equals(other$getCurrentOwnerId)) {
                return false;
            }
            Object this$syncRoot = this.getSyncRoot();
            Object other$syncRoot = other.getSyncRoot();
            return !(this$syncRoot == null ? other$syncRoot != null : !this$syncRoot.equals(other$syncRoot));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SyncContext;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<Long> $getCurrentOwnerId = this.getGetCurrentOwnerId();
            result = result * 59 + ($getCurrentOwnerId == null ? 43 : $getCurrentOwnerId.hashCode());
            Object $syncRoot = this.getSyncRoot();
            result = result * 59 + ($syncRoot == null ? 43 : $syncRoot.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "InMemoryStorage.SyncContext(getCurrentOwnerId=" + this.getGetCurrentOwnerId() + ", syncRoot=" + this.getSyncRoot() + ")";
        }
    }

    private static class StreamSegmentData {
        private static final int BUFFER_SIZE = 16384;
        private final String name;
        @GuardedBy(value="lock")
        private final ArrayList<byte[]> data;
        private final Object lock = new Object();
        private final SyncContext context;
        @GuardedBy(value="lock")
        private long currentOwnerId;
        @GuardedBy(value="lock")
        private long length;
        @GuardedBy(value="lock")
        private boolean sealed;
        @GuardedBy(value="lock")
        private int firstBufferOffset;

        StreamSegmentData(String name, SyncContext context) {
            this.name = name;
            this.data = new ArrayList();
            this.length = 0L;
            this.sealed = false;
            this.context = context;
            this.currentOwnerId = Long.MIN_VALUE;
            this.firstBufferOffset = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SegmentHandle openWrite() {
            Object object = this.lock;
            synchronized (object) {
                this.currentOwnerId = this.context.getCurrentOwnerId.get();
                return new InMemorySegmentHandle(this.name, this.sealed);
            }
        }

        SegmentHandle openRead() {
            return new InMemorySegmentHandle(this.name, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(long startOffset, InputStream data, int length) throws BadOffsetException, StreamSegmentSealedException {
            Object object = this.lock;
            synchronized (object) {
                this.checkOpened();
                this.writeInternal(startOffset, data, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void append(InputStream data, int length) throws StreamSegmentSealedException {
            Object object = this.lock;
            synchronized (object) {
                this.write(this.length, data, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int read(long startOffset, byte[] target, int targetOffset, int length) {
            Object object = this.lock;
            synchronized (object) {
                Exceptions.checkArrayRange((long)targetOffset, (int)length, (long)target.length, (String)"targetOffset", (String)"length");
                Exceptions.checkArrayRange((long)startOffset, (int)length, (long)this.length, (String)"startOffset", (String)"length");
                long offset = startOffset;
                int readBytes = 0;
                while (readBytes < length) {
                    OffsetLocation ol = this.getOffsetLocation(offset);
                    int bytesToCopy = Math.min(16384 - ol.bufferOffset, length - readBytes);
                    System.arraycopy(this.data.get(ol.bufferSequence), ol.bufferOffset, target, targetOffset + readBytes, bytesToCopy);
                    readBytes += bytesToCopy;
                    offset += (long)bytesToCopy;
                }
                return readBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markSealed() {
            Object object = this.lock;
            synchronized (object) {
                this.checkOpened();
                this.sealed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markUnsealed() {
            Object object = this.lock;
            synchronized (object) {
                this.checkOpened();
                this.sealed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isSealed() {
            Object object = this.lock;
            synchronized (object) {
                return this.sealed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void concat(StreamSegmentData other, long offset) throws BadOffsetException, StreamSegmentSealedException {
            Object object = this.context.syncRoot;
            synchronized (object) {
                Object object2 = other.lock;
                synchronized (object2) {
                    Preconditions.checkState((boolean)other.sealed, (String)"Cannot concat segment '%s' into '%s' because it is not sealed.", (Object)other.name, (Object)this.name);
                    other.checkOpened();
                    Object object3 = this.lock;
                    synchronized (object3) {
                        this.checkOpened();
                        if (offset != this.length) {
                            throw new BadOffsetException(this.name, this.length, offset);
                        }
                        long bytesCopied = 0L;
                        int currentBlockIndex = 0;
                        while (bytesCopied < other.length) {
                            byte[] currentBlock = other.data.get(currentBlockIndex);
                            int length = (int)Math.min((long)currentBlock.length, other.length - bytesCopied);
                            ByteArrayInputStream bis = new ByteArrayInputStream(currentBlock, 0, length);
                            this.writeInternal(this.length, bis, length);
                            bytesCopied += (long)length;
                            ++currentBlockIndex;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SegmentProperties getInfo() {
            Object object = this.lock;
            synchronized (object) {
                return StreamSegmentInformation.builder().name(this.name).length(this.length).sealed(this.sealed).build();
            }
        }

        @GuardedBy(value="lock")
        private void ensureAllocated(long startOffset, int length) {
            long endOffset = startOffset + (long)length;
            int desiredSize = this.getOffsetLocation((long)endOffset).bufferSequence + 1;
            while (this.data.size() < desiredSize) {
                this.data.add(new byte[16384]);
            }
        }

        @GuardedBy(value="lock")
        private OffsetLocation getOffsetLocation(long offset) {
            return new OffsetLocation((int)((offset += (long)this.firstBufferOffset) / 16384L), (int)(offset % 16384L));
        }

        @GuardedBy(value="lock")
        private void writeInternal(long startOffset, InputStream data, int length) throws BadOffsetException, StreamSegmentSealedException {
            Exceptions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length", (String)"bad length", (Object[])new Object[0]);
            if (startOffset != this.length) {
                throw new BadOffsetException(this.name, this.length, startOffset);
            }
            if (this.sealed) {
                throw new StreamSegmentSealedException(this.name);
            }
            long offset = startOffset;
            this.ensureAllocated(offset, length);
            int writtenBytes = 0;
            while (writtenBytes < length) {
                OffsetLocation ol = this.getOffsetLocation(offset);
                int readBytes = data.read(this.data.get(ol.bufferSequence), ol.bufferOffset, Math.min(length - writtenBytes, 16384 - ol.bufferOffset));
                if (readBytes < 0) {
                    throw new IOException("reached end of stream while still expecting data");
                }
                writtenBytes += readBytes;
                offset += (long)readBytes;
            }
            this.length = Math.max(this.length, startOffset + (long)length);
        }

        @GuardedBy(value="lock")
        private void checkOpened() {
            if (this.currentOwnerId != this.context.getCurrentOwnerId.get()) {
                throw new StorageNotPrimaryException(this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return String.format("%s: Length = %d, Sealed = %s", this.name, this.length, this.sealed);
            }
        }

        private static class OffsetLocation {
            final int bufferSequence;
            final int bufferOffset;

            @ConstructorProperties(value={"bufferSequence", "bufferOffset"})
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public OffsetLocation(int bufferSequence, int bufferOffset) {
                this.bufferSequence = bufferSequence;
                this.bufferOffset = bufferOffset;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public int getBufferSequence() {
                return this.bufferSequence;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public int getBufferOffset() {
                return this.bufferOffset;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OffsetLocation)) {
                    return false;
                }
                OffsetLocation other = (OffsetLocation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getBufferSequence() != other.getBufferSequence()) {
                    return false;
                }
                return this.getBufferOffset() == other.getBufferOffset();
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof OffsetLocation;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getBufferSequence();
                result = result * 59 + this.getBufferOffset();
                return result;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "InMemoryStorage.StreamSegmentData.OffsetLocation(bufferSequence=" + this.getBufferSequence() + ", bufferOffset=" + this.getBufferOffset() + ")";
            }
        }
    }
}

