/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.mocks.InMemoryStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;

public class InMemoryStorageFactory
implements StorageFactory,
AutoCloseable {
    @VisibleForTesting
    protected SharedStorage baseStorage;
    @VisibleForTesting
    protected ScheduledExecutorService executor;

    public InMemoryStorageFactory(ScheduledExecutorService executor) {
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.initialize();
    }

    public InMemoryStorageFactory() {
    }

    @Override
    public Storage createStorageAdapter() {
        return new AsyncStorageWrapper(new RollingStorage(this.baseStorage), this.executor);
    }

    @Override
    public SyncStorage createSyncStorage() {
        return this.baseStorage;
    }

    @Override
    public void close() {
        this.baseStorage.closeInternal();
    }

    @VisibleForTesting
    public static Storage newStorage(Executor executor) {
        return new AsyncStorageWrapper(new InMemoryStorage(), executor);
    }

    public void initialize() {
        this.baseStorage = new SharedStorage();
        this.baseStorage.initializeInternal(1L);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    private static class SharedStorage
    extends InMemoryStorage {
        private SharedStorage() {
        }

        private void closeInternal() {
            super.close();
        }

        private void initializeInternal(long epoch) {
            super.initialize(epoch);
        }

        @Override
        public void initialize(long epoch) {
            Preconditions.checkArgument((epoch > 0L ? 1 : 0) != 0, (Object)"epoch must be a positive number.");
        }

        @Override
        public void close() {
        }
    }
}

