/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import io.pravega.segmentstore.storage.StorageFactoryInfo;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.chunklayer.ChunkedSegmentStorageConfig;
import io.pravega.segmentstore.storage.mocks.InMemorySimpleStorageFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryStorageFactory;
import java.util.concurrent.ScheduledExecutorService;

public class InMemoryStorageFactoryCreator
implements StorageFactoryCreator {
    @Override
    public StorageFactory createFactory(StorageFactoryInfo storageFactoryInfo, ConfigSetup setup, ScheduledExecutorService executor) {
        if (storageFactoryInfo.getStorageLayoutType().equals((Object)StorageLayoutType.CHUNKED_STORAGE)) {
            InMemorySimpleStorageFactory factory = new InMemorySimpleStorageFactory((ChunkedSegmentStorageConfig)setup.getConfig(ChunkedSegmentStorageConfig::builder), executor, true);
            return factory;
        }
        InMemoryStorageFactory factory = new InMemoryStorageFactory(executor);
        return factory;
    }

    @Override
    public StorageFactoryInfo[] getStorageFactories() {
        return new StorageFactoryInfo[]{StorageFactoryInfo.builder().name("INMEMORY").storageLayoutType(StorageLayoutType.CHUNKED_STORAGE).build(), StorageFactoryInfo.builder().name("INMEMORY").storageLayoutType(StorageLayoutType.ROLLING_STORAGE).build()};
    }
}

