/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.noop;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.chunklayer.ChunkAlreadyExistsException;
import io.pravega.segmentstore.storage.chunklayer.ChunkHandle;
import io.pravega.segmentstore.storage.chunklayer.ChunkInfo;
import io.pravega.segmentstore.storage.chunklayer.ChunkNotFoundException;
import io.pravega.segmentstore.storage.chunklayer.ChunkStorageException;
import io.pravega.segmentstore.storage.chunklayer.ConcatArgument;
import io.pravega.segmentstore.storage.chunklayer.InvalidOffsetException;
import io.pravega.segmentstore.storage.mocks.AbstractInMemoryChunkStorage;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpChunkStorage
extends AbstractInMemoryChunkStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoOpChunkStorage.class);
    ConcurrentHashMap<String, ChunkData> chunkMetadata = new ConcurrentHashMap();

    public NoOpChunkStorage(Executor executor) {
        super(executor);
    }

    @Override
    protected ChunkInfo doGetInfo(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        ChunkData chunkData = this.chunkMetadata.get(chunkName);
        if (null == chunkData) {
            throw new ChunkNotFoundException(chunkName, "NoOpChunkStorage::doGetInfo");
        }
        return ChunkInfo.builder().name(chunkName).length(chunkData.length).build();
    }

    @Override
    protected ChunkHandle doCreate(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        ChunkData chunkData = this.chunkMetadata.get(chunkName);
        if (null != chunkData) {
            throw new ChunkAlreadyExistsException(chunkName, "NoOpChunkStorage::doCreate");
        }
        this.chunkMetadata.put(chunkName, new ChunkData());
        return ChunkHandle.writeHandle(chunkName);
    }

    @Override
    protected boolean checkExists(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        return this.chunkMetadata.containsKey(chunkName);
    }

    @Override
    protected void doDelete(ChunkHandle handle) throws ChunkStorageException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)(null != handle ? 1 : 0), (Object)"handle");
        Preconditions.checkNotNull((Object)handle.getChunkName(), (Object)"handle");
        ChunkData chunkData = this.chunkMetadata.get(handle.getChunkName());
        if (null == chunkData) {
            throw new ChunkNotFoundException(handle.getChunkName(), "NoOpChunkStorage::doDelete");
        }
        if (chunkData.isReadonly) {
            throw new ChunkStorageException(handle.getChunkName(), "chunk is readonly");
        }
        this.chunkMetadata.remove(handle.getChunkName());
    }

    @Override
    protected ChunkHandle doOpenRead(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        ChunkData chunkData = this.chunkMetadata.get(chunkName);
        if (null == chunkData) {
            throw new ChunkNotFoundException(chunkName, "NoOpChunkStorage::doOpenRead");
        }
        return ChunkHandle.readHandle(chunkName);
    }

    @Override
    protected ChunkHandle doOpenWrite(String chunkName) throws ChunkStorageException, IllegalArgumentException {
        ChunkData chunkData = this.chunkMetadata.get(chunkName);
        if (null == chunkData) {
            throw new ChunkNotFoundException(chunkName, "NoOpChunkStorage::doOpenWrite");
        }
        return new ChunkHandle(chunkName, chunkData.isReadonly);
    }

    @Override
    protected int doRead(ChunkHandle handle, long fromOffset, int length, byte[] buffer, int bufferOffset) throws ChunkStorageException, NullPointerException, IndexOutOfBoundsException {
        ChunkData chunkData = this.chunkMetadata.get(handle.getChunkName());
        if (null == chunkData) {
            throw new ChunkNotFoundException(handle.getChunkName(), "NoOpChunkStorage::doRead");
        }
        if (fromOffset >= chunkData.length) {
            throw new IllegalArgumentException(String.format("Reading at offset (%d) which is beyond the current size of chunk (%d).", fromOffset, chunkData.length));
        }
        if (fromOffset + (long)length > chunkData.length) {
            throw new IndexOutOfBoundsException("fromOffset");
        }
        if (fromOffset < 0L || bufferOffset < 0 || length < 0 || buffer.length < bufferOffset + length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Offset (%s) must be non-negative, and bufferOffset (%s) and length (%s) must be valid indices into buffer of size %s.", fromOffset, bufferOffset, length, buffer.length));
        }
        return length;
    }

    @Override
    protected int doWrite(ChunkHandle handle, long offset, int length, InputStream data) throws ChunkStorageException, IndexOutOfBoundsException {
        ChunkData chunkData = this.chunkMetadata.get(handle.getChunkName());
        if (null == chunkData) {
            throw new ChunkNotFoundException(handle.getChunkName(), "NoOpChunkStorage::doWrite");
        }
        if (chunkData.isReadonly) {
            throw new ChunkStorageException(handle.getChunkName(), "chunk is readonly");
        }
        if (offset != chunkData.length) {
            throw new InvalidOffsetException(handle.getChunkName(), chunkData.length, offset, "doWrite");
        }
        chunkData.length = offset + (long)length;
        this.chunkMetadata.put(handle.getChunkName(), chunkData);
        return length;
    }

    @Override
    protected int doConcat(ConcatArgument[] chunks) throws ChunkStorageException {
        int total = 0;
        for (ConcatArgument chunk : chunks) {
            ChunkData chunkData = this.chunkMetadata.get(chunk.getName());
            if (null == chunkData) {
                throw new ChunkNotFoundException(chunk.getName(), "NoOpChunkStorage::doConcat");
            }
            Preconditions.checkState((chunkData.length >= chunk.getLength() ? 1 : 0) != 0);
            total = (int)((long)total + chunk.getLength());
        }
        ChunkData targetChunkData = this.chunkMetadata.get(chunks[0].getName());
        targetChunkData.length = total;
        return total;
    }

    @Override
    protected boolean doTruncate(ChunkHandle handle, long offset) throws ChunkStorageException {
        ChunkData chunkData = this.chunkMetadata.get(handle.getChunkName());
        if (null == chunkData) {
            throw new ChunkNotFoundException(handle.getChunkName(), "NoOpChunkStorage::doTruncate");
        }
        if (offset < chunkData.length) {
            chunkData.length = offset;
            return true;
        }
        return false;
    }

    @Override
    protected void doSetReadOnly(ChunkHandle handle, boolean isReadOnly) throws ChunkStorageException {
        Preconditions.checkNotNull((Object)(null != handle ? 1 : 0), (Object)"handle");
        Preconditions.checkNotNull((Object)handle.getChunkName(), (Object)"handle");
        String chunkName = handle.getChunkName();
        ChunkData chunkData = this.chunkMetadata.get(chunkName);
        if (null == chunkData) {
            throw new ChunkNotFoundException(chunkName, "NoOpChunkStorage::doSetReadOnly");
        }
        chunkData.isReadonly = isReadOnly;
    }

    @Override
    public void addChunk(String chunkName, long length) {
        ChunkData chunkData = new ChunkData();
        chunkData.length = length;
        this.chunkMetadata.put(chunkName, chunkData);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConcurrentHashMap<String, ChunkData> getChunkMetadata() {
        return this.chunkMetadata;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setChunkMetadata(ConcurrentHashMap<String, ChunkData> chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
    }

    private static class ChunkData {
        private long length;
        private boolean isReadonly;

        private ChunkData() {
        }
    }
}

