/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.noop;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.SegmentProperties;
import io.pravega.segmentstore.contracts.StreamSegmentException;
import io.pravega.segmentstore.contracts.StreamSegmentInformation;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.noop.StorageExtraConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoOpStorage
implements SyncStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoOpStorage.class);
    private final SyncStorage baseStorage;
    private final SyncStorage storageForNoOp;
    private final int writeNoOpLatencyMills;

    NoOpStorage(StorageExtraConfig config, SyncStorage baseStorage, SyncStorage storageForNoOp) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        this.writeNoOpLatencyMills = config.getStorageWriteNoOpLatencyMillis();
        this.baseStorage = (SyncStorage)Preconditions.checkNotNull((Object)baseStorage, (Object)"baseStorage");
        this.storageForNoOp = storageForNoOp;
    }

    @Override
    public void close() {
        this.baseStorage.close();
        if (this.storageForNoOp != null) {
            this.storageForNoOp.close();
        }
    }

    @Override
    public void initialize(long epoch) {
        this.baseStorage.initialize(epoch);
        if (this.storageForNoOp != null) {
            this.storageForNoOp.initialize(epoch);
        }
    }

    private <R> R delegate(String segmentName, ThrowingFunction<SyncStorage, R, StreamSegmentException> f, String errorMessage) throws StreamSegmentException {
        if (this.isSystemSegment(segmentName)) {
            return f.accept(this.baseStorage);
        }
        if (this.storageForNoOp != null) {
            return f.accept(this.storageForNoOp);
        }
        throw new UnsupportedOperationException(errorMessage);
    }

    private <R> R delegateNoCheckedException(String segmentName, Function<SyncStorage, R> f, String errorMessage) {
        if (this.isSystemSegment(segmentName)) {
            return f.apply(this.baseStorage);
        }
        if (this.storageForNoOp != null) {
            return f.apply(this.storageForNoOp);
        }
        throw new UnsupportedOperationException(errorMessage);
    }

    private void delegateNoOp(String segmentName, NoOpFunction<SyncStorage, StreamSegmentException> f) throws StreamSegmentException {
        if (this.isSystemSegment(segmentName)) {
            f.accept(this.baseStorage);
        } else if (this.storageForNoOp != null) {
            f.accept(this.storageForNoOp);
        } else {
            this.noOp();
        }
    }

    @Override
    public SegmentProperties getStreamSegmentInfo(String streamSegmentName) throws StreamSegmentException {
        if (this.isSystemSegment(streamSegmentName)) {
            return this.baseStorage.getStreamSegmentInfo(streamSegmentName);
        }
        if (this.storageForNoOp != null) {
            return this.storageForNoOp.getStreamSegmentInfo(streamSegmentName);
        }
        return StreamSegmentInformation.builder().name(streamSegmentName).build();
    }

    @Override
    public boolean exists(String streamSegmentName) {
        return this.delegateNoCheckedException(streamSegmentName, storage -> storage.exists(streamSegmentName), "exists() for user segment is not supported in NO-OP mode.");
    }

    @Override
    public int read(SegmentHandle handle, long offset, byte[] buffer, int bufferOffset, int length) throws StreamSegmentException {
        return this.delegate(handle.getSegmentName(), storage -> storage.read(handle, offset, buffer, bufferOffset, length), "read() of user segment is not supported in NO-OP mode.");
    }

    @Override
    public SegmentHandle openRead(String streamSegmentName) throws StreamSegmentException {
        if (this.isSystemSegment(streamSegmentName)) {
            return this.baseStorage.openRead(streamSegmentName);
        }
        if (this.storageForNoOp != null) {
            return this.storageForNoOp.openRead(streamSegmentName);
        }
        return new NoOpSegmentHandle(streamSegmentName);
    }

    @Override
    public void seal(SegmentHandle handle) throws StreamSegmentException {
        this.delegateNoOp(handle.getSegmentName(), storage -> storage.seal(handle));
    }

    @Override
    public void unseal(SegmentHandle handle) throws StreamSegmentException {
        this.delegateNoOp(handle.getSegmentName(), storage -> storage.unseal(handle));
    }

    @Override
    public void concat(SegmentHandle target, long offset, String sourceSegment) throws StreamSegmentException {
        this.delegateNoOp(target.getSegmentName(), storage -> storage.concat(target, offset, sourceSegment));
    }

    @Override
    public void delete(SegmentHandle handle) throws StreamSegmentException {
        this.delegateNoOp(handle.getSegmentName(), storage -> storage.delete(handle));
    }

    @Override
    public void truncate(SegmentHandle handle, long offset) throws StreamSegmentException {
        this.delegateNoOp(handle.getSegmentName(), storage -> storage.truncate(handle, offset));
    }

    @Override
    public boolean supportsTruncation() {
        return this.baseStorage.supportsTruncation();
    }

    @Override
    public Iterator<SegmentProperties> listSegments() throws IOException {
        return this.baseStorage.listSegments();
    }

    @Override
    public void write(SegmentHandle handle, long offset, InputStream data, int length) throws StreamSegmentException {
        this.delegateNoOp(handle.getSegmentName(), storage -> storage.write(handle, offset, data, length));
    }

    @Override
    public SegmentHandle openWrite(String streamSegmentName) throws StreamSegmentException {
        if (this.isSystemSegment(streamSegmentName)) {
            return this.baseStorage.openWrite(streamSegmentName);
        }
        if (this.storageForNoOp != null) {
            return this.storageForNoOp.openWrite(streamSegmentName);
        }
        return new NoOpSegmentHandle(streamSegmentName);
    }

    @Override
    public SegmentHandle create(String streamSegmentName) throws StreamSegmentException {
        if (this.isSystemSegment(streamSegmentName)) {
            return this.baseStorage.create(streamSegmentName);
        }
        if (this.storageForNoOp != null) {
            return this.storageForNoOp.create(streamSegmentName);
        }
        return new NoOpSegmentHandle(streamSegmentName);
    }

    private boolean isSystemSegment(String segmentName) {
        Preconditions.checkNotNull((Object)segmentName);
        return segmentName.startsWith("_") || segmentName.contains("_tables");
    }

    private void noOp() {
        Uninterruptibles.sleepUninterruptibly((long)this.writeNoOpLatencyMills, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    static class NoOpSegmentHandle
    implements SegmentHandle {
        private final String segmentName;

        public NoOpSegmentHandle(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public String getSegmentName() {
            return this.segmentName;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    private static interface NoOpFunction<Storage, E extends Throwable> {
        public void accept(Storage var1) throws E;
    }

    private static interface ThrowingFunction<Storage, Result, E extends Throwable> {
        public Result accept(Storage var1) throws E;
    }
}

