/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.rolling;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.pravega.common.io.ByteBufferOutputStream;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import io.pravega.segmentstore.storage.rolling.RollingSegmentHandle;
import io.pravega.segmentstore.storage.rolling.SegmentChunk;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

final class HandleSerializer {
    private static final Charset ENCODING = Charsets.UTF_8;
    private static final String KEY_POLICY_MAX_SIZE = "maxsize";
    private static final String KEY_CONCAT = "concat";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String SEPARATOR = "&";
    private static final String CONCAT_SEPARATOR = "@";

    HandleSerializer() {
    }

    static RollingSegmentHandle deserialize(byte[] serialization, SegmentHandle headerHandle) {
        StringTokenizer st = new StringTokenizer(new String(serialization, ENCODING), SEPARATOR, false);
        Preconditions.checkArgument((boolean)st.hasMoreTokens(), (Object)"No separators in serialization.");
        SegmentRollingPolicy policy = null;
        OffsetAdjuster om = new OffsetAdjuster();
        long lastOffset = 0L;
        ArrayList<SegmentChunk> segmentChunks = new ArrayList<SegmentChunk>();
        while (st.hasMoreTokens()) {
            Map.Entry<String, String> entry = HandleSerializer.parse(st.nextToken());
            if (entry.getKey().equalsIgnoreCase(KEY_POLICY_MAX_SIZE)) {
                if (policy != null) continue;
                Preconditions.checkArgument((boolean)HandleSerializer.isValidLong(entry.getValue()), (String)"Invalid entry value for '%s'.", entry);
                policy = new SegmentRollingPolicy(Long.parseLong(entry.getValue()));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase(KEY_CONCAT)) {
                Map.Entry<Long, Integer> concatInfo = HandleSerializer.parseConcat(entry.getValue());
                om.set(concatInfo.getKey(), concatInfo.getValue());
                continue;
            }
            Preconditions.checkArgument((boolean)HandleSerializer.isValidLong(entry.getKey()), (String)"Invalid key value for '%s'.", entry);
            long offset = om.adjustOffset(Long.parseLong(entry.getKey()));
            SegmentChunk s = new SegmentChunk(entry.getValue(), offset);
            Preconditions.checkArgument((lastOffset <= s.getStartOffset() ? 1 : 0) != 0, (String)"SegmentChunk Entry '%s' has out-of-order offset (previous=%s).", (Object)s, (long)lastOffset);
            segmentChunks.add(s);
            lastOffset = s.getStartOffset();
        }
        RollingSegmentHandle h = new RollingSegmentHandle(headerHandle, policy, segmentChunks);
        h.setHeaderLength(serialization.length);
        return h;
    }

    static ByteArraySegment serialize(RollingSegmentHandle handle) {
        try (ByteBufferOutputStream os = new ByteBufferOutputStream();){
            os.write(HandleSerializer.combine(KEY_POLICY_MAX_SIZE, Long.toString(handle.getRollingPolicy().getMaxLength())));
            handle.chunks().forEach(chunk -> os.write(HandleSerializer.serializeChunk(chunk)));
            ByteArraySegment byteArraySegment = os.getData();
            return byteArraySegment;
        }
    }

    static byte[] serializeChunk(SegmentChunk segmentChunk) {
        return HandleSerializer.combine(Long.toString(segmentChunk.getStartOffset()), segmentChunk.getName());
    }

    static byte[] serializeConcat(int chunkCount, long concatOffset) {
        return HandleSerializer.combine(KEY_CONCAT, chunkCount + CONCAT_SEPARATOR + concatOffset);
    }

    private static byte[] combine(String key, String value) {
        return (key + KEY_VALUE_SEPARATOR + value + SEPARATOR).getBytes(ENCODING);
    }

    private static Map.Entry<String, String> parse(String entry) {
        int sp = entry.indexOf(KEY_VALUE_SEPARATOR);
        Preconditions.checkArgument((sp > 0 && sp < entry.length() - 1 ? 1 : 0) != 0, (String)"Header entry '%s' is invalid.", (Object)entry);
        String key = entry.substring(0, sp);
        String value = entry.substring(sp + KEY_VALUE_SEPARATOR.length());
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (String)"Missing entry key for '%s'.", (Object)entry);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Missing entry value for '%s'.", (Object)entry);
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    private static Map.Entry<Long, Integer> parseConcat(String concat) {
        int pos = concat.indexOf(CONCAT_SEPARATOR);
        Preconditions.checkArgument((pos > 0 && pos < concat.length() - 1 ? 1 : 0) != 0, (String)"%s value '%s' is invalid.", (Object)KEY_CONCAT, (Object)concat);
        String count = concat.substring(0, pos);
        String offset = concat.substring(pos + CONCAT_SEPARATOR.length());
        try {
            AbstractMap.SimpleImmutableEntry<Long, Integer> result = new AbstractMap.SimpleImmutableEntry<Long, Integer>(Long.parseLong(offset), Integer.parseInt(count));
            Preconditions.checkArgument((result.getKey() >= 0L && result.getValue() >= 0 ? 1 : 0) != 0, (String)"%s value '%s' is invalid.", (Object)KEY_CONCAT, (Object)concat);
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("%s value '%s' is invalid.", KEY_CONCAT, concat), nfe);
        }
    }

    private static boolean isValidLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static class OffsetAdjuster {
        private long offsetAdjustment;
        private int remainingCount;
        private int originalCount;

        private OffsetAdjuster() {
        }

        void set(long offsetAdjustment, int count) {
            this.offsetAdjustment = offsetAdjustment;
            this.remainingCount = count;
            this.originalCount = count;
        }

        long adjustOffset(long offset) {
            if (offset != 0L && this.remainingCount == this.originalCount) {
                this.set(0L, 0);
            } else if (this.remainingCount > 0) {
                --this.remainingCount;
                offset += this.offsetAdjustment;
            }
            return offset;
        }
    }
}

