/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.Map;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;

public class DockerInspectCommand
extends DockerCommand {
    private static final String INSPECT_COMMAND = "inspect";
    private String commandArguments;
    public static final String STATUS_TEMPLATE = "{{.State.Status}}";
    public static final String STOPSIGNAL_TEMPLATE = "{{.Config.StopSignal}}";

    public DockerInspectCommand(String containerName) {
        super(INSPECT_COMMAND);
        super.addCommandArguments("name", containerName);
    }

    public DockerInspectCommand getContainerStatus() {
        super.addCommandArguments("format", STATUS_TEMPLATE);
        this.commandArguments = String.format("--format=%s", STATUS_TEMPLATE);
        return this;
    }

    public DockerInspectCommand getIpAndHost() {
        super.addCommandArguments("format", "{{range(.NetworkSettings.Networks)}}{{.IPAddress}},{{end}}{{.Config.Hostname}}");
        this.commandArguments = "--format={{range(.NetworkSettings.Networks)}}{{.IPAddress}},{{end}}{{.Config.Hostname}}";
        return this;
    }

    public DockerInspectCommand get(String[] templates, char delimiter) {
        String format = StringUtils.join((char)delimiter, (String[])templates);
        super.addCommandArguments("format", format);
        this.commandArguments = String.format("--format=%s", format);
        return this;
    }

    @Override
    public PrivilegedOperation preparePrivilegedOperation(DockerCommand dockerCommand, String containerName, Map<String, String> env, Context nmContext) {
        PrivilegedOperation dockerOp = new PrivilegedOperation(PrivilegedOperation.OperationType.INSPECT_DOCKER_CONTAINER);
        dockerOp.appendArgs(this.commandArguments, containerName);
        return dockerOp;
    }

    public DockerInspectCommand getExposedPorts() {
        super.addCommandArguments("format", "{{json .NetworkSettings.Ports}}");
        this.commandArguments = "--format={{json .NetworkSettings.Ports}}";
        return this;
    }
}

