/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.InvalidPropertyValueException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import lombok.Generated;
import org.apache.bookkeeper.client.api.DigestType;

public class BookKeeperConfig {
    public static final Property<String> ZK_ADDRESS = Property.named((String)"zk.connect.uri", (Object)"localhost:2181", (String)"zkAddress");
    public static final Property<Integer> ZK_SESSION_TIMEOUT = Property.named((String)"zk.connect.sessionTimeout.milliseconds", (Object)10000, (String)"zkSessionTimeoutMillis");
    public static final Property<Integer> ZK_CONNECTION_TIMEOUT = Property.named((String)"zk.connect.sessionTimeout.milliseconds", (Object)10000, (String)"zkConnectionTimeoutMillis");
    public static final Property<String> ZK_METADATA_PATH = Property.named((String)"zk.metadata.path", (Object)"/segmentstore/containers", (String)"zkMetadataPath");
    public static final Property<Integer> ZK_HIERARCHY_DEPTH = Property.named((String)"zk.metadata.hierarchy.depth", (Object)2, (String)"zkHierarchyDepth");
    public static final Property<Integer> MAX_WRITE_ATTEMPTS = Property.named((String)"write.attempts.count.max", (Object)5, (String)"maxWriteAttempts");
    public static final Property<Integer> BK_ENSEMBLE_SIZE = Property.named((String)"ensemble.size", (Object)3, (String)"bkEnsembleSize");
    public static final Property<Integer> BK_ACK_QUORUM_SIZE = Property.named((String)"ack.quorum.size", (Object)2, (String)"bkAckQuorumSize");
    public static final Property<Integer> BK_WRITE_QUORUM_SIZE = Property.named((String)"write.quorum.size", (Object)3, (String)"bkWriteQuorumSize");
    public static final Property<Integer> BK_WRITE_TIMEOUT = Property.named((String)"write.timeout.milliseconds", (Object)60000, (String)"bkWriteTimeoutMillis");
    public static final Property<Integer> BK_READ_TIMEOUT = Property.named((String)"read.timeout.milliseconds", (Object)30000, (String)"bkReadTimeoutMillis");
    public static final Property<Integer> BK_READ_BATCH_SIZE = Property.named((String)"read.batch.size", (Object)64, (String)"readBatchSize");
    public static final Property<Integer> MAX_OUTSTANDING_BYTES = Property.named((String)"write.outstanding.bytes.max", (Object)0x10000000, (String)"maxOutstandingBytes");
    public static final Property<Integer> BK_LEDGER_MAX_SIZE = Property.named((String)"ledger.size.max", (Object)0x40000000, (String)"bkLedgerMaxSize");
    public static final Property<String> BK_PASSWORD = Property.named((String)"connect.security.auth.pwd", (Object)"", (String)"bkPass");
    public static final Property<String> BK_LEDGER_PATH = Property.named((String)"ledger.path", (Object)"", (String)"bkLedgerPath");
    public static final Property<Boolean> BK_TLS_ENABLED = Property.named((String)"connect.security.tls.enable", (Object)false, (String)"tlsEnabled");
    public static final Property<String> TLS_TRUST_STORE_PATH = Property.named((String)"connect.security.tls.trustStore.location", (Object)"config/client.truststore.jks", (String)"tlsTrustStorePath");
    public static final Property<String> TLS_TRUST_STORE_PASSWORD_PATH = Property.named((String)"connect.security.trustStore.pwd.location", (Object)"", (String)"tlsTrustStorePasswordPath");
    public static final Property<Boolean> BK_ENFORCE_MIN_NUM_RACKS_PER_WRITE = Property.named((String)"write.quorum.racks.minimumCount.enable", (Object)false, (String)"enforceMinNumRacksPerWriteQuorum");
    public static final Property<Integer> BK_MIN_NUM_RACKS_PER_WRITE_QUORUM = Property.named((String)"write.quorum.racks.count.min", (Object)2, (String)"minNumRacksPerWriteQuorum");
    public static final Property<String> BK_NETWORK_TOPOLOGY_SCRIPT_FILE_NAME = Property.named((String)"networkTopology.script.location", (Object)"/opt/pravega/scripts/sample-bookkeeper-topology.sh", (String)"networkTopologyScriptFileName");
    public static final Property<String> BK_DIGEST_TYPE = Property.named((String)"digest.type.name", (Object)DigestType.CRC32C.name(), (String)"digestType");
    public static final String COMPONENT_CODE = "bookkeeper";
    static final int MAX_APPEND_LENGTH = 1047552;
    private final String zkAddress;
    private final Duration zkSessionTimeout;
    private final Duration zkConnectionTimeout;
    private final String zkMetadataPath;
    private final int zkHierarchyDepth;
    private final int maxWriteAttempts;
    private final String bkLedgerPath;
    private final int bkEnsembleSize;
    private final int bkAckQuorumSize;
    private final int bkWriteQuorumSize;
    private final int bkWriteTimeoutMillis;
    private final int bkReadTimeoutMillis;
    private final int bkReadBatchSize;
    private final int maxOutstandingBytes;
    private final int bkLedgerMaxSize;
    private final byte[] bkPassword;
    private final boolean isTLSEnabled;
    private final String tlsTrustStore;
    private final String tlsTrustStorePasswordPath;
    private final boolean enforceMinNumRacksPerWriteQuorum;
    private final int minNumRacksPerWriteQuorum;
    private final String networkTopologyFileName;
    private final DigestType digestType;

    private BookKeeperConfig(TypedProperties properties) throws ConfigurationException {
        this.zkAddress = properties.get(ZK_ADDRESS).replace(",", ";");
        this.zkSessionTimeout = Duration.ofMillis(properties.getInt(ZK_SESSION_TIMEOUT));
        this.zkConnectionTimeout = Duration.ofMillis(properties.getInt(ZK_CONNECTION_TIMEOUT));
        this.zkMetadataPath = properties.get(ZK_METADATA_PATH);
        this.zkHierarchyDepth = properties.getInt(ZK_HIERARCHY_DEPTH);
        if (this.zkHierarchyDepth < 0) {
            throw new InvalidPropertyValueException(String.format("Property %s (%d) must be a non-negative integer.", ZK_HIERARCHY_DEPTH, this.zkHierarchyDepth));
        }
        this.maxWriteAttempts = properties.getInt(MAX_WRITE_ATTEMPTS);
        this.bkLedgerPath = properties.get(BK_LEDGER_PATH);
        this.bkEnsembleSize = properties.getInt(BK_ENSEMBLE_SIZE);
        this.bkAckQuorumSize = properties.getInt(BK_ACK_QUORUM_SIZE);
        this.bkWriteQuorumSize = properties.getInt(BK_WRITE_QUORUM_SIZE);
        if (this.bkWriteQuorumSize < this.bkAckQuorumSize) {
            throw new InvalidPropertyValueException(String.format("Property %s (%d) must be greater than or equal to %s (%d).", BK_WRITE_QUORUM_SIZE, this.bkWriteQuorumSize, BK_ACK_QUORUM_SIZE, this.bkAckQuorumSize));
        }
        this.bkWriteTimeoutMillis = properties.getInt(BK_WRITE_TIMEOUT);
        this.bkReadTimeoutMillis = properties.getInt(BK_READ_TIMEOUT);
        this.bkReadBatchSize = properties.getInt(BK_READ_BATCH_SIZE);
        if (this.bkReadBatchSize < 1) {
            throw new InvalidPropertyValueException(String.format("Property %s (%d) must be a positive integer.", BK_READ_BATCH_SIZE, this.bkReadBatchSize));
        }
        this.maxOutstandingBytes = properties.getInt(MAX_OUTSTANDING_BYTES);
        this.bkLedgerMaxSize = properties.getInt(BK_LEDGER_MAX_SIZE);
        this.bkPassword = properties.get(BK_PASSWORD).getBytes(StandardCharsets.UTF_8);
        this.isTLSEnabled = properties.getBoolean(BK_TLS_ENABLED);
        this.tlsTrustStore = properties.get(TLS_TRUST_STORE_PATH);
        this.tlsTrustStorePasswordPath = properties.get(TLS_TRUST_STORE_PASSWORD_PATH);
        this.enforceMinNumRacksPerWriteQuorum = properties.getBoolean(BK_ENFORCE_MIN_NUM_RACKS_PER_WRITE);
        this.minNumRacksPerWriteQuorum = properties.getInt(BK_MIN_NUM_RACKS_PER_WRITE_QUORUM);
        this.networkTopologyFileName = properties.get(BK_NETWORK_TOPOLOGY_SCRIPT_FILE_NAME);
        this.digestType = BookKeeperConfig.getDigestType(properties.get(BK_DIGEST_TYPE));
    }

    byte[] getBKPassword() {
        return Arrays.copyOf(this.bkPassword, this.bkPassword.length);
    }

    public static ConfigBuilder<BookKeeperConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, BookKeeperConfig::new);
    }

    static DigestType getDigestType(String digestType) {
        if (digestType.equals(DigestType.MAC.name())) {
            return DigestType.MAC;
        }
        if (digestType.equals(DigestType.CRC32.name())) {
            return DigestType.CRC32;
        }
        if (digestType.equals(DigestType.DUMMY.name())) {
            return DigestType.DUMMY;
        }
        return DigestType.CRC32C;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZkAddress() {
        return this.zkAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getZkMetadataPath() {
        return this.zkMetadataPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getZkHierarchyDepth() {
        return this.zkHierarchyDepth;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxWriteAttempts() {
        return this.maxWriteAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getBkLedgerPath() {
        return this.bkLedgerPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkEnsembleSize() {
        return this.bkEnsembleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkAckQuorumSize() {
        return this.bkAckQuorumSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkWriteQuorumSize() {
        return this.bkWriteQuorumSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkWriteTimeoutMillis() {
        return this.bkWriteTimeoutMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkReadTimeoutMillis() {
        return this.bkReadTimeoutMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkReadBatchSize() {
        return this.bkReadBatchSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxOutstandingBytes() {
        return this.maxOutstandingBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBkLedgerMaxSize() {
        return this.bkLedgerMaxSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTLSEnabled() {
        return this.isTLSEnabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTlsTrustStorePasswordPath() {
        return this.tlsTrustStorePasswordPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnforceMinNumRacksPerWriteQuorum() {
        return this.enforceMinNumRacksPerWriteQuorum;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMinNumRacksPerWriteQuorum() {
        return this.minNumRacksPerWriteQuorum;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNetworkTopologyFileName() {
        return this.networkTopologyFileName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DigestType getDigestType() {
        return this.digestType;
    }
}

