/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.segmentstore.storage.DataLogNotAvailableException;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.DurableDataLogFactory;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperLog;
import io.pravega.segmentstore.storage.impl.bookkeeper.DebugLogWrapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.apache.bookkeeper.client.DefaultEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperLogFactory
implements DurableDataLogFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BookKeeperLogFactory.class);
    private static final Duration LOG_CREATION_INSPECTION_PERIOD = Duration.ofSeconds(60L);
    private static final int MAX_CREATE_ATTEMPTS_PER_LOG = 2;
    private final String namespace;
    private final CuratorFramework zkClient;
    private final AtomicReference<BookKeeper> bookKeeper;
    private final BookKeeperConfig config;
    private final ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private final Map<Integer, LogInitializationRecord> logInitializationTracker = new HashMap<Integer, LogInitializationRecord>();
    @GuardedBy(value="this")
    private final AtomicReference<Timer> lastBookkeeperClientReset = new AtomicReference<Timer>(new Timer());

    public BookKeeperLogFactory(BookKeeperConfig config, CuratorFramework zkClient, ScheduledExecutorService executor) {
        this.config = (BookKeeperConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.namespace = zkClient.getNamespace();
        this.zkClient = ((CuratorFramework)Preconditions.checkNotNull((Object)zkClient, (Object)"zkClient")).usingNamespace(this.namespace + this.config.getZkMetadataPath());
        this.bookKeeper = new AtomicReference();
    }

    public void close() {
        BookKeeper bk = this.bookKeeper.getAndSet(null);
        if (bk != null) {
            try {
                bk.close();
            }
            catch (Exception ex) {
                log.error("Unable to close BookKeeper client.", (Throwable)ex);
            }
        }
    }

    public void initialize() throws DurableDataLogException {
        Preconditions.checkState((this.bookKeeper.get() == null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is already initialized.");
        try {
            this.bookKeeper.set(this.startBookKeeperClient());
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            if (!Exceptions.mustRethrow((Throwable)ex)) {
                this.close();
            }
            throw new DataLogNotAvailableException("Unable to establish connection to ZooKeeper or BookKeeper.", ex);
        }
    }

    public DurableDataLog createDurableDataLog(int logId) {
        Preconditions.checkState((this.bookKeeper.get() != null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is not initialized.");
        this.tryResetBookkeeperClient(logId);
        return new BookKeeperLog(logId, this.zkClient, this.bookKeeper.get(), this.config, this.executor);
    }

    public DebugLogWrapper createDebugLogWrapper(int logId) {
        Preconditions.checkState((this.bookKeeper.get() != null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is not initialized.");
        this.tryResetBookkeeperClient(logId);
        return new DebugLogWrapper(logId, this.zkClient, this.bookKeeper.get(), this.config, this.executor);
    }

    @VisibleForTesting
    public BookKeeper getBookKeeperClient() {
        return this.bookKeeper.get();
    }

    private BookKeeper startBookKeeperClient() throws Exception {
        int writeTimeout = (int)Math.ceil((double)this.config.getBkWriteTimeoutMillis() / 1000.0);
        int readTimeout = (int)Math.ceil((double)this.config.getBkReadTimeoutMillis() / 1000.0);
        ClientConfiguration config = (ClientConfiguration)new ClientConfiguration().setClientTcpNoDelay(true).setAddEntryTimeout(writeTimeout).setReadEntryTimeout(readTimeout).setGetBookieInfoTimeout(readTimeout).setEnableDigestTypeAutodetection(true).setClientConnectTimeoutMillis((int)this.config.getZkConnectionTimeout().toMillis()).setZkTimeout((int)this.config.getZkConnectionTimeout().toMillis());
        if (this.config.isTLSEnabled()) {
            config = (ClientConfiguration)config.setTLSProvider("OpenSSL");
            config = config.setTLSTrustStore(this.config.getTlsTrustStore());
            config.setTLSTrustStorePasswordPath(this.config.getTlsTrustStorePasswordPath());
        }
        String metadataServiceUri = "zk://" + this.config.getZkAddress();
        metadataServiceUri = this.config.getBkLedgerPath().isEmpty() ? metadataServiceUri + "/" + this.namespace + "/bookkeeper/ledgers" : metadataServiceUri + this.config.getBkLedgerPath();
        config = (ClientConfiguration)config.setMetadataServiceUri(metadataServiceUri);
        if (this.config.isEnforceMinNumRacksPerWriteQuorum()) {
            config = config.setEnsemblePlacementPolicy(RackawareEnsemblePlacementPolicy.class);
            config.setEnforceMinNumRacksPerWriteQuorum(this.config.isEnforceMinNumRacksPerWriteQuorum());
            config.setMinNumRacksPerWriteQuorum(this.config.getMinNumRacksPerWriteQuorum());
            config.setProperty("networkTopologyScriptFileName", (Object)this.config.getNetworkTopologyFileName());
        } else {
            config = config.setEnsemblePlacementPolicy(DefaultEnsemblePlacementPolicy.class);
        }
        return BookKeeper.newBuilder((ClientConfiguration)config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryResetBookkeeperClient(int logId) {
        BookKeeperLogFactory bookKeeperLogFactory = this;
        synchronized (bookKeeperLogFactory) {
            LogInitializationRecord record = this.logInitializationTracker.get(logId);
            if (record != null) {
                record.incrementLogCreations();
                if (record.isBookkeeperClientResetNeeded() && this.lastBookkeeperClientReset.get().getElapsed().compareTo(LOG_CREATION_INSPECTION_PERIOD) > 0) {
                    try {
                        log.info("Start creating Bookkeeper client in reset.");
                        BookKeeper newClient = this.startBookKeeperClient();
                        log.info("Successfully created new Bookkeeper client, setting it as the new one to use.");
                        BookKeeper oldClient = this.bookKeeper.getAndSet(newClient);
                        this.lastBookkeeperClientReset.set(new Timer());
                        log.info("Attempting to close old client.");
                        oldClient.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failure resetting the Bookkeeper client", e);
                    }
                }
            } else {
                this.logInitializationTracker.put(logId, new LogInitializationRecord());
            }
        }
    }

    @VisibleForTesting
    public Map<Integer, LogInitializationRecord> getLogInitializationTracker() {
        return this.logInitializationTracker;
    }

    @VisibleForTesting
    public void setLastBookkeeperClientReset(Timer timer) {
        this.lastBookkeeperClientReset.set(timer);
    }

    static class LogInitializationRecord {
        private final AtomicReference<Timer> timer = new AtomicReference<Timer>(new Timer());
        private final AtomicInteger counter = new AtomicInteger(0);

        LogInitializationRecord() {
        }

        boolean isBookkeeperClientResetNeeded() {
            return this.timer.get().getElapsed().compareTo(LOG_CREATION_INSPECTION_PERIOD) < 0 && this.counter.get() >= 2;
        }

        void incrementLogCreations() {
            if (this.timer.get().getElapsed().compareTo(LOG_CREATION_INSPECTION_PERIOD) > 0) {
                this.timer.set(new Timer());
                this.counter.set(1);
            } else {
                this.counter.incrementAndGet();
            }
        }
    }
}

