/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;

final class BookKeeperMetrics {
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"bookkeeper");
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();

    BookKeeperMetrics() {
    }

    static final class BookKeeperLog
    implements AutoCloseable {
        private final OpStatsLogger writeQueueSize;
        private final OpStatsLogger writeQueueFillRate;
        private final OpStatsLogger writeLatency;
        private final OpStatsLogger totalWriteLatency;
        private final Counter bkWriteBytes;
        private final String[] containerTag;

        BookKeeperLog(int containerId) {
            this.containerTag = MetricsTags.containerTag((int)containerId);
            this.writeQueueSize = STATS_LOGGER.createStats("pravega.segmentstore.bookkeeper.write_queue_size", this.containerTag);
            this.writeQueueFillRate = STATS_LOGGER.createStats("pravega.segmentstore.bookkeeper.write_queue_fill", this.containerTag);
            this.writeLatency = STATS_LOGGER.createStats("pravega.segmentstore.bookkeeper.write_latency_ms", this.containerTag);
            this.totalWriteLatency = STATS_LOGGER.createStats("pravega.segmentstore.bookkeeper.total_write_latency_ms", this.containerTag);
            this.bkWriteBytes = STATS_LOGGER.createCounter("pravega.segmentstore.bookkeeper.write_bytes", this.containerTag);
        }

        @Override
        public void close() {
            this.writeQueueSize.close();
            this.writeQueueFillRate.close();
            this.writeLatency.close();
            this.totalWriteLatency.close();
            this.bkWriteBytes.close();
        }

        void ledgerCount(int count) {
            DYNAMIC_LOGGER.reportGaugeValue("pravega.segmentstore.bookkeeper.ledger_count", (Number)count, this.containerTag);
        }

        void queueStats(QueueStats qs) {
            this.writeQueueSize.reportSuccessValue((long)qs.getSize());
            this.writeQueueFillRate.reportSuccessValue((long)((int)(qs.getAverageItemFillRatio() * 100.0)));
        }

        void writeCompleted(Duration elapsed) {
            this.totalWriteLatency.reportSuccessEvent(elapsed);
        }

        void bookKeeperWriteCompleted(int length, Duration elapsed) {
            this.writeLatency.reportSuccessEvent(elapsed);
            this.bkWriteBytes.add((long)length);
        }
    }
}

