/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.CloseableIterator;
import io.pravega.common.util.CompositeArrayView;
import io.pravega.segmentstore.storage.DataLogInitializationException;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import io.pravega.segmentstore.storage.WriteSettings;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperLog;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.Ledgers;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogReader;
import io.pravega.segmentstore.storage.impl.bookkeeper.ReadOnlyLogMetadata;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.Handle;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.curator.framework.CuratorFramework;

public class DebugLogWrapper
implements AutoCloseable {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final BookKeeperLog log;
    private final BookKeeper bkClient;
    private final BookKeeperConfig config;
    private final AtomicBoolean initialized;

    DebugLogWrapper(int logId, CuratorFramework zkClient, BookKeeper bookKeeper, BookKeeperConfig config, ScheduledExecutorService executor) {
        this.log = new BookKeeperLog(logId, zkClient, bookKeeper, config, executor);
        this.bkClient = bookKeeper;
        this.config = config;
        this.initialized = new AtomicBoolean();
    }

    @Override
    public void close() {
        this.log.close();
    }

    public DurableDataLog asReadOnly() throws DataLogInitializationException {
        return new ReadOnlyBooKeeperLog(this.log.getLogId(), this.log.loadMetadata());
    }

    public ReadOnlyLogMetadata fetchMetadata() throws DataLogInitializationException {
        return this.log.loadMetadata();
    }

    public ReadHandle openLedgerNoFencing(LedgerMetadata ledgerMetadata) throws DurableDataLogException {
        return Ledgers.openRead(ledgerMetadata.getLedgerId(), this.bkClient, this.config);
    }

    public void enable() throws DurableDataLogException {
        this.log.enable();
    }

    public void disable() throws DurableDataLogException {
        this.initialize();
        this.log.disable();
    }

    public boolean reconcileLedgers(List<? extends ReadHandle> candidateLedgers) throws DurableDataLogException {
        boolean changed;
        long highestLedgerId;
        LogMetadata metadata = this.log.loadMetadata();
        if (metadata != null) {
            Preconditions.checkState((!metadata.isEnabled() ? 1 : 0) != 0, (Object)"BookKeeperLog is enabled; cannot reconcile ledgers.");
            int ledgerCount = metadata.getLedgers().size();
            highestLedgerId = ledgerCount > 0 ? metadata.getLedgers().get(ledgerCount - 1).getLedgerId() : (metadata.getTruncationAddress() != null ? metadata.getTruncationAddress().getLedgerId() : -1L);
        } else {
            highestLedgerId = -1L;
        }
        candidateLedgers = candidateLedgers.stream().filter(lh -> Ledgers.getBookKeeperLogId((Handle)lh) == this.log.getLogId() && lh.getLength() > 0L).collect(Collectors.toList());
        ArrayList<LedgerMetadata> newLedgerList = new ArrayList<LedgerMetadata>();
        if (metadata != null) {
            Set candidateLedgerIds = candidateLedgers.stream().map(Handle::getId).collect(Collectors.toSet());
            metadata.getLedgers().stream().filter(lm -> candidateLedgerIds.contains(lm.getLedgerId())).forEach(newLedgerList::add);
        }
        AtomicInteger seq = new AtomicInteger(newLedgerList.isEmpty() ? 0 : ((LedgerMetadata)newLedgerList.get(newLedgerList.size() - 1)).getSequence());
        candidateLedgers.stream().filter(lh -> lh.getId() > highestLedgerId).forEach(lh -> newLedgerList.add(new LedgerMetadata(lh.getId(), seq.incrementAndGet())));
        newLedgerList.sort(Comparator.comparingLong(LedgerMetadata::getLedgerId));
        boolean bl = changed = metadata == null || metadata.getLedgers().size() != newLedgerList.size();
        if (!changed) {
            for (int i = 0; i < newLedgerList.size(); ++i) {
                if (metadata.getLedgers().get(i).getLedgerId() == ((LedgerMetadata)newLedgerList.get(i)).getLedgerId()) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            LogMetadata newMetadata = LogMetadata.builder().enabled(false).epoch(this.getOrDefault(metadata, LogMetadata::getEpoch, 1L) + 1L).truncationAddress(this.getOrDefault(metadata, LogMetadata::getTruncationAddress, LogMetadata.INITIAL_TRUNCATION_ADDRESS)).updateVersion(this.getOrDefault(metadata, LogMetadata::getUpdateVersion, -1)).ledgers(newLedgerList).build();
            this.log.overWriteMetadata(newMetadata);
        }
        return changed;
    }

    private void initialize() throws DurableDataLogException {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.log.initialize(DEFAULT_TIMEOUT);
            }
            catch (Exception ex) {
                this.initialized.set(false);
                throw ex;
            }
        }
    }

    private <T> T getOrDefault(LogMetadata metadata, Function<LogMetadata, T> getter, T defaultValue) {
        return metadata == null ? defaultValue : getter.apply(metadata);
    }

    private class ReadOnlyBooKeeperLog
    implements DurableDataLog {
        private final int logId;
        private final LogMetadata logMetadata;

        public void close() {
        }

        public CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> getReader() {
            return new LogReader(this.logId, this.logMetadata, DebugLogWrapper.this.bkClient, DebugLogWrapper.this.config);
        }

        public WriteSettings getWriteSettings() {
            return new WriteSettings(1047552, Duration.ofMillis(((Integer)BookKeeperConfig.BK_WRITE_TIMEOUT.getDefaultValue()).intValue()), ((Integer)BookKeeperConfig.MAX_OUTSTANDING_BYTES.getDefaultValue()).intValue());
        }

        public long getEpoch() {
            return this.logMetadata.getEpoch();
        }

        public QueueStats getQueueStatistics() {
            return null;
        }

        public void registerQueueStateChangeListener(ThrottleSourceListener listener) {
            throw new UnsupportedOperationException();
        }

        public void initialize(Duration timeout) {
            throw new UnsupportedOperationException();
        }

        public void enable() {
            throw new UnsupportedOperationException();
        }

        public void disable() {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<LogAddress> append(CompositeArrayView data, Duration timeout) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> truncate(LogAddress upToAddress, Duration timeout) {
            throw new UnsupportedOperationException();
        }

        @ConstructorProperties(value={"logId", "logMetadata"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ReadOnlyBooKeeperLog(int logId, LogMetadata logMetadata) {
            this.logId = logId;
            this.logMetadata = logMetadata;
        }
    }
}

