/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.segmentstore.storage.DataLogNotAvailableException;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import lombok.Generated;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.Handle;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ledgers {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Ledgers.class);
    static final Charset CUSTOM_PROPERTY_CHARSET = Charsets.US_ASCII;
    static final String PROPERTY_APPLICATION = "application";
    static final String PROPERTY_VALUE_APPLICATION = "Pravega";
    static final String PROPERTY_LOG_ID = "BookKeeperLogId";
    static final int NO_LOG_ID = -1;
    static final long NO_LEDGER_ID = -1L;
    static final long NO_ENTRY_ID = -1L;
    static final int MIN_FENCE_LEDGER_COUNT = 2;
    private static final Function<Throwable, BKException> BK_EXCEPTION_HANDLER = cause -> {
        if (cause instanceof BKException) {
            return (BKException)((Object)cause);
        }
        BKException.BKUnexpectedConditionException wrapper = new BKException.BKUnexpectedConditionException();
        wrapper.initCause(cause);
        return wrapper;
    };

    static WriteHandle create(BookKeeper bookKeeper, BookKeeperConfig config, int logId) throws DurableDataLogException {
        try {
            CompletableFuture future = bookKeeper.newCreateLedgerOp().withEnsembleSize(config.getBkEnsembleSize()).withWriteQuorumSize(config.getBkWriteQuorumSize()).withAckQuorumSize(config.getBkAckQuorumSize()).withDigestType(config.getDigestType()).withPassword(config.getBKPassword()).withCustomMetadata(Ledgers.createLedgerCustomMetadata(logId)).execute();
            return (WriteHandle)Futures.getAndHandleExceptions((Future)future, BK_EXCEPTION_HANDLER, (long)config.getBkWriteTimeoutMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (BKException.BKNotEnoughBookiesException bkEx) {
            throw new DataLogNotAvailableException("Unable to create new BookKeeper Ledger.", (Throwable)bkEx);
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException("Unable to create new BookKeeper Ledger.", (Throwable)bkEx);
        }
        catch (TimeoutException e) {
            throw new DataLogNotAvailableException("Unable to create new BookKeeper Ledger before timeout.", (Throwable)e);
        }
    }

    static ReadHandle openFence(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        try {
            return (ReadHandle)Exceptions.handleInterruptedCall(() -> (ReadHandle)FutureUtils.result((CompletableFuture)bookKeeper.newOpenLedgerOp().withLedgerId(ledgerId).withPassword(config.getBKPassword()).withRecovery(true).execute(), BK_EXCEPTION_HANDLER));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to open-fence ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    public static ReadHandle openRead(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        try {
            return (ReadHandle)Exceptions.handleInterruptedCall(() -> (ReadHandle)FutureUtils.result((CompletableFuture)bookKeeper.newOpenLedgerOp().withLedgerId(ledgerId).withPassword(config.getBKPassword()).withRecovery(false).execute(), BK_EXCEPTION_HANDLER));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to open-read ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLastAddConfirmed(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        ReadHandle h = null;
        try {
            h = Ledgers.openFence(ledgerId, bookKeeper, config);
            long l = h.getLastAddConfirmed();
            return l;
        }
        finally {
            if (h != null) {
                Ledgers.close((Handle)h);
            }
        }
    }

    static void close(Handle handle) throws DurableDataLogException {
        try {
            Exceptions.handleInterrupted(() -> ((Handle)handle).close());
        }
        catch (Exception bkEx) {
            throw new DurableDataLogException(String.format("Unable to close ledger %d.", handle.getId()), (Throwable)bkEx);
        }
    }

    static void delete(long ledgerId, BookKeeper bookKeeper) throws DurableDataLogException {
        try {
            Exceptions.handleInterrupted(() -> FutureUtils.result((CompletableFuture)bookKeeper.newDeleteLedgerOp().withLedgerId(ledgerId).execute(), BK_EXCEPTION_HANDLER));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to delete Ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    static Map<Long, Long> fenceOut(List<LedgerMetadata> ledgers, BookKeeper bookKeeper, BookKeeperConfig config, String traceObjectId) throws DurableDataLogException {
        int nonEmptyCount = 0;
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        ListIterator<LedgerMetadata> iterator = ledgers.listIterator(ledgers.size());
        while (iterator.hasPrevious() && nonEmptyCount < 2) {
            ReadHandle handle;
            LedgerMetadata ledgerMetadata = iterator.previous();
            try {
                handle = Ledgers.openFence(ledgerMetadata.getLedgerId(), bookKeeper, config);
            }
            catch (DurableDataLogException ex) {
                Throwable c = ex.getCause();
                if (ledgerMetadata.getStatus() == LedgerMetadata.Status.Empty && (c instanceof BKException.BKNoSuchLedgerExistsOnMetadataServerException || c instanceof BKException.BKNoSuchLedgerExistsException)) {
                    log.warn("{}: Unable to open-fence EMPTY ledger {}. Skipping.", new Object[]{traceObjectId, ledgerMetadata, ex});
                    continue;
                }
                throw ex;
            }
            if (handle.getLastAddConfirmed() != -1L) {
                ++nonEmptyCount;
            }
            if (ledgerMetadata.getStatus() == LedgerMetadata.Status.Unknown) {
                result.put(ledgerMetadata.getLedgerId(), handle.getLastAddConfirmed());
            }
            Ledgers.close((Handle)handle);
            log.info("{}: Fenced out Ledger {}.", (Object)traceObjectId, (Object)ledgerMetadata);
        }
        return result;
    }

    public static int getBookKeeperLogId(Handle handle) {
        String appName = Ledgers.getPropertyValue(PROPERTY_APPLICATION, handle);
        if (appName == null || !appName.equalsIgnoreCase(PROPERTY_VALUE_APPLICATION)) {
            log.warn("Property '{}' on Ledger {} does not match expected value '{}' (actual '{}'). This is OK if this ledger was created prior to Pravega 0.7.1.", new Object[]{PROPERTY_APPLICATION, handle.getId(), PROPERTY_VALUE_APPLICATION, appName});
            return -1;
        }
        String deserialized = Ledgers.getPropertyValue(PROPERTY_LOG_ID, handle);
        if (deserialized == null) {
            log.warn("No property '{}' found on Ledger {}. This is OK if this ledger was created prior to Pravega 0.7.1.", (Object)PROPERTY_LOG_ID, (Object)handle.getId());
            return -1;
        }
        try {
            return Integer.parseInt(deserialized);
        }
        catch (NumberFormatException ex) {
            log.error("Property '{}' Ledger {} has invalid value '{}'. Returning default value.", new Object[]{PROPERTY_LOG_ID, handle.getId(), deserialized});
            return -1;
        }
    }

    private static String getPropertyValue(String property, Handle handle) {
        byte[] s = handle.getLedgerMetadata().getCustomMetadata().getOrDefault(property, null);
        return s == null ? null : new String(s, CUSTOM_PROPERTY_CHARSET);
    }

    @VisibleForTesting
    static Map<String, byte[]> createLedgerCustomMetadata(int logId) {
        return ImmutableMap.builder().put((Object)PROPERTY_APPLICATION, (Object)PROPERTY_VALUE_APPLICATION.getBytes(CUSTOM_PROPERTY_CHARSET)).put((Object)PROPERTY_LOG_ID, (Object)Integer.toString(logId).getBytes(CUSTOM_PROPERTY_CHARSET)).build();
    }
}

