/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.pravega.common.Exceptions;
import io.pravega.common.util.BufferedIterator;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.storage.DataLogCorruptedException;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.Ledgers;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogMetadata;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.client.api.Handle;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class LogReader
implements CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);
    private final int logId;
    private final BookKeeper bookKeeper;
    private final LogMetadata metadata;
    private final AtomicBoolean closed;
    private final BookKeeperConfig config;
    private ReadLedger currentLedger;

    LogReader(int logId, LogMetadata metadata, BookKeeper bookKeeper, BookKeeperConfig config) {
        this.logId = logId;
        this.metadata = (LogMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.bookKeeper = (BookKeeper)Preconditions.checkNotNull((Object)bookKeeper, (Object)"bookKeeper");
        this.config = (BookKeeperConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.closed = new AtomicBoolean();
    }

    public void close() {
        if (!this.closed.getAndSet(true) && this.currentLedger != null) {
            this.currentLedger.close();
            this.currentLedger = null;
        }
    }

    public DurableDataLog.ReadItem getNext() throws DurableDataLogException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (this.currentLedger == null) {
            this.openNextLedger(this.metadata.getNextAddress(this.metadata.getTruncationAddress(), Long.MAX_VALUE));
        }
        while (this.currentLedger != null && !this.currentLedger.canRead()) {
            LedgerAddress lastAddress = new LedgerAddress(this.currentLedger.metadata, this.currentLedger.handle.getLastAddConfirmed());
            this.currentLedger.close();
            this.openNextLedger(this.metadata.getNextAddress(lastAddress, this.currentLedger.handle.getLastAddConfirmed()));
        }
        if (this.currentLedger == null || this.currentLedger.isEmpty()) {
            return null;
        }
        return LogReader.wrapItem((LedgerEntry)this.currentLedger.reader.next(), this.currentLedger.metadata);
    }

    private void openNextLedger(LedgerAddress address) throws DurableDataLogException {
        if (address == null) {
            this.close();
            return;
        }
        LedgerMetadata metadata = this.metadata.getLedger(address.getLedgerId());
        assert (metadata != null) : "no LedgerMetadata could be found with valid LedgerAddress " + address;
        List<LedgerMetadata> allMetadatas = this.metadata.getLedgers();
        ReadHandle ledger = allMetadatas.size() == 0 || metadata == allMetadatas.get(allMetadatas.size() - 1) ? Ledgers.openRead(metadata.getLedgerId(), this.bookKeeper, this.config) : Ledgers.openFence(metadata.getLedgerId(), this.bookKeeper, this.config);
        this.checkLogIdProperty((Handle)ledger);
        long lastEntryId = ledger.getLastAddConfirmed();
        if (lastEntryId < address.getEntryId()) {
            Ledgers.close((Handle)ledger);
            this.currentLedger = ReadLedger.empty(metadata, ledger);
            return;
        }
        try {
            ReadLedger previousLedger = this.currentLedger;
            this.currentLedger = new ReadLedger(metadata, ledger, address.getEntryId(), lastEntryId, this.config.getBkReadBatchSize());
            if (previousLedger != null) {
                previousLedger.close();
            }
        }
        catch (Exception ex) {
            Ledgers.close((Handle)ledger);
            this.close();
            throw new DurableDataLogException("Error while reading from BookKeeper.", (Throwable)ex);
        }
    }

    private void checkLogIdProperty(Handle handle) throws DataLogCorruptedException {
        int actualLogId = Ledgers.getBookKeeperLogId(handle);
        if (actualLogId != -1 && actualLogId != this.logId) {
            throw new DataLogCorruptedException(String.format("BookKeeperLog %s contains ledger %s which belongs to BookKeeperLog %s.", this.logId, handle.getId(), actualLogId));
        }
    }

    private static DurableDataLog.ReadItem wrapItem(LedgerEntry entry, LedgerMetadata metadata) {
        ByteBuf content = entry.getEntryBuffer();
        return new ReadItem(entry.getEntryId(), (InputStream)new ByteBufInputStream(content, false), content.readableBytes(), metadata);
    }

    private static class ReadLedger {
        final LedgerMetadata metadata;
        final ReadHandle handle;
        final BufferedIterator<LedgerEntry> reader;
        final AtomicBoolean closed = new AtomicBoolean(false);
        volatile LedgerEntries currentLedgerEntries;

        public ReadLedger(LedgerMetadata metadata, ReadHandle handle, long firstEntryId, long lastEntryId, int batchSize) {
            this.metadata = metadata;
            this.handle = handle;
            this.reader = lastEntryId >= firstEntryId ? new BufferedIterator(this::readRange, firstEntryId, lastEntryId, batchSize) : null;
        }

        boolean isEmpty() {
            return this.reader == null;
        }

        private void close() {
            if (this.closed.compareAndSet(false, true)) {
                if (this.currentLedgerEntries != null) {
                    this.currentLedgerEntries.close();
                }
                try {
                    Ledgers.close((Handle)this.handle);
                }
                catch (DurableDataLogException bkEx) {
                    log.error("Unable to close ReadHandle for Ledger {}.", (Object)this.handle.getId(), (Object)bkEx);
                }
            }
        }

        private Iterator<LedgerEntry> readRange(long fromEntryId, long toEntryId) {
            if (this.currentLedgerEntries != null) {
                this.currentLedgerEntries.close();
            }
            this.currentLedgerEntries = (LedgerEntries)Exceptions.handleInterruptedCall(() -> this.handle.read(fromEntryId, toEntryId));
            return this.currentLedgerEntries.iterator();
        }

        static ReadLedger empty(@NonNull LedgerMetadata metadata, @NonNull ReadHandle handle) {
            if (metadata == null) {
                throw new NullPointerException("metadata is marked non-null but is null");
            }
            if (handle == null) {
                throw new NullPointerException("handle is marked non-null but is null");
            }
            return new ReadLedger(metadata, handle, Long.MAX_VALUE, Long.MIN_VALUE, 1);
        }

        boolean canRead() {
            return this.reader != null && this.reader.hasNext();
        }
    }

    private static class ReadItem
    implements DurableDataLog.ReadItem {
        private final InputStream payload;
        private final int length;
        private final LedgerAddress address;

        ReadItem(long entryId, InputStream payload, int length, LedgerMetadata ledgerMetadata) {
            this.address = new LedgerAddress(ledgerMetadata, entryId);
            this.payload = payload;
            this.length = length;
        }

        public String toString() {
            return String.format("%s, Length = %d.", this.address, this.length);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InputStream getPayload() {
            return this.payload;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LedgerAddress getAddress() {
            return this.address;
        }
    }
}

